/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap.protocol;

import java.util.Vector;

/**
 * ̃NX͗lXȃbZ[Ẅׂ 'start'  'end' ێ܂B
 */
public final class MessageSet {

	public int start;
	public int end;

	/**
	 * ftHgRXgN^łB
	 */
	public MessageSet() {}

	/**
	 * RXgN^łB
	 */
	public MessageSet(final int start, final int end) {
		this.start = start;
		this.end = end;
	}

	/**
	 * MessageSet ̗vf̑Ԃ܂B
	 **/
	public int size() {
		return (end - start) + 1;
	}

	/*
	 * Convert an array of integers into an array of MessageSets
	 */
	public static MessageSet[] createMessageSets(final int[] msgs) {
		Vector v = new Vector();

		for (int i = 0; i < msgs.length; i++) {
			MessageSet ms = new MessageSet();
			ms.start = msgs[i];

			// Look for contiguous elements
			int j;
			for (j = i + 1; j < msgs.length; j++)
				if (msgs[j] != msgs[j - 1] + 1)
					break;

			ms.end = msgs[j - 1];
			v.addElement(ms);
			i = j - 1; // i gets incremented @ top of the loop
		}

		MessageSet[] msgsets = new MessageSet[v.size()];	
		v.copyInto(msgsets);
		return msgsets;
	}

	/**
	 * MessageSet ̔zϊ܂B
	 */
	public static String toString(final MessageSet[] msgsets) {
		if (msgsets == null || msgsets.length == 0)	// ̃bZ[WZbg
			return null; 

		int i = 0;	// bZ[WZbgCfbNX
		StringBuffer s = new StringBuffer();
		int size = msgsets.length;

		do {
			int start = msgsets[i].start;
			int end = msgsets[i].end;

			if (end > start)
				s.append(start).append(':').append(end);
			else // end == start means only one element
				s.append(start);

			if (++i < size)
				s.append(',');
			else
				return s.toString();
		} while (true);
	}

	/*
	 * Count the total number of elements in an array of MessageSets
	 */
	public static int size(final MessageSet[] msgsets) {
		int count = 0;

		if (msgsets == null) // Null msgset
			return 0; 

		for (int i=0; i < msgsets.length; i++)
			count += msgsets[i].size();

		return count;
	}

}
