/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap.protocol;

import java.io.UnsupportedEncodingException;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;

import jp.sourceforge.livez.mail.util.WindowsEUCJP;
import jp.sourceforge.livez.mail.util.WindowsJIS;

public final class Status {

	public String mbox = null;
	public int total = -1;
	public int recent = -1;
	public long uidnext = -1;
	public long uidvalidity = -1;
	public int unseen = -1;

	public static String[] standardItems =
		{ "MESSAGES", "RECENT", "UNSEEN", "UIDNEXT", "UIDVALIDITY" };

	/**
	 * RXgN^łB
	 */
	public Status(final Response r) throws ParsingException {
		// Sugisawa added. 2005/04/14
		this(r, null);
/* Sugisawa changed. 2005/04/14
		mbox = r.readAtomString(); // mailbox := astring
		r.skipSpaces();
		if (r.readByte() != '(')
			throw new ParsingException("parse error in STATUS");

		do {
			String attr = r.readAtom();
			if (attr.equalsIgnoreCase("MESSAGES"))
				total = r.readNumber();
			else if (attr.equalsIgnoreCase("RECENT"))
				recent = r.readNumber();
			else if (attr.equalsIgnoreCase("UIDNEXT"))
				uidnext = r.readLong();
			else if (attr.equalsIgnoreCase("UIDVALIDITY"))
				uidvalidity = r.readLong();
			else if (attr.equalsIgnoreCase("UNSEEN"))
				unseen = r.readNumber();
		} while (r.readByte() != ')');
*/
	}

	/**
	 * tH_pZbgw肪\ȃRXgN^łB
	 * 
	 * @since Sugisawa added. 2005/04/14
	 */
	public Status(final Response r, final String charset) throws ParsingException {
		if (charset == null)
			mbox = r.readAtomString(); // mailbox := astring
		else {
			byte[] bytes = r.readByteArray().getNewBytes();
			try {
				if ("euc-jp".equalsIgnoreCase(charset))
					mbox = WindowsEUCJP.decode(bytes);
				else if ("iso-2022-jp".equalsIgnoreCase(charset))
					mbox = WindowsJIS.decode(bytes);
				else if ("Shift_JIS".equalsIgnoreCase(charset))
					mbox = new String(bytes, "Windows-31J");
				else
					mbox = new String(bytes, charset);
			} catch (UnsupportedEncodingException e) {
				throw new ParsingException(e.getMessage());
			}
		}

		r.skipSpaces();
		if (r.readByte() != '(')
			throw new ParsingException("parse error in STATUS");

		do {
			String attr = r.readAtom();
			if (attr.equalsIgnoreCase("MESSAGES"))
				total = r.readNumber();
			else if (attr.equalsIgnoreCase("RECENT"))
				recent = r.readNumber();
			else if (attr.equalsIgnoreCase("UIDNEXT"))
				uidnext = r.readLong();
			else if (attr.equalsIgnoreCase("UIDVALIDITY"))
				uidvalidity = r.readLong();
			else if (attr.equalsIgnoreCase("UNSEEN"))
				unseen = r.readNumber();
		} while (r.readByte() != ')');
	}

	public static void add(final Status s1, final Status s2) {
		if (s2.total != -1)
			s1.total = s2.total;
		if (s2.recent != -1)
			s1.recent = s2.recent;
		if (s2.uidnext != -1)
			s1.uidnext = s2.uidnext;
		if (s2.uidvalidity != -1)
			s1.uidvalidity = s2.uidvalidity;
		if (s2.unseen != -1)
			s1.unseen = s2.unseen;
	}

}
