package com.sun.mail.imap.protocol;

import java.util.Vector;

public final class UIDSet {

	public long start;
	public long end;

	public UIDSet() {}

	public UIDSet(final long start, final long end) {
		this.start = start;
		this.end = end;
	}

	public long size() {
		return (end - start) + 1;
	}

	public static UIDSet[] createUIDSets(final long al[]) {
		Vector vector = new Vector();
		for (int i = 0; i < al.length; i++) {
			UIDSet uidset = new UIDSet();
			uidset.start = al[i];
			int j;
			for (j = i + 1; j < al.length; j++)
				if (al[j] != al[j - 1] + 1L)
					break;

			uidset.end = al[j - 1];
			vector.addElement(uidset);
			i = j - 1;
		}

		UIDSet[] uidsets = new UIDSet[vector.size()];
		vector.copyInto(uidsets);
		return uidsets;
	}

	public static String toString(final UIDSet[] uidsets) {
		if (uidsets == null || uidsets.length == 0)
			return null;

		int i = 0;
		StringBuffer sb = new StringBuffer();
		int length = uidsets.length;

		do {
			long start = uidsets[i].start;
			long end = uidsets[i].end;

			if (end > start)
				sb.append(start).append(':').append(end);
			else
				sb.append(start);

			if (++i < length)
				sb.append(',');
			else
				return sb.toString();
		} while (true);
	}

	public static long size(final UIDSet[] uidsets) {
		if (uidsets == null)
			return 0;

		long size = 0;
		for (int i = 0; i < uidsets.length; i++)
			size += uidsets[i].size();

		return size;
	}

}
