/*
 * Copyright 1997-1998 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.pop3;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;

/**
 * POP3  DefaultFolder łB
 * "INBOX" tH_܂ނłB
 */
public final class DefaultFolder extends Folder {

	/**
	 * RXgN^łB
	 */
	DefaultFolder(final POP3Store store) {
		super(store);
	}

	public String getName() {
		return "";
	}

	public String getFullName() {
		return "";
	}

	public Folder getParent() {
		return null;
	}

	public boolean exists() {
		return true;
	}

	public Folder[] list(final String pattern) throws MessagingException {
		Folder[] f = { getInbox() };
		return f;
	}

	public char getSeparator() {
		return '/';
	}

	public int getType() {
		return HOLDS_FOLDERS;
	}

	public boolean create(final int type) throws MessagingException {
		return false;
	}

	public boolean hasNewMessages() throws MessagingException {
		return false;
	}

	public Folder getFolder(final String name) throws MessagingException {
		if (!name.equalsIgnoreCase("INBOX"))
			throw new MessagingException("only INBOX supported");
		return getInbox();
	}

	protected Folder getInbox() throws MessagingException {
		return getStore().getFolder("INBOX");
	}
    

	public boolean delete(final boolean recurse) throws MessagingException {
		throw new MethodNotSupportedException("delete");
	}

	public boolean renameTo(final Folder f) throws MessagingException {
		throw new MethodNotSupportedException("renameTo");
	}

	public void open(final int mode) throws MessagingException {
		throw new MethodNotSupportedException("open");
	}

	public void close(final boolean expunge) throws MessagingException {
		throw new MethodNotSupportedException("close");
	}

	public boolean isOpen() {
		return false;
	}

	public Flags getPermanentFlags() {
		return new Flags(); //  flags IuWFNg
	}

	public int getMessageCount() throws MessagingException {
		return 0;
	}

	public Message getMessage(final int msgno) throws MessagingException {
		throw new MethodNotSupportedException("getMessage");
	}

	public void appendMessages(final Message[] msgs) throws MessagingException {
		throw new MethodNotSupportedException("Append not supported");	
	}

	public Message[] expunge() throws MessagingException {
		throw new MethodNotSupportedException("expunge");	
	}

}
