/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.pop3;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.UIDFolder;
import javax.mail.event.ConnectionEvent;

import com.sun.mail.util.LineInputStream;

/**
 * POP3 ̃tH_ł("INBOX" tH_ł)B
 * 
 * POP3 vgRvoC_̏ڍׂɊւẮA
 * <a href="package-summary.html">jp.sourceforge.livez.mail.pop3</a> pbP[W̃hLgQƂĉB
 */
public final class POP3Folder extends Folder {

	private String name;
	private Protocol port;
	private int total;
	private int size;
	private boolean exists = false;
	private boolean opened = false;
	private Vector message_cache;
	private boolean doneUidl = false;

	/**
	 * RXgN^łB
	 */
	POP3Folder(final POP3Store store, final String name) {
		super(store);
		this.name = name;
		if (name.equalsIgnoreCase("INBOX"))
			exists = true;
	}

	public String getName() {
		return name;
	}

	public String getFullName() {
		return name;
	}

	public Folder getParent() {
		return new DefaultFolder((POP3Store)store);
	}

	/**
	 * "INBOX" tH_ł͏ true łBȊȌꍇ͏ false łB
	 * 
	 * @return	INBOX  trueAȊȌꍇ false
	 */
	public boolean exists() {
		return exists;
	}

	/**
	 * POP3 tH_̓TutH_܂ގłȂ̂ŁA
	 *  <code>MessagingException</code> 𓊂܂B
	 *
	 * @throws MessagingException 
	 */
	public Folder[] list(final String pattern) throws MessagingException {
		throw new MessagingException("not a directory");
	}

	/**
	 * POP3 ł͊Kw\T|[gȂ̂ŏ NUL Ԃ܂B
	 *
	 * @return NUL
	 */
	public char getSeparator() {
		return '\0';
	}

	/**
	 *  Folder.HOLDS_MESSAGES Ԃ܂B
	 * 
	 * @return Folder.HOLDS_MESSAGES
	 */
	public int getType() {
		return HOLDS_MESSAGES;
	}

	/**
	 *  false Ԃ܂B
	 * POP3 vgŔAtH_̍쐬T|[g܂B
	 * 
	 * @return false
	 */
	public boolean create(final int type) throws MessagingException {
		return false;
	}

	/**
	 *  false Ԃ܂B
	 * POP3 vgR͐VbZ[W邩肷@S񋟂܂B
	 * 
	 * @return false
	 */
	public boolean hasNewMessages() throws MessagingException {
		return false;    // m@܂
	}

	/**
	 * POP3 tH_̓TutH_܂ގłȂ̂ŏ <code>MessagingException</code> X[܂B
	 * 
	 * @throws MessagingException 
	 */
	public Folder getFolder(final String name) throws MessagingException {
		throw new MessagingException("not a directory");
	}

	/**
	 * POP3 vgŔAINBOX 폜̂Ȃ̂ŁA
	 *  <code>MethodNotSupportedException</code> X[܂B
	 *
	 * @throws MethodNotSupportedException	
	 */
	public boolean delete(final boolean recurse) throws MessagingException {
		throw new MethodNotSupportedException("delete");
	}

	/**
	 * POP3 vgŔAtH_T|[gȂ̂ŁA
	 *  <code>MethodNotSupportedException</code> X[܂B
	 * 
	 * @throws MethodNotSupportedException	
	 */
	public boolean renameTo(final Folder f) throws MessagingException {
		throw new MethodNotSupportedException("renameTo");
	}

	/**
	 * ̃tH_ "INBOX" ƖȂꍇA
	 * <code>FolderNotFoundException</code> X[܂B
	 * 
	 * @throws FolderNotFoundException	INBOX Ȃꍇ
	 * @throws AuthenticationException	F؂Ɏsꍇ
	 * @throws MessagingException ̑̏ꍇ
	 */
	public synchronized void open(final int mode) throws MessagingException {
		checkClosed();
		if (!exists)
			throw new FolderNotFoundException(this, "folder is not INBOX");

		try {
			port = ((POP3Store)store).getPort(this);
			Status s = port.stat();
			total = s.total;
			size = s.size;
			this.mode = mode;
			opened = true;
		} catch (IOException ioex) {
			try {
				if (port != null)
					port.quit();
			} catch (IOException ioex2) {
				// ignore
			} finally {
				port = null;
				((POP3Store)store).closePort(this);
			}
			throw new MessagingException("Open failed", ioex);
		}

		// K؂ȃTCỸbZ[WLbVxN^쐬܂B
		message_cache = new Vector(total);
		message_cache.setSize(total);
		doneUidl = false;

		notifyConnectionListeners(ConnectionEvent.OPENED);
    }

	public synchronized void close(final boolean expunge) throws MessagingException {
		checkOpen();

		try {
			/*
			 * Some POP3 servers will mark messages for deletion when
			 * they're read.  To prevent such messages from being
			 * deleted before the client deletes them, you can set
			 * the mail.pop3.rsetbeforequit property to true.  This
			 * causes us to issue a POP3 RSET command to clear all
			 * the "marked for deletion" flags.  We can then explicitly
			 * delete messages as desired.
			 */
			if (((POP3Store)store).rsetBeforeQuit)
				port.rset();
			if (expunge && mode == READ_WRITE) {
				// find all messages marked deleted and issue DELE commands
				for (int i = 0; i < message_cache.size(); i++) {
					POP3Message m;
					if ((m = (POP3Message)message_cache.elementAt(i)) != null && m.isSet(Flags.Flag.DELETED))
						try {
							port.dele(i + 1);
						} catch (IOException ioex) {
							throw new MessagingException("Exception deleting messages during close", ioex);
						}
				}
			}

			port.quit();
		} catch (IOException ex) {
			// ܂
		} finally {
			port = null;
			((POP3Store)store).closePort(this);
			message_cache = null;
			opened = false;
			notifyConnectionListeners(ConnectionEvent.CLOSED);
		}
	}

	public boolean isOpen() {
		if (!opened)
			return false;
		if (store.isConnected())
			return true;
		try {
			close(false);
		} catch (MessagingException ex) {}
		return false;
	}

	/**
	 * POP3 vgR͂ǂ̗lȉivtOT|[gȂ̂ŁA
	 * ɋ <code>Flags</code> IuWFNgԂ܂B
	 *
	 * @return  Flags IuWFNg
	 */
	public Flags getPermanentFlags() {
		return new Flags(); //  flags IuWFNg
	}

	/**
	 * Will not change while the folder is open because the POP3
	 * protocol doesn't support notification of new messages
	 * arriving in open folders.
	 */
	public int getMessageCount() throws MessagingException {
		if (!opened)
			return -1;
		checkReadable();
		return total;
	}

	public synchronized Message getMessage(final int msgno) throws MessagingException {
		checkOpen();

		POP3Message m;

		// Assuming that msgno is <= total 
		if ((m = (POP3Message)message_cache.elementAt(msgno-1)) == null) {
			m = createMessage(this, msgno);
			message_cache.setElementAt(m, msgno - 1);
		}
		return m;
	}

	protected POP3Message createMessage(final Folder f, final int msgno) /* throws MessagingException */ {
		POP3Message m = null;
		Constructor cons = ((POP3Store)store).messageConstructor;
		if (cons != null) {
			try {
				Object[] o = { this, new Integer(msgno) };
				m = (POP3Message) cons.newInstance(o);
			} catch (Exception ex) {}	// 
		}
		if (m == null)
			m = new POP3Message(this, msgno);
		return m;
	}

	/**
	 * Always throws <code>MethodNotSupportedException</code>
	 * because the POP3 protocol doesn't support appending messages.
	 * 
	 * @throws MethodNotSupportedException 
	 */
	public void appendMessages(final Message[] msgs) throws MessagingException {
		throw new MethodNotSupportedException("Append not supported");
	}

	/**
	 * Always throws <code>MethodNotSupportedException</code>
	 * because the POP3 protocol doesn't support expunging messages
	 * without closing the folder; call the {@link #close close} method
	 * with the <code>expunge</code> argument set to <code>true</code>
	 * instead.
	 * 
	 * @throws MethodNotSupportedException 
	 */
	public Message[] expunge() throws MessagingException {
		throw new MethodNotSupportedException("Expunge not supported");
	}

	/**
	 * Prefetch information about POP3 messages.
	 * If the FetchProfile contains <code>UIDFolder.FetchProfileItem.UID</code>,
	 * POP3 UIDs for all messages in the folder are fetched using the POP3
	 * UIDL command.
	 * If the FetchProfile contains <code>FetchProfile.Item.ENVELOPE</code>,
	 * the headers and size of all messages are fetched using the POP3 TOP
	 * and LIST commands.
	 */
	public synchronized void fetch(final Message[] msgs, final FetchProfile fp) throws MessagingException {
		checkReadable();
		if (!doneUidl && fp.contains(UIDFolder.FetchProfileItem.UID)) {
			/*
			 * Since the POP3 protocol only lets us fetch the UID
			 * for a single message or for all messages, we go ahead
			 * and fetch UIDs for all messages here, ignoring the msgs
			 * parameter.  We could be more intelligent and base this
			 * decision on the number of messages fetched, or the
			 * percentage of the total number of messages fetched.
			 */
			String[] uids = new String[message_cache.size()];
			try {
				if (!port.uidl(uids))
					return;
			} catch (EOFException eex) {
				close(false);
				throw new FolderClosedException(this, eex.toString());
			} catch (IOException ex) {
				throw new MessagingException("error getting UIDL", ex);
			}
			for (int i = 0; i < uids.length; i++)
				if (uids[i] != null) {
					POP3Message m = (POP3Message) getMessage(i + 1);
					m.uid = uids[i];
				}
			doneUidl = true;	// only do this once
		}
		if (fp.contains(FetchProfile.Item.ENVELOPE)) {
			for (int i = 0; i < msgs.length; i++)
				try {
					POP3Message msg = (POP3Message) msgs[i];
					// fetch headers
					msg.getHeader("");
					// fetch message size
					msg.getSize();
				} catch (MessageRemovedException mex) {
					// should never happen, but ignore it if it does
				}
		}
	}

	/**
	 * Return the unique ID string for this message, or null if
	 * not available.  Uses the POP3 UIDL command.
	 * 
	 * @return j[N ID 
	 * @throws MessagingException
	 */
	public synchronized String getUID(final Message msg) throws MessagingException {
		checkOpen();
		POP3Message m = (POP3Message) msg;
		try {
			if (m.uid == POP3Message.UNKNOWN)
				m.uid = port.uidl(m.getMessageNumber());
			return m.uid;
		} catch (EOFException eex) {
			close(false);
			throw new FolderClosedException(this, eex.toString());
		} catch (IOException ex) {
			throw new MessagingException("error getting UIDL", ex);
		}
	}

	/**
	 * Return the size of this folder, as was returned by the POP3 STAT
	 * command when this folder was opened.
	 * 
	 * @return tH_TCY
	 * @throws IllegalStateException tH_JĂȂꍇ
	 */
	public int getSize() /* throws MessagingException */ {
		checkOpen();
		return size;
	}

	/**
	 * POP3 LIST R}hɂĕԂÃtH_̑SẴbZ[W̃TCYԂ܂B
	 * z̊eGg[̓bZ[WɑΉĂ܂; Gg[́AbZ[Wԍ <i>i+1</i> ɑΉ܂B<p>
	 * 
	 * @return bZ[WTCY̔z
	 * @throws IllegalStateException if the folder isn't open
	 * @since JavaMail 1.3.3
	 */
	public synchronized int[] getSizes() throws MessagingException {
		checkOpen();
		int ai[] = new int[total];
		InputStream inputstream = null;
		LineInputStream lineinputstream = null;

		try {
			inputstream = port.list();
			lineinputstream = new LineInputStream(inputstream);
			String s;
			while ((s = lineinputstream.readLine()) != null) 
				try {
					StringTokenizer stringtokenizer = new StringTokenizer(s);
					int i = Integer.parseInt(stringtokenizer.nextToken());
					int j = Integer.parseInt(stringtokenizer.nextToken());
					if (i > 0 && i <= total)
						ai[i - 1] = j;
				} catch (Exception _ex) {}
		} catch(IOException _ex) {
		} finally {
			try {
				if (lineinputstream != null)
					lineinputstream.close();
			} catch (IOException _ex) {}
			try {
				if (inputstream != null)
					inputstream.close();
			} catch(IOException _ex) {}
		}
		return ai;
	}

	/**
	 * Return the raw results of the POP3 LIST command with no arguments.<p>
	 * 
	 * @return InputStream containing results
	 * @throws IllegalStateException if the folder isn't open
	 * @since JavaMail 1.3.3
	 */
	public synchronized InputStream listCommand() throws MessagingException, IOException {
		checkOpen();
		return port.list();
	}

	/**
	 * Close the folder when we're finalized.
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		close(false);
	}

	/* Ensure the folder is open */
	void checkOpen() throws IllegalStateException {
		if (!opened)
			throw new IllegalStateException("Folder is not Open");
	}

	/* Ensure the folder is not open */
	void checkClosed() throws IllegalStateException {
		if (opened)
			throw new IllegalStateException("Folder is Open");
	}

	/* Ensure the folder is open & readable */
	void checkReadable() throws IllegalStateException {
		if (!opened || (mode != READ_ONLY && mode != READ_WRITE))
			throw new IllegalStateException("Folder is not Readable");
	}

	/* Ensure the folder is open & writable */
	void checkWritable() throws IllegalStateException {
		if (!opened || mode != READ_WRITE)
			throw new IllegalStateException("Folder is not Writable");
	}

	/**
	 * Centralize access to the Protocol object by POP3Message
	 * objects so that they will fail appropriately when the folder
	 * is closed.
	 */
	Protocol getProtocol() /* throws MessagingException */ {
		checkOpen();
		return port;
	}

	/*
	 * Only here to make accessible to POP3Message.
	 */
	protected void notifyMessageChangedListeners(final int type, final Message m) {
		super.notifyMessageChangedListeners(type, m);
	}

}
