/*
 * Copyright 1996-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.pop3;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.IllegalWriteException;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.event.MessageChangedEvent;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.SharedInputStream;

/**
 * POP3 bZ[WłB
 * MimeMessage ̊̓̕T|[g܂B
 */
public final class POP3Message extends MimeMessage {

	/*
	 * Our locking strategy is to always lock the POP3Folder before the
	 * POP3Message so we have to be careful to drop our lock before calling
	 * back to the folder to close it and notify of connection lost events.
	 */

	// flag to indicate we haven't tried to fetch the UID yet
	static final String UNKNOWN = "UNKNOWN";

	private POP3Folder folder;	// overrides folder in MimeMessage
	private int hdrSize = -1;
	private int msgSize = -1;
	String uid = UNKNOWN;		// tH_bNŃRg[܂

	/**
	 * RXgN^łB
	 */
	public POP3Message(final Folder folder, final int msgno) /* throws MessagingException */ {
		super(folder, msgno);
		this.folder = (POP3Folder) folder;
	}

	/**
	 * ̃bZ[WɎw肳ꂽtOw肵lŐݒ肵܂B
	 * 
	 * @param newFlags	ݒ肷tO
	 * @param set ݒ肷l
	 */
	public void setFlags(final Flags newFlags, final boolean set) throws MessagingException {
		Flags oldFlags = (Flags) flags.clone();
		super.setFlags(newFlags, set);
		if (!flags.equals(oldFlags))
			folder.notifyMessageChangedListeners(
					MessageChangedEvent.FLAGS_CHANGED, this);
	}

	/**
	 * ̃bZ[W̓eTCYoCgPʂŕԂ܂B
	 * TCYʂłȂꍇ -1 Ԃ܂B<p>
	 * 
	 * ̐l͓eTCY̐mȑlłȂ\A
	 * e̓]GR[fBOłȂ_ɒӂĉB<p>
	 * 
	 * @return eoCg̃TCY
	 * @throws MessagingException
	 */  
	public int getSize() throws MessagingException {
		// TCYULbVꂽ́A܂B
		if (msgSize >= 0)
			return msgSize;
		try {
			int i;
			synchronized (this) {
				if (msgSize < 0) {
					/*
					 * Use LIST to determine the entire message
					 * size and subtract out the header size
					 * (which may involve loading the headers,
					 * which may load the content as a side effect).
					 * If the content is loaded as a side effect of
					 * loading the headers, get the size directly.
					 */
					if (headers == null)
						loadHeaders();
					if (contentStream != null)
						msgSize = contentStream.available();
					else
						msgSize = folder.getProtocol().list(msgnum) - hdrSize;
				}
				i = msgSize;
				return i;
			}
		} catch (EOFException eex) {
			folder.close(false);
			throw new FolderClosedException(folder, eex.toString());
		} catch (IOException ex) {
			throw new MessagingException("error getting size", ex);
		}
	}

	/**
	 * e̐oCg𐶐܂B
	 * f[^ POP3 RETR R}hgpătFb`܂B
	 * 
	 * @see #contentStream
	 */
	protected InputStream getContentStream() throws MessagingException {
		try {
			synchronized(this) {
				if (contentStream == null) {
					InputStream rawcontent = folder.getProtocol().retr(msgnum, msgSize > 0 ? msgSize + hdrSize : 0);
					if (rawcontent == null) {
						expunged = true;
						throw new MessageRemovedException();    //  XXX - what else?
					}
					if (headers == null || ((POP3Store)folder.getStore()).forgetTopHeaders) {
						headers = new InternetHeaders(rawcontent);
						hdrSize = (int) ((SharedInputStream)rawcontent).getPosition();
					} else {
						/*
						 * Already have the headers, have to skip the headers
						 * in the content array and return the body.
						 *
						 * XXX - It seems that some mail servers return slightly
						 * different headers in the RETR results than were returned
						 * in the TOP results, so we can't depend on remembering
						 * the size of the headers from the TOP command and just
						 * skipping that many bytes.  Instead, we have to process
						 * the content, skipping over the header until we come to
						 * the empty line that separates the header from the body.
						 */
//						int offset = 0;
						int len;	// number of bytes in this line
						do {
							int c1;
							for (len = 0; (c1 = rawcontent.read()) >= 0; len++) {
								if (c1 == '\n')	// end of line
									break;
								if (c1 != '\r')
									continue;
								// got CR, is the next char LF?
								if (rawcontent.available() > 0) {
									rawcontent.mark(1);
									if (rawcontent.read() != '\n')
										rawcontent.reset();
								}
								break;	// in any case, end of line
							}
						} while (rawcontent.available() != 0 && len != 0);
						hdrSize = (int) ((SharedInputStream)rawcontent).getPosition();
					}
					contentStream = ((SharedInputStream)rawcontent).newStream(hdrSize, -1);
					rawcontent = null;	// GC Ȃ
				}
			}
		} catch (EOFException eex) {
			folder.close(false);
			throw new FolderClosedException(folder, eex.toString());
		} catch (IOException ex) {
			throw new MessagingException("error fetching POP3 content", ex);
		}
		return super.getContentStream();
	}

	/**
	 * Invalidate the cache of content for this message object, causing 
	 * it to be fetched again from the server the next time it is needed.
	 * If <code>invalidateHeaders</code> is true, invalidate the headers as well.
	 * 
	 * @param invalidateHeaders invalidate the headers as well?
	 */
	public void invalidate(final boolean invalidateHeaders) {
		content = null;
		contentStream = null;
		msgSize = -1;
		if (invalidateHeaders) {
			headers = null;
			hdrSize = -1;
		}
	}

	/**
	 * Fetch the header of the message and the first <code>n</code> lines
	 * of the raw content of the message.  The headers and data are
	 * available in the returned InputStream.
	 * 
	 * @param n number of lines of content to fetch
	 * @return	InputStream containing the message headers and n content lines
	 */
	public InputStream top(final int n) throws MessagingException {
		try {
			synchronized (this) {
				return folder.getProtocol().top(msgnum, n);
			}
		} catch (EOFException eex) {
			folder.close(false);
			throw new FolderClosedException(folder, eex.toString());
		} catch (IOException ex) {
			throw new MessagingException("error getting size", ex);
		}
	}

	/**
	 *  header_name ̑SẴwb_擾܂B
	 * wb_ US-ASCII ȊO̕܂ޏꍇA
	 * RFC 2047 ɊÂGR[hĂ̂ŁA
	 * fR[hKvƂȂ鎖ɒӂĉB<p>
	 * 
	 * @param name wb_̖O
	 * @return	wb_̔z
	 * @throws MessagingException
	 * @see javax.mail.internet.MimeUtility
	 */
	public String[] getHeader(final String name) throws MessagingException {
		if (headers == null)
			loadHeaders();
		return headers.getHeader(name);
	}

	/**
	 * ̃wb_̑SẴwb_擾A؂蕶ŋ؂ꂽwb_P String ƂĕԂ܂B
	 * delimiter  <code>null</code> ̏ꍇ́Aŏ̃wb_Ԃ܂B
	 * 
	 * @param name ̃wb_̖O
	 * @return ̖OSẴwb_ɑ΂ltB[h
	 * @throws MessagingException
	 */
	public String getHeader(final String name, final String delimiter) throws MessagingException {
		if (headers == null)
			loadHeaders();
		return headers.getHeader(name, delimiter);
	}

	/**
	 *  header_name ̒lݒ肵܂B
	 * POP3 bZ[W͓ǍݐpȂ̂ IllegalWriteException X[܂B
	 * 
	 * @param name wb_̖O
	 * @param value wb_̒l
	 * @throws IllegalWriteException ύXT|[gȂꍇ
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 * @see javax.mail.internet.MimeUtility
	 */
	public void setHeader(final String name, final String value) throws MessagingException {
		// XXX - should check for read-only folder?
		throw new IllegalWriteException("POP3 messages are read-only");
	}

	/**
	 * ̒l header_name ̊lɒǉ܂B
	 * POP3 bZ[W͓ǍݐpȂ̂ IllegalWriteException X[܂B
	 * 
	 * @param name wb_
	 * @param value wb_l
	 * @throws IllegalWriteException ύXT|[gȂꍇ
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 * @see javax.mail.internet.MimeUtility
	 */
	public void addHeader(final String name, final String value) throws MessagingException {
		// XXX - should check for read-only folder?
		throw new IllegalWriteException("POP3 messages are read-only");
	}

	/**
	 * ̖OSẴwb_폜܂B
	 * POP3 bZ[W͓ǍݐpȂ̂ IllegalWriteException X[܂B
	 * 
	 * @throws IllegalWriteException ύXT|[gȂꍇ
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 */
	public void removeHeader(final String name) throws MessagingException {
		// XXX - should check for read-only folder?
		throw new IllegalWriteException("POP3 messages are read-only");
	}

	/**
	 *  Message ̑SẴwb_ Header IuWFNg̗񋓂ƂĕԂ܂B<p>
	 * 
	 * wb_ US-ASCII ȊO̕܂ޏꍇA
	 * RFC 2047 ɂƂÂăGR[hĂ̂ŁA
	 * fR[hKvƂȂ鎖ɒӂĉB<p>
	 * 
	 * @return	wb_IuWFNg̔z
	 * @throws MessagingException
	 * @see javax.mail.internet.MimeUtility
	 */
	public Enumeration getAllHeaders() throws MessagingException {
		if (headers == null)
			loadHeaders();
		return headers.getAllHeaders();	
	}

	/**
	 *  Message vwb_ Header IuWFNg Enumeration ƂĕԂ܂B
	 * 
	 * @throws MessagingException
	 */
	public Enumeration getMatchingHeaders(final String[] names) throws MessagingException {
		if (headers == null)
			loadHeaders();
		return headers.getMatchingHeaders(names);
	}

	/**
	 *  Message vȂwb_ Header IuWFNg Enumeration ƂĕԂ܂B
	 * 
	 * @throws MessagingException
	 */
	public Enumeration getNonMatchingHeaders(final String[] names) throws MessagingException {
		if (headers == null)
			loadHeaders();
		return headers.getNonMatchingHeaders(names);
	}

	/**
	 *  RFC822 wb_sǉ܂B 
	 * POP3 bZ[W͓ǍݐpȂ̂ IllegalWriteException X[܂B
	 * 
	 * @throws IllegalWriteException ύXT|[gȂꍇ
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 */
	public void addHeaderLine(final String line) throws MessagingException {
		// XXX - should check for read-only folder?
		throw new IllegalWriteException("POP3 messages are read-only");
	}

	/**
	 * SẴwb_s String  Enumeration ƂĎ擾܂B
	 * Header s͐ RFC 822 wb_słA"name" y "value" ̗tB[h܂݂܂B
	 * 
	 * @throws MessagingException
	 */
	public Enumeration getAllHeaderLines() throws MessagingException {
		if (headers == null)
			loadHeaders();
		return headers.getAllHeaderLines();
	}

	/**
	 * vwb_s String  Enumeration ƂĎ擾܂B
	 * Header s͐ RFC 822 wb_słA"name" y "value" ̗tB[h܂݂܂B
	 * 
	 * @throws MessagingException
	 */
	public Enumeration getMatchingHeaderLines(final String[] names) throws MessagingException {
		if (headers == null)
			loadHeaders();
		return headers.getMatchingHeaderLines(names);
	}

	/**
	 * vȂwb_s String  Enumeration ƂĎ擾܂B
	 * Header s͐ RFC 822 wb_słA"name" y "value" ̗tB[h܂݂܂B
	 * 
	 * @throws MessagingException
	 */
	public Enumeration getNonMatchingHeaderLines(final String[] names) throws MessagingException {
		if (headers == null)
			loadHeaders();
		return headers.getNonMatchingHeaderLines(names);
	}

	/**
	 * POP3 bZ[W͕ύXł܂B
	 * ̃\bh IllegalWriteException X[܂B
	 * 
	 * @throws IllegalWriteException ύXT|[gȂꍇ
	 */
	public void saveChanges() throws MessagingException {
		// POP3 Messages are read-only
		throw new IllegalWriteException("POP3 messages are read-only");
	}

	/**
	 * Load the headers for this message into the InternetHeaders object.
	 * wb_́APOP3 TOPR}hgpĎ擾܂B
	 */
	private void loadHeaders() throws MessagingException {
		try {
			synchronized (this) {
				if (headers != null)    // check again under lock
					return;
				InputStream hdrs = null;
				if (((POP3Store)folder.getStore()).disableTop || (hdrs = folder.getProtocol().top(msgnum, 0)) == null) {
					// possibly because the TOP command isn't supported,
					// load headers as a side effect of loading the entire
					// content.
					InputStream cs = getContentStream();
					cs.close();
				} else {
					hdrSize = hdrs.available();
					headers = new InternetHeaders(hdrs);
				}
			}
		} catch (EOFException eex) {
			folder.close(false);
			throw new FolderClosedException(folder, eex.toString());
		} catch (IOException ex) {
			throw new MessagingException("error loading POP3 headers", ex);
		}
	}

}
