/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.pop3;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;

import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

/**
 * POP3 Message Store łB
 *  "INBOX" tH_܂ł܂B
 * 
 * POP3 vgRvoC_̏ڍׂɂẮA
 * <a href="package-summary.html">jp.sourceforge.livez.mail.pop3</a>
 * pbP[WhLe[VQƂĉB<p>
 */
public class POP3Store extends Store {

	private String name = "pop3";			// vgR
	private int defaultPort = 110;			// ftHg POP3 |[g
	private boolean isSSL = false;		// SSL gp邩ǂ

	private Protocol port = null;			//  POP3 |[g
	private POP3Folder portOwner = null;	// |[gLĂtH_
	private String host = null;			// zXg
	private int portNum = -1;
	private String user = null;
	private String passwd = null;
	boolean rsetBeforeQuit = false;
	boolean disableTop = false;
	boolean forgetTopHeaders = false;
	Constructor messageConstructor = null;

	/**
	 * RXgN^łB
	 */
	public POP3Store(final Session session, final URLName url) {
		this(session, url, "pop3", 110, false);
	}

	/**
	 * RXgN^łB
	 */
	public POP3Store(final Session session, final URLName url, String name, int port, boolean isSSL) {
		super(session, url);
		if (url != null)
			name = url.getProtocol();

		this.name = name;
		this.defaultPort = port;
		this.isSSL = isSSL;

		String s = session.getProperty("mail." + name + ".rsetbeforequit");
		if (s != null && s.equalsIgnoreCase("true"))
			rsetBeforeQuit = true;

		s = session.getProperty("mail." + s + ".disabletop");
		if (s != null && s.equalsIgnoreCase("true"))
			disableTop = true;
		s = session.getProperty("mail." + s + ".forgettopheaders");
		if (s != null && s.equalsIgnoreCase("true"))
			forgetTopHeaders = true;

		s = session.getProperty("mail." + name + ".message.class");
		if (s != null) {
			if (session.getDebug())
				session.getDebugOut().println("DEBUG: POP3 message class: " + s);
			try {
				ClassLoader cl = this.getClass().getClassLoader();

				// ɃNX[h܂
				Class messageClass = null;
				try {
					// ŏ "AvP[V" NX[_܂B
					// ́A Thread.currentThread().getContextClassLoader()
					// ƒuȂ΂Ȃ܂B
					messageClass = cl.loadClass(s);
				} catch (ClassNotFoundException ex1) {
					// ꂪȂꍇA "VXe" NX[_܂B
					// (JDK 1.1 NX[_eNX[_ɈϔCȂȂ̂ŁA痼ƂKvł)
					messageClass = Class.forName(s);
				}

				Class[] c = { javax.mail.Folder.class, int.class };
				messageConstructor = messageClass.getConstructor(c);
			} catch (Exception ex) {
				if (session.getDebug())
					session.getDebugOut().println("DEBUG: failed to load POP3 message class: " + ex);
			}
		}
	}

	protected synchronized boolean protocolConnect(
		final String host,
		int portNum,
		final String user,
		final String passwd)
		throws MessagingException {

		// zXgApX[hA[U null łȂ`FbN܂
		if (host == null || passwd == null || user == null)
			return false;

		// if port is not specified, set it to value of mail.pop3.port
		// property if it exists, otherwise default to 110
		if (portNum == -1) {
			String portstring = session.getProperty("mail." + name + ".port");
			if (portstring != null)
				portNum = Integer.parseInt(portstring);
		}

		if (portNum == -1)
			portNum = defaultPort;

		this.host = host;
		this.portNum = portNum;
		this.user = user;
		this.passwd = passwd;
		try {
			port = getPort(null);
		} catch (EOFException eex) { 
			throw new AuthenticationFailedException(eex.getMessage());
		} catch (IOException ioex) { 
			throw new MessagingException("Connect failed", ioex);
		}

		return true;
	}

	/**
	 * Check whether this store is connected. Override superclass
	 * method, to actually ping our server connection. <p>
	 */
	/*
	 * Note that we maintain somewhat of an illusion of being connected
	 * even if we're not really connected.  This is because a Folder
	 * can use the connection and close it when it's done.  If we then
	 * ask whether the Store's connected we want the answer to be true,
	 * as long as we can reconnect at that point.  This means that we
	 * need to be able to reconnect the Store on demand.
	 */
	public synchronized boolean isConnected() {
		if (!super.isConnected())
			// if we haven't been connected at all, don't bother with the NOOP.
			return false;

		synchronized (this) {
			try {
				if (port == null)
					port = getPort(null);
				else
					port.noop();
				return true;
		    } catch (IOException ioex) {
				// no longer connected, close it down
				try {
					super.close();		// notifies listeners
				} catch (MessagingException mex) {}	// 
			}
			return false;
		}
	}

	synchronized Protocol getPort(final POP3Folder owner) throws IOException {
		// if we already have a port, remember who's using it
		if (port != null && portOwner == null) {
			portOwner = owner;
			return port;
		}

		// need a new port, create it and try to login
		Protocol p = new Protocol(host, portNum, session.getDebug(),
			session.getDebugOut(), session.getProperties(), "mail." + name, isSSL);

		String msg = null;
		if ((msg = p.login(user, passwd)) != null) {
			try {
				p.quit();
			} catch (IOException ioex) {
			} finally {
				throw new EOFException(msg);
			}
		}

		if (port == null && owner != null) {
			port = p;
			portOwner = owner;
		}

		if (portOwner == null)
			portOwner = owner;
		return p;
	}

	synchronized void closePort(final POP3Folder owner) {
		if (portOwner == owner) {
			port = null;
			portOwner = null;
		}
	}

	public synchronized void close() throws MessagingException {
		try {
			if (port != null)
				port.quit();
		} catch (IOException ioex) {
		} finally {
			port = null;

			// to set the state and send the closed connection event
			super.close();
		}
	}

	public Folder getDefaultFolder() throws MessagingException {
		checkConnected();
		return new DefaultFolder(this);
	}

	/**
	 * "INBOX" ƂÔ݃T|[g܂B
	 */
	public Folder getFolder(final String name) throws MessagingException {
		checkConnected();
		return new POP3Folder(this, name);
	}

	public Folder getFolder(final URLName url) throws MessagingException {
		checkConnected();
		return new POP3Folder(this, url.getFile());
	}

	protected void finalize() throws Throwable {
		super.finalize();

		if (port != null)	// don't force a connection attempt
		    close();
	}

	private void checkConnected() throws MessagingException {
		if (!super.isConnected())
		    throw new MessagingException("Not connected");
	}

}
