/*
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.pop3;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.mail.util.SharedByteArrayInputStream;

import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;

final class Response {

	boolean ok = false;		// true if "+OK"
	String data = null;			// rest of line after "+OK" or "-ERR"
	InputStream bytes = null;	// all the bytes from a multi-line response

}

/**
 * ̃NX́APOP3 ڑOƂāAPOP3 vgRv܂B
 * 
 * APOP support courtesy of "chamness".
 */
final class Protocol {

	private Socket socket;							// POP3 \Pbg
	private DataInputStream input;					// ̓obt@
	private PrintWriter output;					// o̓obt@
	private static final int POP3_PORT = 110;	// W POP3 |[g
	private static final String CRLF = "\r\n";
	private boolean debug = false;
	private PrintStream out;
	private String apopChallenge = null;

	/**
	 * POP3 T[oւ̐ڑJ܂B
	 */
	Protocol(
		final String host,
		int port,
		final boolean debug,
		final PrintStream out,
		final Properties props,
		final String prefix,
		boolean isSSL)
		throws IOException {

		this.debug = debug;
		this.out = out;
		Response r;
		String apop = props.getProperty(prefix + ".apop.enable");
		boolean enableAPOP = apop != null && apop.equalsIgnoreCase("true");
		try {
			if (port == -1)
				port = POP3_PORT;
			if (debug)
				out.println("DEBUG POP3: connecting to host \"" + host + "\", port " + port + ", isSSL " + isSSL);

			socket = SocketFetcher.getSocket(host, port, props, prefix, isSSL);

			input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
			output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "iso-8859-1")));
					// should be US-ASCII, but not all JDK's support

			r = simpleCommand(null);
		} catch (IOException ioe) {
			try {
				socket.close();
			} catch (Exception e) {}
			throw ioe;
		}

		if (!r.ok) {
			try {
				socket.close();
			} catch (Exception e) {}
			throw new IOException("Connect failed");
		}
		if (enableAPOP) {
			int challStart = r.data.indexOf('<');			// `WJn
			int challEnd = r.data.indexOf('>', challStart);	// `WI
			if (challStart != -1 && challEnd != -1)
				apopChallenge = r.data.substring(challStart, challEnd + 1);
			if (debug)
				out.println("DEBUG POP3: APOP challenge: " + apopChallenge);
		}
	}

	protected void finalize() throws Throwable {
		super.finalize();
		if (socket != null) // OAEĝYĂ邩H
			quit();
	}

	/**
	 * USER  PASS R}hgpāAT[oɃOC܂B
	 */
	synchronized String login(final String user, final String password) throws IOException {
		Response r;
		String dpw = null;
		if (apopChallenge != null)
			dpw = getDigest(password);
		if (apopChallenge != null && dpw != null) {
			r = simpleCommand("APOP " + user + ' ' + dpw);
		} else {
			r = simpleCommand("USER " + user);
			if (!r.ok)
				return r.data != null ? r.data : "USER command failed";
			r = simpleCommand("PASS " + password);
		}
		if (!r.ok)
			return r.data != null ? r.data : "login failed";
		return null;
	}

	/**
	 * APOP bZ[W _CWFXg擾܂B
	 * From RFC 1939:
	 * 
	 * The 'digest' parameter is calculated by applying the MD5
	 * algorithm [RFC1321] to a string consisting of the timestamp
	 * (including angle-brackets) followed by a shared secret.
	 * The 'digest' parameter itself is a 16-octet value which is
	 * sent in hexadecimal format, using lower-case ASCII characters.
	 * 
	 * @param password APOP pX[h
	 * @return The APOP digest or an empty string if an error occurs.
	 */
	private String getDigest(final String password) {
		String key = apopChallenge + password;
		byte[] digest;
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			digest = md.digest(key.getBytes("iso-8859-1"));	// XXX
		} catch (NoSuchAlgorithmException nsae) {
			return null;
		} catch (UnsupportedEncodingException uee) {
			return null;
		}
		return toHex(digest);
	}

	private static final char[] digits = {
		'0', '1', '2', '3', '4', '5', '6', '7',
		'8', '9', 'a', 'b', 'c', 'd', 'e', 'f'
	};

	/**
	 * oCgzoCg\A16i֕ϊ܂B
	 */
	private static String toHex(final byte[] bytes) {
		char[] result = new char[bytes.length * 2];

		for (int index = 0, i = 0; index < bytes.length; index++) {
			int temp = bytes[index] & 0xFF;
			result[i++] = digits[temp >> 4];
			result[i++] = digits[temp & 0xF];
		}

		return new String(result);
	}

	/**
	 * QUIT R}h𑗐MāAڑN[Y܂B
	 * expunge ꍇ true łB
	 */
	synchronized boolean quit() throws IOException {
		boolean ok = false;
		try {
			Response r = simpleCommand("QUIT");
			ok = r.ok;
		} finally {
			try {
				socket.close();
			} finally {
				socket = null;
				input = null;
				output = null;
			}
		}
		return ok;
	}

	/**
	 * STAT R}hgpāAbZ[W̑ƃ[{bNXTCYԂ܂B
	 */
	synchronized Status stat() throws IOException {
		Response r = simpleCommand("STAT");
		Status s = new Status();
		if (r.ok && r.data != null) {
			try {
				StringTokenizer st = new StringTokenizer(r.data);
				s.total = Integer.parseInt(st.nextToken());
				s.size = Integer.parseInt(st.nextToken());
			} catch (Exception e) {}
		}
		return s;
	}

	/**
	 * LIST R}hgpăbZ[W̃TCYԂ܂B
	 */
	synchronized int list(final int msg) throws IOException {
		Response r = simpleCommand("LIST " + msg);
		int size = -1;
		if (r.ok && r.data != null) {
			try {
				StringTokenizer st = new StringTokenizer(r.data);
				st.nextToken();    // bZ[WԍXLbv
				size = Integer.parseInt(st.nextToken());
			} catch (Exception e) {}
		}
		return size;
	}

	synchronized InputStream list() throws IOException {
		Response r = multilineCommand("LIST", 128);
		return r.bytes;
	}

	/**
	 * w肳ꂽbZ[WM܂B
	 * Given an estimate of the message's size we can be more efficient,
	 * preallocating the array and returning a SharedInputStream to allow
	 * us to share the array.
	 */
	synchronized InputStream retr(final int msg, final int size) throws IOException {
		Response r = multilineCommand("RETR " + msg, size);
		return r.bytes;
	}

	/**
	 * bZ[Wwb_ƃbZ[W̐擪 n s܂łԂ܂B
	 */
	synchronized InputStream top(final int msg, final int n) throws IOException {
		Response r = multilineCommand("TOP " + msg + ' ' + n, 0);
		return r.bytes;
	}

	/**
	 * w肳ꂽbZ[W(iv)폜܂B
	 */
	synchronized boolean dele(final int msg) throws IOException {
		Response r = simpleCommand("DELE " + msg);
		return r.ok;
	}

	/**
	 * bZ[W UIDL Ԃ܂B
	 */
	synchronized String uidl(final int msg) throws IOException {
		Response r = simpleCommand("UIDL " + msg);
		if (!r.ok)
			return null;
		int i = r.data.indexOf(' ');
		if (i > 0)
			return r.data.substring(i + 1);
		return null;
	}

	/**
	 * SẴbZ[W UIDL Ԃ܂B
	 * The UID for msg #N is returned in uids[N-1].
	 */
	synchronized boolean uidl(final String[] uids) throws IOException {
		Response r = multilineCommand("UIDL", 15 * uids.length);
		if (!r.ok)
			return false;
		LineInputStream lis = new LineInputStream(r.bytes);
		for (String line = null; (line = lis.readLine()) != null;) {
			int i = line.indexOf(' ');
			if (i >= 1 || i < line.length()) {
				int n = Integer.parseInt(line.substring(0, i));
				if (n > 0 && n <= uids.length)
					uids[n - 1] = line.substring(i + 1);
			}
		}
		return true;
	}

	/**
	 * NOOP s܂B
	 */
	synchronized boolean noop() throws IOException {
		Response r = simpleCommand("NOOP");
		return r.ok;
	}

	/**
	 * RSET s܂B
	 */
	synchronized boolean rset() throws IOException {
		Response r = simpleCommand("RSET");
		return r.ok;
	}

	/**
	 * ȒP POP3 R}h𔭍sAX|XԂ܂B
	 */
	private Response simpleCommand(String cmd) throws IOException {
		if (socket == null)
			throw new IOException("Folder is closed");	// XXX
		if (cmd != null) {
			if (debug)
				out.println("C: " + cmd);
			cmd += CRLF;
			output.print(cmd);	// 1ŏo͂܂
			output.flush();
		}
		String line = input.readLine();	// XXX - readLine ͔񐄏
		if (line == null) {
			if (debug)
				out.println("S: EOF");
			throw new EOFException("EOF on socket");
		}
		if (debug)
			out.println("S: " + line);
		Response r = new Response();
		if (line.startsWith("+OK"))
			r.ok = true;
		else if (line.startsWith("-ERR"))
			r.ok = false;
		else
			throw new IOException("Unexpected response: " + line);
		int i;
		if ((i = line.indexOf(' ')) >= 0)
			r.data = line.substring(i + 1);
		return r;
	}

	/**
	 * }`CX|Xz肵 POP3 R}h𔭍s܂B
	 * <code>size</code> ̓X|XTCY̌ςłB
	 */
	private Response multilineCommand(final String cmd, final int size) throws IOException {
		Response r = simpleCommand(cmd);
		if (!r.ok)
			return (r);

		SharedByteArrayOutputStream buf = new SharedByteArrayOutputStream(size);
		int b, lastb = '\n';
		while ((b = input.read()) >= 0) {
			if (lastb == '\n' && b == '.') {
				if (debug)
					out.write(b);
				b = input.read();
				if (b == '\r') {
					if (debug)
						out.write(b);
					// X|XI܂B܂ALF ܂B
					b = input.read();
					if (debug)
						out.write(b);
					break;
				}
			}
			buf.write(b);
			if (debug)
				out.write(b);
			lastb = b;
		}
		if (b < 0)
			throw new EOFException("EOF on socket");
		r.bytes = buf.toStream();
		return r;
	}

}

/**
 * A ByteArrayOutputStream that allows us to share the byte array rather than copy it.
 * Eventually could replace this with something that doesn't require a single contiguous byte array.
 */
final class SharedByteArrayOutputStream extends ByteArrayOutputStream {

	/**
	 * RXgN^łB
	 */
	public SharedByteArrayOutputStream(final int size) {
		super(size);
	}

	public InputStream toStream() {
		return new SharedByteArrayInputStream(buf, 0, count);
	}

}
