/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.smtp;

import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;

/**
 * ̗O̓bZ[W𑗐MłȂꍇɃX[܂B<p>
 * O̓bZ[W𑗐MłȂAhX܂݂܂B
 * This will usually appear in a chained list of exceptions, one per address, attached to a top level SendFailedException that aggregates all the addresses.
 * 
 * @since JavaMail 1.3.2
 */
public final class SMTPAddressFailedException extends SendFailedException {

	private static final long serialVersionUID = 804831199768630097L;

	/**
	 * sAhXێ܂B
	 */
	protected InternetAddress addr;

	/**
	 * sR}hێ܂B
	 */
	protected String cmd;

	/**
	 * s SMTP ^[R[hێ܂B
	 */
	protected int rc;

	/**
	 * w肳ꂽAhXA^[R[hAyуG[XgO SMTPAddressFailedException \z܂B
	 * 
	 * @param addr sAhX
	 * @param cmd SMTP T[o ɑꂽR}h
	 * @param rc s SMTP ^[R[h
	 * @param err SMTP T[õG[XgO
	 */
    public SMTPAddressFailedException(final InternetAddress addr, final String cmd, final int rc, final String err) {
		super(err);
		this.addr = addr;
		this.cmd = cmd;
		this.rc = rc;
	}

    /**
     * sAhXԂ܂B
     */
	public InternetAddress getAddress() {
		return addr;
	}

	/**
	 * sR}hԂ܂B
	 */
	public String getCommand() {
		return cmd;
	}

	/**
	 * s̗R SMTP T[õ^[R[hԂ܂B
	 * ^[R[hɂĂ <a href="http://www.ietf.org/rfc/rfc821.txt">RFC 821</a> QƂĉB
	 */
	public int getReturnCode() {
		return rc;
	}

}
