/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.smtp;

import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

/**
 * ̗ÓA<code>mail.smtp.reportsuccess</code> vpeB true ̏ꍇɁA
 * SendFailedException Ń`F[܂B
 * ̓bZ[WMꂽAhX܂B
 * R}h SMTP RCPT R}hɂȂ܂BāA^[R[h͂̃R}h̃^[R[hɂȂ܂B
 * 
 * @since JavaMail 1.3.2
 */
public final class SMTPAddressSucceededException extends MessagingException {

	private static final long serialVersionUID = -1168335848623096749L;

	/**
	 * AhXێ܂B
	 */
	protected InternetAddress addr;

	/**
	 * R}hێ܂B
	 */
	protected String cmd;

	/**
	 *  SMTP ^[R[hێ܂B
	 */
	protected int rc;

	/**
	 * w肳ꂽAhXA^[R[hAyуG[XgO SMTPAddressFailedException \z܂B
	 * 
	 * @param addr AhX
	 * @param cmd SMTP T[oɑMꂽR}h
	 * @param rc  SMTP ^[R[h
	 * @param err SMTP T[õG[XgO
	 */
	public SMTPAddressSucceededException(final InternetAddress addr, final String cmd, final int rc, final String err) {
		super(err);
		this.addr = addr;
		this.cmd = cmd;
		this.rc = rc;
	}

	/**
	 * AhXԂ܂B
	 */
	public InternetAddress getAddress() {
		return addr;
	}

	/**
	 * R}hԂ܂B
	 */
	public String getCommand() {
		return cmd;
	}

	/**
	 * ̗R SMTP T[õ^[R[hԂ܂B
	 * ^[R[hɂĂ <a href="http://www.ietf.org/rfc/rfc821.txt">RFC 821</a> QƂĉB
	 */
	public int getReturnCode() {
		return rc;
	}

}
