/*
 * Copyright 2000-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.smtp;

import java.io.InputStream;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

/**
 * ̃NX͗lX SMTP IvVw肳 MimeMessage NXƁA
 * ̃bZ[W SMTP ɑM鎞Ɏgpp[^łB
 * P MimeMessage ̑ɂ̃NXgp܂B
 * āÃNX̃\bhgp SMTP IvVݒ肵܂B<p>
 * 
 * SMTP vgRvoC_̏ڍׂɊւẮA
 * <a href="package-summary.html">jp.sourceforge.livez.mail.smtp</a>
 * pbP[W̃hLe[VQƂĉB
 * 
 * @see	javax.mail.internet.MimeMessage
 */
public final class SMTPMessage extends MimeMessage {

	/**
	 * zM󋵂ʒmȂ\܂B
	 */
	public static final int NOTIFY_NEVER = -1;

	/**
	 * zMʒm܂B
	 */
	public static final int NOTIFY_SUCCESS = 1;

	/**
	 * zMsʒm܂B
	 */
	public static final int NOTIFY_FAILURE = 2;

	/**
	 * zMxʒm܂B
	 */
	public static final int NOTIFY_DELAY = 4;

	/**
	 * zM󋵒ʒmƋɊSȃbZ[WԂ\܂B
	 */
	public static final int RETURN_FULL = 1;

	/**
	 * zM󋵒ʒmƋɃbZ[Wwb_Ԃ\܂B
	 */
	public static final int RETURN_HDRS = 2;

	private static final String[] returnOptionString = { null, "FULL", "HDRS" };

	private String envelopeFrom; // the string to use in the MAIL FROM: command
	private int notifyOptions = 0;
	private int returnOption = 0;
	private boolean sendPartial = false;
	private boolean allow8bitMIME = false;
	private String submitter = null;	// RFC 2554 AUTH=submitter
	private String extension = null;	// extensions to use with MAIL command

	/**
	 * ftHgRXgN^łB
	 * ̃bZ[WIuWFNg쐬܂B
	 * <code>headers</code> tB[h͋ InternetHeaders IuWFNgɐݒ肳܂B
	 * <code>flags</code> tB[h͋ Flags IuWFNgɐݒ肳܂B
	 * <code>modified</code> tO true ɐݒ肳܂B
	 */
	public SMTPMessage(final Session session) {
		super(session);
	}

	/**
	 * w肳ꂽ MIME InputStream ̃f[^ǂݎA\͂邱ƂŁASMTPMessage \z܂B
	 * InputStream ̓bZ[Wf[^̍ŌɈʒut܂B
	 * ̓Xg[̍\͂́ÃRXgN^̂̓ōs鎖ɒӂĉB
	 * 
	 * @param session ̃bZ[W Session IuWFNg
	 * @param is bZ[W̓Xg[
	 * @throws MessagingException
	 */
	public SMTPMessage(final Session session, final InputStream is) throws MessagingException {
		super(session, is);
	}

	/**
	 * <code>source</code> MimeMessage 珉ꂽeV SMTPMessage \z܂B
	 * VbZ[W͌̃bZ[WƓƗĂ܂B<p>
	 * 
	 * : ݂̎͂ǂ炩ƂƔłBKvȏɃf[^̃Rs[s܂B
	 * 
	 * @param source ẽRs[ƂȂ郁bZ[W
	 * @throws MessagingException
	 */
	public SMTPMessage(final MimeMessage source) throws MessagingException {
		super(source);
	}

	/**
	 * From AhX SMTP Gx[v悤ɐݒ肵܂B
	 * ꂪbZ[ŴɌ From AhXƈقȂ鎖ɒӂĉB
	 * ʏAGx[v From AhX́AG[񍐂鎞Ɏgp܂B
	 * ڍׂ <a href="http://www.ietf.org/rfc/rfc821.txt">RFC 821</A> QƂĉB<p>
	 * 
	 * <code>mail.smtp.from</code> vpeB𖳎Đݒ肵܂B
	 * 
	 * @param from Gx[v From AhX
	 */
	public void setEnvelopeFrom(final String from) {
		envelopeFrom = from;
	}

	/**
	 * Gx[v From AhXԂ܂B
	 * 
	 * @return Gx[v From AhXBlݒ肳ĂȂꍇ null
	 */
	public String getEnvelopeFrom() {
		return envelopeFrom;
	}

	/**
	 * T[ozM󋵒ʒmT|[gꍇAʒmIvVɎgplɐݒ肵܂B
	 * (<a href="http://www.ietf.org/rfc/rfc1891.txt">RFC 1891</a>)
	 * <code>NOTIFY_NEVER</code> 
	 * <code>NOTIFY_SUCCESS</code>A<code>NOTIFY_FAILURE</code>A
	 * y <code>NOTIFY_DELAY</code> ̑gݍ킹̂ǂ炩<p>
	 * 
	 * <code>mail.smtp.dsn.notify</code> vpeB𖳎Đݒ肵܂B
	 * 
	 * @param options ʒmIvV
	 */
	public void setNotifyOptions(final int options) {
		if (options < -1 || options >= 8)
			throw new IllegalArgumentException("Bad return option");
		notifyOptions = options;
	}

	/**
	 * ʒmIvV擾܂B
	 * IvVݒ肳ĂȂꍇ 0 Ԃ܂B
	 * 
	 * @return	ʒmIvV
	 */
	public int getNotifyOptions() {
		return notifyOptions;
	}

	/**
	 * RFC1891 ƂĒʒmIvVԂ܂B
	 * IvVݒ肳ĂȂꍇ null Ԃ܂B
	 */
	String getDSNNotify() {
		if (notifyOptions == 0)
			return null;
		if (notifyOptions == NOTIFY_NEVER)
			return "NEVER";
		StringBuffer sb = new StringBuffer();
		if ((notifyOptions & NOTIFY_SUCCESS) != 0)
			sb.append("SUCCESS");

		if ((notifyOptions & NOTIFY_FAILURE) != 0) {
			if (sb.length() != 0)
				sb.append(',');
			sb.append("FAILURE");
		}

		if ((notifyOptions & NOTIFY_DELAY) != 0) {
			if (sb.length() != 0)
				sb.append(',');
			sb.append("DELAY");
		}

		return sb.toString();
	}

	/**
	 * T[ozM󋵒ʒmT|[gꍇA^[IvVɎgplɐݒ肵܂B
	 * (<a href="http://www.ietf.org/rfc/rfc1891.txt">RFC 1891</a>)
	 * <code>RETURN_FULL</code>  <code>RETURN_HDRS</code> ̉ꂩB<p>
	 * 
	 * <code>mail.smtp.dsn.ret</code> vpeB𖳎Đݒ肵܂B
	 * 
	 * @param option ^[IvV
	 */
	public void setReturnOption(final int option) {
		if (option < 0 || option > RETURN_HDRS)
			throw new IllegalArgumentException("Bad return option");
		returnOption = option;
	}

	/**
	 * ^[IvVԂ܂B
	 * IvVݒ肳ĂȂꍇ 0 Ԃ܂B
	 * 
	 * @return ^[IvV
	 */
	public int getReturnOption() {
		return returnOption;
	}

	/**
	 * RFC1891 Ƃă^[IvVԂ܂B
	 * IvVݒ肳ĂȂꍇ null Ԃ܂B
	 */
	String getDSNRet() {
		return returnOptionString[returnOption];
	}

	/**
	 * If set to true, and the server supports the 8BITMIME extension, text
	 * parts of this message that use the "quoted-printable" or "base64"
	 * encodings are converted to use "8bit" encoding if they follow the
	 * RFC 2045 rules for 8bit text. <p>
	 * 
	 * If true, overrides the <code>mail.smtp.allow8bitmime</code> property.
	 * 
	 * @param allow 8rbgtO
	 */
	public void setAllow8bitMIME(final boolean allow) {
		allow8bitMIME = allow;
	}

	/**
	 * Is use of the 8BITMIME extension is allowed?
	 * 
	 * @return	8rbgtO
	 */
	public boolean getAllow8bitMIME() {
		return allow8bitMIME;
	}

	/**
	 * If set to true, and this message has some valid and some invalid
	 * addresses, send the message anyway, reporting the partial failure with
	 * a SendFailedException.  If set to false (the default), the message is
	 * not sent to any of the recipients if there is an invalid recipient
	 * address. <p>
	 * 
	 * If true, overrides the <code>mail.smtp.sendpartial</code> property.
	 * 
	 * @param partial	send partial flag
	 */
	public void setSendPartial(final boolean partial) {
		sendPartial = partial;
	}

	/**
	 * Send message if some addresses are invalid?
	 * 
	 * @return	send partial flag
	 */
	public boolean getSendPartial() {
		return sendPartial;
	}

	/**
	 * Gets the submitter to be used for the RFC 2554 AUTH= value in the MAIL FROM command.
	 * 
	 * @return the name of the submitter.
	 * @since JavaMail 1.3.2
	 */
	public String getSubmitter() {
		return submitter;
	}

	/**
	 * Sets the submitter to be used for the RFC 2554 AUTH= value in the MAIL FROM command.
	 * Normally only used by a server that's relaying a message.
	 * Clients will typically not set a submitter.
	 * See RFC 2554 for details.
	 * 
	 * @param submitter the name of the submitter
	 * @since JavaMail 1.3.2
	 */
	public void setSubmitter(final String submitter) {
		this.submitter = submitter;
	}

	/**
	 * Gets the extension string to use with the MAIL command.
	 * 
	 * @return the extension string
	 * @since JavaMail 1.3.2
	 */
	public String getMailExtension() {
		return extension;
	}

	/**
	 * Set the extension string to use with the MAIL command.
	 * The extension string can be used to specify standard SMTP service extensions as well as vendor-specific extensions.
	 * Typically the application should use the SMTPTransport method supportsExtension to verify that the server supports the desired service extension.
	 * See RFC 1869 and other RFCs that define specific extensions.<p>
	 * 
	 * For example:<p>
	 * 
	 * <blockquote><pre> 
	 * if (smtpTransport.supportsExtension("DELIVERBY"))
	 * 	smtpMsg.setMailExtension("BY=60;R");
	 * </pre></blockquote>
	 * 
	 * @since JavaMail 1.3.2
	 */
	public void setMailExtension(final String extension) {
		this.extension = extension;
	}

}
