/*
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.smtp;

import java.io.IOException;
import java.io.OutputStream;

import com.sun.mail.util.CRLFOutputStream;

/**
 * In addition to converting lines into the canonical format,
 * i.e., terminating lines with the CRLF sequence, escapes the "."
 * by adding another "." to any "." that appears in the beginning of a line.
 * RFC821 section 4.5.2 QƂĉB
 * 
 * @see CRLFOutputStream
 */
public final class SMTPOutputStream extends CRLFOutputStream {

	/**
	 * RXgN^łB
	 */
	public SMTPOutputStream(final OutputStream os) {
		super(os);
	}

	public void write(final int b) throws IOException {
		// if that last character was a newline, and the current
		// character is ".", we always write out an extra ".".
		if ((lastb == '\n' || lastb == '\r' || lastb == -1) && b == '.')
			out.write('.');

		super.write(b);
	}

	/* 
	 * ̃\bh́AptH[}ẌׂɒǉĂ܂B
	 */
	public void write(final byte b[], final int off, int len) throws IOException {
		int lastc = (lastb == -1) ? '\n' : lastb;
		int start = off;

		len += off;
		for (int i = off; i < len; i++) {
			if ((lastc == '\n' || lastc == '\r') && b[i] == '.') {
				super.write(b, start, i - start);
				out.write('.');
				start = i;
			}
			lastc = b[i];
		}
		if ((len - start) > 0)
			super.write(b, start, len - start);
	}

	/**
	 * FilterOutputStream  flush \bhI[o[Ch܂B
	 * 
	 * The MimeMessage writeTo method flushes its buffer at the end,
	 * but we don't want to flush data out to the socket until we've
	 * also written the terminating "\r\n.\r\n".
	 * 
	 * We buffer nothing so there's nothing to flush.  We depend
	 * on the fact that CRLFOutputStream also buffers nothing.
	 * SMTPTransport will manually flush the socket before reading
	 * the response.
	 */
	public void flush() {
		// Ȃ
	}

}
