/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.smtp;

import javax.mail.Address;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;

/**
 * ̗O̓bZ[W𑗐MłȂꍇɃX[܂B<p>
 * This exception will usually appear first in a chained list of exceptions, followed by SMTPAddressFailedExceptions and/or SMTPAddressSucceededExceptions, one per address.
 * This exception corresponds to one of the SMTP commands used to send a message, such as the MAIL, DATA, and "end of data" commands, but not including the RCPT command. 
 * 
 * @since JavaMail 1.3.2 
 */
public final class SMTPSendFailedException extends SendFailedException {

	private static final long serialVersionUID = 8049122628728932894L;

	protected InternetAddress addr;	// address that failed
	protected String cmd;				// command issued to server
	protected int rc;					// return code from SMTP server

	/**
	 * w肳ꂽAhXA^[R[hAyуG[ SMTPSendFailedException \z܂B
	 * 
	 * @param cmd SMTP T[oɑMR}h
	 * @param rc s SMTP ^[R[h
	 * @param err SMTP T[õG[
	 */
	public SMTPSendFailedException(
		final String cmd,
		final int rc,
		final String err,
		final Exception ex,
		final Address[] vs,
		final Address[] vus,
		final Address[] inv) {

		super(err, ex, vs, vus, inv);
		this.cmd = cmd;
		this.rc = rc;
	}

	/**
	 * sR}hԂ܂B
	 */
	public String getCommand() {
		return cmd;
	}

	/**
	 * s̗R SMTP T[õ^[R[hԂ܂B
	 * ^[R[hɂĂ <a href="http://www.ietf.org/rfc/rfc821.txt">RFC 821</a> QƂĉB
	 */
	public int getReturnCode() {
		return rc;
	}

}
