/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * ̃NX BASE64 GR[_܂B
 * It is implemented as
 * a FilterOutputStream, so one can just wrap this class around
 * any output stream and write bytes into this filter. The Encoding
 * is done as the bytes are written out.
 */
public class BASE64EncoderStream extends FilterOutputStream {

	private byte[] buffer; 	// cache of bytes that are yet to be encoded
	private int bufsize = 0;	// size of the cache
	private int count = 0; 	// number of bytes that have been output
	private int bytesPerLine;	// number of bytes per line

	private int lineLimit;
	private boolean noCRLF = false;
	private static byte[] newline = { '\r', '\n' };

	/**
	 * w肳ꂽ̓Xg[GR[h BASE64 GR[_쐬܂B
	 * 
	 * @param out o̓Xg[
	 * @param bytesPerLine number of bytes per line. The encoder inserts a CRLF sequence after the specified number of bytes
	 */
	public BASE64EncoderStream(final OutputStream out, int bytesPerLine) {
		super(out);
		buffer = new byte[3];
		if (bytesPerLine == 2147483647 || bytesPerLine < 4) {
			noCRLF = true;
			bytesPerLine = 76;
		}
		this.bytesPerLine = (bytesPerLine / 4) * 4;
		this.lineLimit = (bytesPerLine / 4) * 3;
	}

	/**
	 * w肳ꂽ̓Xg[GR[h BASE64 GR[_쐬܂B
	 * 76oCgo͂ɁACRLF V[PX}܂B
	 * 
	 * @param out o̓Xg[
	 */
	public BASE64EncoderStream(final OutputStream out) {
		this(out, 76);	
	}

	/**
	 * Encodes <code>len</code> bytes from the specified
	 * <code>byte</code> array starting at offset <code>off</code> to
	 * this output stream.
	 * 
	 * @param b f[^
	 * @param off the start offset in the data.
	 * @param len the number of bytes to write.
	 * @throws IOException o͗Oꍇ
	 */
	public final void write(final byte[] b, int off, int len) throws IOException {
		for (; (bufsize != 0 || count != 0) && len > 0; len--)
			write(b[off++]);

		byte bytes[];
		if (noCRLF) {
			bytes = new byte[bytesPerLine];
		} else {
			bytes = new byte[bytesPerLine + 2];
			bytes[bytesPerLine] = '\r';
			bytes[bytesPerLine + 1] = '\n';
        }
		int i;
		for (i = 0; i + lineLimit < len; i += lineLimit)
			super.out.write(encode(b, off + i, lineLimit, bytes));

		for(; i < len; i++)
			write(b[off + i]);
	}

	/**
	 * w肳ꂽ <code>b.length</code> ̏o̓Xg[ɃGR[h܂B
	 * 
	 * @param b the data to be written.
	 * @throws IOException o͗Oꍇ
	 */
	public final void write(final byte[] b) throws IOException {
		write(b, 0, b.length);
	}

	/**
	 * w肳ꂽ <code>byte</code> ̏o̓Xg[ɃGR[h܂B
	 * 
	 * @param c <code>byte</code>.
	 * @throws IOException o͗Oꍇ
	 */
	public final void write(final int c) throws IOException {
		buffer[bufsize++] = (byte) c;
		if (bufsize == 3) { // Encoding unit = 3 bytes
			encode();
			bufsize = 0;
		}
	}

	/**
	 * Flushes this output stream and forces any buffered output bytes
	 * to be encoded out to the stream. 
	 *
	 * @throws IOException o͗Oꍇ
	 */
	public final void flush() throws IOException {
		if (bufsize > 0) { // If there's unencoded characters in the buffer ..
			encode();      // .. encode them
			bufsize = 0;
		}
		out.flush();
	}

	/**
	 * Forces any buffered output bytes to be encoded out to the stream
	 * and closes this output stream
	 */
	public final void close() throws IOException {
		flush();
		out.close();
	}

	/** This array maps the characters to their 6 bit values */
	private final static char pem_array[] = {
		'A','B','C','D','E','F','G','H', // 0
		'I','J','K','L','M','N','O','P', // 1
		'Q','R','S','T','U','V','W','X', // 2
		'Y','Z','a','b','c','d','e','f', // 3
		'g','h','i','j','k','l','m','n', // 4
		'o','p','q','r','s','t','u','v', // 5
		'w','x','y','z','0','1','2','3', // 6
		'4','5','6','7','8','9','+','/'  // 7
	};

	private void encode() throws IOException {
		// If writing out this encoded unit will cause overflow,
		// start a new line.
		if (count + 4 > bytesPerLine) {
			if (!noCRLF)
				super.out.write(newline);
			count = 0;
		}
		super.out.write(encode(buffer, 0, bufsize, null));
		// increment count
		count += 4;
	}

	/**
	 * Base64 encode a byte array.  No line breaks are inserted.
	 * This method is suitable for short strings, such as those
	 * in the IMAP AUTHENTICATE protocol, but not to encode the
	 * entire content of a MIME part.
	 */
	public static final byte[] encode(final byte[] inbuf) {
		if(inbuf.length == 0)
			return inbuf;
		return encode(inbuf, 0, inbuf.length, null);
	}

	private static byte[] encode(byte inbuf[], int off, int len, byte outbuf[]) {
		if (outbuf == null)
			outbuf = new byte[((len + 2) / 3) * 4];
		int inpos = off;
		int outpos;
		for (outpos = 0; len >= 3; outpos += 4) {
			int i1 = inbuf[inpos++] & 0xff;
			i1 <<= 8;
			i1 |= inbuf[inpos++] & 0xff;
			i1 <<= 8;
			i1 |= inbuf[inpos++] & 0xff;
			outbuf[outpos + 3] = (byte)pem_array[i1 & '?'];
			i1 >>= 6;
			outbuf[outpos + 2] = (byte)pem_array[i1 & '?'];
			i1 >>= 6;
			outbuf[outpos + 1] = (byte)pem_array[i1 & '?'];
			i1 >>= 6;
			outbuf[outpos + 0] = (byte)pem_array[i1 & '?'];
			len -= 3;
		}

		if (len == 1) {
			int j1 = inbuf[inpos++] & 0xff;
			j1 <<= 4;
			outbuf[outpos + 3] = '=';
			outbuf[outpos + 2] = '=';
			outbuf[outpos + 1] = (byte)pem_array[j1 & '?'];
			j1 >>= 6;
			outbuf[outpos] = (byte)pem_array[j1 & '?'];
		} else if (len == 2) {
			int k1 = inbuf[inpos++] & 0xff;
			k1 <<= 8;
			k1 |= inbuf[inpos++] & 0xff;
			k1 <<= 2;
			outbuf[outpos + 3] = 61;
			outbuf[outpos + 2] = (byte)pem_array[k1 & '?'];
			k1 >>= 6;
			outbuf[outpos + 1] = (byte)pem_array[k1 & '?'];
			k1 >>= 6;
			outbuf[outpos + 0] = (byte)pem_array[k1 & '?'];
		}
		return outbuf;
	}

}
