/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.util;

import java.io.IOException;
import java.io.InputStream;

/**
 * ̃NX MIME wb_fR[h RFC2047 ɒ` Q fR[_܂B
 * QPDecoderStream NX̃TuNXłB
 */
public final class QDecoderStream extends QPDecoderStream {

	/**
	 * w肳ꂽ̓Xg[fR[h Q fR[_쐬܂B
	 * 
	 * @param in ̓Xg[
	 */
	public QDecoderStream(final InputStream in) {
		super(in);
	}

	/**
	 * Read the next decoded byte from this input stream. The byte
	 * is returned as an <code>int</code> in the range <code>0</code>
	 * to <code>255</code>. If no byte is available because the end of
	 * the stream has been reached, the value <code>-1</code> is returned.
	 * This method blocks until input data is available, the end of the
	 * stream is detected, or an exception is thrown.
	 * 
	 * @return the next byte of data, or <code>-1</code> if the end of the stream is reached.
	 * @throws IOException o͗Oꍇ
	 */
	public int read() throws IOException {
		int c = in.read();

		if (c == '_') // Return '_' as ' '
			return ' ';
		if (c == '=') {
			// QP Encoded atom. Get the next two bytes ..
			ba[0] = (byte) in.read();
			ba[1] = (byte) in.read();
			// .. and decode them
			try {
				return ASCIIUtility.parseInt(ba, 0, 2, 16);
			} catch (NumberFormatException nex) {
				throw new IOException("Error in QP stream " + nex.getMessage());
			}
		}
		return c;
	}

}
