/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.util;

import java.io.IOException;
import java.io.OutputStream;

/**
 * ̃NX MIME wb_GR[h RFC2047 ɒ` Q GR[_܂B
 * QPEncoderStream NX̃TuNXłB
 */
public final class QEncoderStream extends QPEncoderStream {

	private String specials;
	private static String WORD_SPECIALS = "=_?\"#$%&'(),.:;<>@[\\]^`{|}~";
	private static String TEXT_SPECIALS = "=_?";

	/**
	 * w肳ꂽ̓Xg[GR[h Q GR[_쐬܂B
	 * 
	 * @param out o̓Xg[
	 * @param encodingWord true if we are Q-encoding a word within a phrase.
	 */
	public QEncoderStream(final OutputStream out, final boolean encodingWord) {
		super(out, Integer.MAX_VALUE); // MAX_VALUE is 2^31, should
		// suffice (!) to indicate that
		// CRLFs should not be inserted
		// when encoding rfc822 headers

		// a RFC822 "word" token has more restrictions than a
		// RFC822 "text" token.
		specials = encodingWord ? WORD_SPECIALS : TEXT_SPECIALS;
	}

	/**
	 * Encodes the specified <code>byte</code> to this output stream.
	 * 
	 * @param c <code>byte</code>.
	 * @throws IOException o͗Oꍇ
	 */
	public void write(int c) throws IOException {
		c = c & 0xff; // Turn off the MSB.
		if (c == ' ')
			output('_', false);
		else if (c < 040 || c >= 0177 || specials.indexOf(c) >= 0)
			// Encoding required. 
			output(c, true);
		else // No encoding required
			output(c, false);
	}

	/**
	 * Returns the length of the encoded version of this byte array.
	 */
	public static int encodedLength(final byte[] b, final boolean encodingWord) {
		int len = 0;
		String specials = encodingWord ? WORD_SPECIALS: TEXT_SPECIALS;
		for (int i = 0; i < b.length; i++) {
			int c = b[i] & 0xff; // Mask off MSB
			if (c < 040 || c >= 0177 || specials.indexOf(c) >= 0)
				// needs encoding
				len += 3; // Q-encoding is 1 -> 3 conversion
			else
				len++;
		}
		return len;
	}

}
