/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

/**
 * ̃NX QP fR[_܂B
 * It is implemented as
 * a FilterInputStream, so one can just wrap this class around
 * any input stream and read bytes from this filter. The decoding
 * is done as the bytes are read out.
 */
public class QPDecoderStream extends FilterInputStream {

	protected byte[] ba = new byte[2];
	protected int spaces = 0;

	/**
	 * w肳ꂽ̓Xg[fR[h Quoted Printable fR[_쐬܂B
	 * 
	 * @param in ̓Xg[
	 */
	public QPDecoderStream(final InputStream in) {
		super(new PushbackInputStream(in, 2)); // pushback of size=2
	}

	/**
	 * Read the next decoded byte from this input stream. The byte
	 * is returned as an <code>int</code> in the range <code>0</code>
	 * to <code>255</code>. If no byte is available because the end of
	 * the stream has been reached, the value <code>-1</code> is returned.
	 * This method blocks until input data is available, the end of the
	 * stream is detected, or an exception is thrown.
	 * 
	 * @return the next byte of data, or <code>-1</code> if the end of the stream is reached.
	 * @throws IOException o͗Oꍇ
	 */
	public int read() throws IOException {
		if (spaces > 0) {
			// We have cached space characters, return one
			spaces--;
			return ' ';
		}

		int c = in.read();

		if (c == ' ') { 
			// Got space, keep reading till we get a non-space char
			while ((c = in.read()) == ' ')
				spaces++;

			if (c == '\r' || c == '\n' || c == -1)
				// If the non-space char is CR/LF/EOF, the spaces we got
				// so far is junk introduced during transport. Junk 'em.
				spaces = 0;
			else {
				// The non-space char is NOT CR/LF, the spaces are valid.
				((PushbackInputStream)in).unread(c);
				c = ' ';
			}
			return c; // return either <SPACE> or <CR/LF>
		}
		if (c == '=') {
			// QP Encoded atom. Decode the next two bytes
			int a = in.read();

			if (a == '\n')
				/* Hmm ... not really confirming QP encoding, but lets
				 * allow this as a LF terminated encoded line .. and
				 * consider this a soft linebreak and recurse to fetch 
				 * the next char.
				 */
				return read();

			if (a == '\r') {
				// Expecting LF. This forms a soft linebreak to be ignored.
				int b = in.read();
				if (b != '\n') 
					/* Not really confirming QP encoding, but
					 * lets allow this as well.
					 */
					((PushbackInputStream)in).unread(b);
				return read();
			}
			if (a == -1)
				// Not valid QP encoding, but we be nice and tolerant here !
				return -1;

			ba[0] = (byte) a;
			ba[1] = (byte) in.read();
			try {
				return ASCIIUtility.parseInt(ba, 0, 2, 16);
			} catch (NumberFormatException nex) {
				/*
				System.err.println("Illegal characters in QP encoded stream: " + ASCIIUtility.toString(ba, 0, 2));
				*/

				((PushbackInputStream)in).unread(ba);
				return c;
			}
		}
		return c;
	}

	/**
	 * Reads up to <code>len</code> decoded bytes of data from this input stream
	 * into an array of bytes. This method blocks until some input is
	 * available.
	 * <p>
	 * 
	 * @param buf the buffer into which the data is read.
	 * @param off the start offset of the data.
	 * @param len the maximum number of bytes read.
	 * @return the total number of bytes read into the buffer, or
	 *             <code>-1</code> if there is no more data because the end of
	 *             the stream has been reached.
	 * @throws IOException o͗Oꍇ
	 */
	public int read(final byte[] buf, final int off, final int len) throws IOException {
		int i;
		for (i = 0; i < len; i++) {
			int c;
			if ((c = read()) == -1) {
				if (i == 0) // At end of stream, so we should
					i = -1; // return -1 , NOT 0.
				break;
			}
			buf[off+i] = (byte) c;
		}
		return i;
	}

	/**
	 * ̓̓Xg[}[NT|[g邩eXg܂B
	 * ݁ÃNX̓}[NT|[g܂B
	 */
	public boolean markSupported() {
		return false;
	}

	/**
	 * Returns the number of bytes that can be read from this input
	 * stream without blocking. The QP algorithm does not permit
	 * a priori knowledge of the number of bytes after decoding, so
	 * this method just invokes the <code>available</code> method
	 * of the original input stream.
	 */
	public int available() throws IOException {
		// This is bogus ! We don't really know how much
		// bytes are available *after* decoding
		return in.available();
	}

}
