/*
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * ̃NX Quoted Printable GR[_܂B
 * It is implemented as
 * a FilterOutputStream, so one can just wrap this class around
 * any output stream and write bytes into this filter. The Encoding
 * is done as the bytes are written out.
 */
public class QPEncoderStream extends FilterOutputStream {

	private int count = 0; 	// number of bytes that have been output
	private int bytesPerLine;	// number of bytes per line
	private boolean gotSpace = false;
	private boolean gotCR = false;

	/**
	 * w肳ꂽ̓Xg[GR[h QP GR[_쐬܂B
	 * 
	 * @param out o̓Xg[
	 * @param bytesPerLine  the number of bytes per line. The encoder
	 *                   inserts a CRLF sequence after this many number of bytes.
	 */
	public QPEncoderStream(final OutputStream out, final int bytesPerLine) {
		super(out);
		// Subtract 1 to account for the '=' in the soft-return 
		// at the end of a line
		this.bytesPerLine = bytesPerLine - 1;
	}

	/**
	 * w肳ꂽ̓Xg[GR[h QP GR[_쐬܂B
	 * 76oCgo͂ɁACRLF V[PX}܂B
	 * 
	 * @param out o̓Xg[
	 */
	public QPEncoderStream(final OutputStream out) {
		this(out, 76);	
	}

	/**
	 * Encodes <code>len</code> bytes from the specified
	 * <code>byte</code> array starting at offset <code>off</code> to
	 * this output stream.
	 * 
	 * @param b f[^
	 * @param off the start offset in the data.
	 * @param len the number of bytes to write.
	 * @throws IOException o͗Oꍇ
	 */
	public void write(final byte[] b, final int off, final int len) throws IOException {
		for (int i = 0; i < len; i++)
			write(b[off + i]);
	}

	/**
	 * <code>b.length</code> oCg̏o̓Xg[ɃGR[h܂B
	 * 
	 * @param b the data to be written.
	 * @throws IOException o͗Oꍇ
	 */
	public void write(final byte[] b) throws IOException {
		write(b, 0, b.length);
	}

	/**
	 * <code>byte</code> ̏o̓Xg[ɃGR[h܂B
	 * 
	 * @param c <code>byte</code>.
	 * @throws IOException o͗Oꍇ
	 */
	public void write(int c) throws IOException {
		c = c & 0xff; // Turn off the MSB.
		if (gotSpace) { // previous character was <SPACE>
			if (c == '\r' || c == '\n')
				// if CR/LF, we need to encode the <SPACE> char
				output(' ', true);
			else // no encoding required, just output the char
				output(' ', false);
				gotSpace = false;
		}

		if (c == '\r') {
			gotCR = true;
			outputCRLF();
		} else {
			if (c == '\n') {
				if (!gotCR) 
					// This is a CRLF sequence, we already output the 
					// corresponding CRLF when we got the CR, so ignore this
					outputCRLF();
			} else if (c == ' ') {
				gotSpace = true;
			} else if (c < 040 || c >= 0177 || c == '=')
				// Encoding required. 
				output(c, true);
			else // No encoding required
				output(c, false);
			// whatever it was, it wasn't a CR
			gotCR = false;
		}
	}

	/**
	 * Flushes this output stream and forces any buffered output bytes
	 * to be encoded out to the stream.
	 *
	 * @throws IOException o͗Oꍇ
	 */
	public void flush() throws IOException {
		out.flush();
	}

	/**
	 * Forces any buffered output bytes to be encoded out to the stream
	 * and closes this output stream
	 */
	public void close() throws IOException {
		out.close();
	}

	private void outputCRLF() throws IOException {
		out.write('\r');
		out.write('\n');
		count = 0;
	}

	// GR[fBO e[u
	private final static char hex[] = {
		'0','1', '2', '3', '4', '5', '6', '7',
		'8','9', 'A', 'B', 'C', 'D', 'E', 'F'
	};

	protected void output(final int c, final boolean encode) throws IOException {
		if (encode) {
			if ((count += 3) > bytesPerLine) {
				out.write('=');
				out.write('\r');
				out.write('\n');
				count = 3; // set the next line's length
			}
			out.write('=');
			out.write(hex[c >> 4]);
			out.write(hex[c & 0xf]);
		} else {
			if (++count > bytesPerLine) {
				out.write('=');
				out.write('\r');
				out.write('\n');
				count = 1; // set the next line's length
			}
			out.write(c);
		}
	}

}
