/*
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * This class is a FilterInputStream that writes the bytes
 * being read from the given input stream into the given output
 * stream. This class is typically used to provide a trace of
 * the data that is being retrieved from an input stream.
 */
public final class TraceInputStream extends FilterInputStream {

	private boolean trace = false;
	private boolean quote = false;
	private OutputStream traceOut;

	/**
	 * w肳ꂽ̓Xg[̏őgĂꂽ̓Xg[tB^쐬܂B
	 * 
	 * @param in bƂȂ̓Xg[
	 * @param traceOut g[XpXg[
	 */
	public TraceInputStream(final InputStream in, final OutputStream traceOut) {
		super(in);
		this.traceOut = traceOut;
	}

	/**
	 * g[X[hݒ肵܂B
	 * 
	 * @param trace g[X[h
	 */
	public void setTrace(final boolean trace) {
		this.trace = trace;
	}

	/**
	 * NI[^[hݒ肵܂B
	 * 
	 * @param quote NI[^[h
	 */
	public void setQuote(final boolean quote) {
		this.quote = quote;
	}

	/**
	 * ̓̓Xg[玟̃oCgf[^ǂݍ݂܂B
	 * f[^Ȃꍇ <code>-1</code> Ԃ܂B
	 * Writes out the read byte into the trace stream, if trace mode is <code>true</code>
	 */
	public int read() throws IOException {
		int b = in.read();
		if (trace && b != -1) {
			if (quote)
				writeByte(b);
			else
				traceOut.write(b);
		}
		return b;
	}

	/**
	 * ̓̓Xg[ <code>len</code> oCg܂ł̃f[^oCgzɓǂݍ݂܂B
	 * f[^Ȃꍇ <code>-1</code> Ԃ܂B
	 * Writes out the read bytes into the trace stream, if trace mode is <code>true</code>
	 */
	public int read(final byte b[], final int off, final int len) throws IOException {
		int count = in.read(b, off, len);
		if (trace && count != -1) {
			if (quote) {
				for (int i = 0; i < count; i++)
					writeByte(b[off + i]);
			} else
				traceOut.write(b, off, count);
		}
		return count;
	}

	/**
	 * Write a byte in a way that every byte value is printable ASCII.
	 */
	private final void writeByte(int b) throws IOException {
		b &= 0xff;
		if (b > 0x7f) {
			traceOut.write('M');
			traceOut.write('-');
			b &= 0x7f;
		}
		if (b == '\r') {
			traceOut.write('\\');
			traceOut.write('r');
		} else if (b == '\n') {
			traceOut.write('\\');
			traceOut.write('n');
			traceOut.write('\n');
		} else if (b == '\t') {
			traceOut.write('\\');
			traceOut.write('t');
		} else if (b < ' ') {
			traceOut.write('^');
			traceOut.write('@' + b);
		} else {
			traceOut.write(b);
		}
	}

}
