/*
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * ̃NX͕ʂ̏o̓Xg[ DataOutputStream ɏo͂Ăf[^Rs[ DataOutputStream ̃TuNXłB
 * ̃NX DataOutputStream ɏo͂ꂽ̃fobOg[X񋟂ׂɎgp܂B
 */
public final class TraceOutputStream extends FilterOutputStream {

	private boolean trace = false;
	private boolean quote = false;
	private OutputStream traceOut;

	/**
	 * w肳ꂽ{Iȏo̓Xg[̏őgĂꂽo̓Xg[tB^쐬܂B
	 * 
	 * @param out bƂȂo̓Xg[
	 * @param traceOut g[XpXg[
	 */
	public TraceOutputStream(final OutputStream out, final OutputStream traceOut) {
		super(out);
		this.traceOut = traceOut;
	}

	/**
	 * g[X[hݒ肵܂B
	 */
	public void setTrace(final boolean trace) {
		this.trace = trace;
	}

	/**
	 * NI[^[hݒ肵܂B
	 * 
	 * @param quote NI[^[h
	 */
	public void setQuote(final boolean quote) {
		this.quote = quote;
	}

	/**
	 * w肳ꂽ <code>byte</code> ̏o̓Xg[ɏ݂܂B
	 * Writes out the byte into the trace stream if the trace mode is <code>true</code>
	 */
	public void write(final int b) throws IOException {
		if (trace) {
			if (quote)
				writeByte(b);
			else
				traceOut.write(b);
		}
		out.write(b);
	}

	/**
	 * w肳ꂽ <code>b.length</code> ̏o̓Xg[ɏ݂܂B
	 * Writes out the bytes into the trace stream if the trace mode is <code>true</code>
	 */
	public void write(final byte b[], final int off, final int len) throws IOException {
		if (trace) {
			if (quote) {
				for (int i = 0; i < len; i++)
					writeByte(b[off + i]);
			} else
				traceOut.write(b, off, len);
		}
		out.write(b, off, len);
	}

	/**
	 * Write a byte in a way that every byte value is printable ASCII.
	 */
	private final void writeByte(int b) throws IOException {
		b &= 0xff;
		if (b > 0x7f) {
			traceOut.write('M');
			traceOut.write('-');
			b &= 0x7f;
		}
		if (b == '\r') {
			traceOut.write('\\');
			traceOut.write('r');
		} else if (b == '\n') {
			traceOut.write('\\');
			traceOut.write('n');
			traceOut.write('\n');
		} else if (b == '\t') {
			traceOut.write('\\');
			traceOut.write('t');
		} else if (b < ' ') {
			traceOut.write('^');
			traceOut.write('@' + b);
		} else
			traceOut.write(b);
	}

}
