/*
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * ̃NX UUDecoder ܂B
 * FilterInputStream ƂĎŝŁAǂ̗lȓ̓Xg[ł̃NXgpāA
 * ̃tB^oCgǂގł܂B
 * oCgǍގɃfR[h܂B
 */
public final class UUDecoderStream extends FilterInputStream {

	private String name;
	private int mode;

	private byte[] buffer; 	// fR[hꂽoCg̃LbV
	private int bufsize = 0;	// LbVTCY
	private int index = 0;		// LbVCfbNX
	private boolean gotPrefix = false;
	private boolean gotEnd = false;
	private LineInputStream lin;

	/**
	 * w肳ꂽ̓Xg[fR[h UUdecoder 쐬܂B
	 * 
	 * @param in ̓Xg[
	 */
	public UUDecoderStream(final InputStream in) {
		super(in);
		lin = new LineInputStream(in);
		buffer = new byte[45]; // max decoded chars in a line = 45
	}

	/**
	 * ̓̓Xg[玟̃fR[hꂽoCgǍ݂܂B
	 * oCg̒l <code>0</code> ` <code>255</code> ͈̔͂̒lƂ <code>int</code> ƂĕԂ܂B
	 * Xg[̏IɒBēǂݍރf[^Ȃꍇ <code>-1</code> Ԃ܂B
	 * ̃\bh́A̓f[^ǂݍ߂lɂȂ邩AXg[̏I肪o邩A͗OX[܂ŃubN܂B
	 * 
	 * @return next f[^̃oCgBXg[̏IɒBꍇ -1
	 * @throws IOException o͗Oꍇ
	 * @see java.io.FilterInputStream#in
	 */
	public int read() throws IOException {
		if (index >= bufsize) {
			readPrefix();
			if (!decode())
				return -1;
			index = 0; // obt@̒ɃCfbNXZbg܂
		}
		return buffer[index++] & 0xff; // ʃoCgԂ܂
	}

	public int read(final byte[] buf, final int off, final int len) throws IOException {
		int i;
		for (i = 0; i < len; i++) {
			int c;
			if ((c = read()) == -1) {
				if (i == 0) // At end of stream, so we should
					i = -1; // return -1, NOT 0.
				break;
			}
			buf[off+i] = (byte) c;
		}
		return i;
	}

	public boolean markSupported() {
		return false;
	}

	public int available() throws IOException {
		// This is only an estimate, since in.available()
		// might include CRLFs too ..
		return ((in.available() * 3) / 4 + (bufsize - index));
	}

	/**
	 * ړꂩ "name" tB[h擾܂B
	 * ̓fR[hꂽt@C̃pXłB
	 * 
	 * @return fR[hꂽt@C̖O
	 * @throws IOException o͗Oꍇ
	 */
	public String getName() throws IOException {
		readPrefix();
		return name;
	}

	/**
	 * ړꂩ "mode" tB[h擾܂B
	 * ̓\[Xt@C̋[hłB
	 *
	 * @return \[Xt@C̋[h
	 * @throws IOException o͗Oꍇ
	 */
	public int getMode() throws IOException {
		readPrefix();
		return mode;
	}

	/**
	 * UUencoded streams start off with the line: "begin <mode> <filename>"
	 * Search for this prefix and gobble it up.
	 */
	private void readPrefix() throws IOException {
		if (gotPrefix) // got the prefix
			return;

		String s;
		do {
			// read till we get the prefix: "begin MODE FILENAME"
			s = lin.readLine(); // NOTE: readLine consumes CRLF pairs too
			if (s == null)
				throw new IOException("UUDecoder error: No Begin");
		} while (s.regionMatches(true, 0, "begin", 0, 5));
		try {
			mode = Integer.parseInt(s.substring(6, 9));
		} catch (NumberFormatException ex) {
			throw new IOException("UUDecoder error: " + ex.toString());
		}
		name = s.substring(10);
		gotPrefix = true;
	}

	private boolean decode() throws IOException {
		if (gotEnd)
			return false;
		bufsize = 0;
		String line;
		do {
			line = lin.readLine();

			/*
			 * Improperly encoded data sometimes omits the zero length
			 * line that starts with a space character, we detect the
			 * following "end" line here.
			 */
			if (line == null)
				throw new IOException("Missing End");
			if (line.regionMatches(true, 0, "end", 0, 3)) {
				gotEnd = true;
				return false;
			}
		} while (line.length() == 0);
		int count = line.charAt(0);
		if (count < ' ')
			throw new IOException("Buffer format error");

		/*
		 * The first character in a line is the number of original (not
		 *  the encoded atoms) characters in the line. Note that all the
		 *  code below has to handle the <SPACE> character that indicates
		 *  end of encoded stream.
		 */
		count = (count - ' ') & 0x3f;

		if (count == 0) {
			line = lin.readLine();
			if (line == null || !line.regionMatches(true, 0, "end", 0, 3))
				throw new IOException("Missing End");
			gotEnd = true;
			return false;
		}

		int need = ((count * 8) + 5) / 6;
//System.out.println("count " + count + ", need " + need + ", len " + line.length());
		if (line.length() < need + 1)
			throw new IOException("Short buffer error");

		int i = 1;
		/*
		 * A correct uuencoder always encodes 3 characters at a time, even
		 * if there aren't 3 characters left.  But since some people out
		 * there have broken uuencoders we handle the case where they
		 * don't include these "unnecessary" characters.
		 */
		while (bufsize < count) {
			// continue decoding until we get 'count' decoded chars
			byte a = (byte) ((line.charAt(i++) - ' ') & 0x3f);
			byte b = (byte) ((line.charAt(i++) - ' ') & 0x3f);
			buffer[bufsize++] = (byte) (((a << 2) & 0xfc) | ((b >>> 4) & 3));

			if (bufsize < count) {
				a = b;
				b = (byte) ((line.charAt(i++) - ' ') & 0x3f);
				buffer[bufsize++] = (byte) (((a << 4) & 0xf0) | ((b >>> 2) & 0xf));
			}

			if (bufsize < count) {
				a = b;
				b = (byte) ((line.charAt(i++) - ' ') & 0x3f);
				buffer[bufsize++] = (byte) (((a << 6) & 0xc0) | (b & 0x3f));
		    }
		}
		return true;
	}

}
