/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

/**
 * ̃NX UUEncoder ܂B<p>
 * 
 * FilterOutputStream ƂĎŝŁA
 * ̃NXǂ̗lȏo̓Xg[ɔ킹ĂA
 * ̃tB^ɃoCgł܂B
 */
public final class UUEncoderStream extends FilterOutputStream {

	private byte[] buffer; 	// ܂GR[hĂȂoCg̃LbV
	private int bufsize = 0;	// LbVTCY
	private boolean wrotePrefix = false;

	protected String name; 	// t@C̖O
	protected int mode;		// p[~bV [h

	/**
	 * w肳ꂽ̓Xg[GR[h UUencoder 쐬܂B
	 * 
	 * @param out o̓Xg[
	 */
	public UUEncoderStream(final OutputStream out) {
		this(out, "encoder.buf", 644);
	}

	/**
	 * w肳ꂽ̓Xg[GR[h UUencoder 쐬܂B
	 * 
	 * @param out o̓Xg[
	 * @param name GR[hobt@̖Ow肵܂
	 */
	public UUEncoderStream(final OutputStream out, final String name) {
		this(out, name, 644);	
	}

	/**
	 * w肳ꂽ̓Xg[GR[h UUencoder 쐬܂B
	 * 
	 * @param out o̓Xg[
	 * @param name GR[hobt@̖Ow肵܂
	 * @param mode GR[hobt@̃p[~bbV[hw肵܂
	 */
	public UUEncoderStream(final OutputStream out, final String name, final int mode) {
		super(out);
		this.name = name;
		this.mode = mode;
		buffer = new byte[45];
	}

	/**
	 * obt@ƃp[~bV[hݒ肵܂B
	 * ̃\bh́Ao̓Xg[ɏo͂OɌĂяoꂽꍇɂʂ܂B
	 */
	public void setNameMode(final String name, final int mode) {
		this.name = name;
		this.mode = mode;
	}

	public void write(final byte[] b, final int off, final int len) throws IOException {
		for (int i = 0; i < len; i++)
			write(b[off + i]);
	}

	public void write(final byte[] data) throws IOException {
		write(data, 0, data.length);
	}

	public void write(final int c) throws IOException {
		/* buffer up characters till we get a line's worth, then encode
		 * and write them out.
		 * 1sɋLN^̍ő吔 45 łB
		 */
		buffer[bufsize++] = (byte) c;
		if (bufsize == 45) {
			writePrefix();
			encode();
			bufsize = 0;
		}
	}

	public void flush() throws IOException {
		if (bufsize > 0) { // obt@ɔGR[hĂȂLN^ꍇ
			writePrefix();
			encode();      // .. GR[h܂
		}
		writeSuffix();
		out.flush();
	}

	public void close() throws IOException {
		flush();
		out.close();
	}

	/**
	 * ړo͂܂B: "begin <mode> <name>"
	 */
	private void writePrefix() /* throws IOException */ {
		if (!wrotePrefix) {
			PrintStream ps = new PrintStream(out);
			ps.println("begin " + mode + ' ' + name);
			ps.flush();
			wrotePrefix = true;
		}
	}

	/**
	 * Xy[X܂ޒPs "end" ܂ސڔo͂܂B(VsŏI܂)
	 */
	private void writeSuffix() /* throws IOException */ {
		PrintStream ps = new PrintStream(out);
		ps.println(" \nend");
		ps.flush();
	}

	/**
	 * sGR[h܂B
	 * Start off with the character count, followed by the encoded atoms
	 * and terminate with LF. (or is it CRLF or the local line-terminator ?)
	 * Take three bytes and encodes them into 4 characters
	 * If bufsize if not a multiple of 3, the remaining bytes are filled 
	 * with '1'. This insures that the last line won't end in spaces 
	 * and potentiallly be truncated.
	 */
	private void encode() throws IOException {
		int i = 0;

		// Start off with the count of characters in the line
		out.write((bufsize & 0x3f) + ' ');

		while (i < bufsize) {
			byte a = buffer[i++];
			byte b;
			byte c;
			if (i < bufsize) {
				b = buffer[i++];
				if (i < bufsize)
					c = buffer[i++];
				else // default c to 1
					c = 1;
			} else { // default b & c to 1
				b = 1;
				c = 1;
			}

			int c1 = (a >>> 2) & 0x3f;
			int c2 = ((a << 4) & 0x30) | ((b >>> 4) & 0xf);
			int c3 = ((b << 2) & 0x3c) | ((c >>> 6) & 0x3);
			int c4 = c & 0x3f;
			out.write(c1 + ' ');
			out.write(c2 + ' ');
			out.write(c3 + ' ');
			out.write(c4 + ' ');
		}
		// Terminate with LF. (should it be CRLF or local line-terminator ?)
		out.write('\n');
	}

}
