/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.net.InetAddress;

/**
 * Authenticator NX́Albg[NڑɕKvȔF؂擾ׂ̃IuWFN
 * g\܂Bʏ́A[Uɏ̓͂߂鎖ɂAF؂s܂B
 * <p>
 * AvP[Vł̃NXgɂ́ATuNX쐬A̎̃ZbV
 * găVXeɃTuNX̃CX^Xo^܂BF؂vƁA
 * VXe̓TuNX̃\bh (getPasswordAuthentication Ȃ) Ăяo
 * BTuNX̃\bh́Ǎpꂽ\bh (getRequesting Ŏn܂
 * \bh) gāAvꂽF؂ɂďƉsł܂B̌ŁA
 * [Uɕ\K؂ȃbZ[W`ł܂B
 * <p>
 * F؂v郁\bh͑SāAsɏIftHgĂ܂B
 * 
 * @see java.net.Authenticator
 * @see javax.mail.Session#getInstance(java.util.Properties, javax.mail.Authenticator)
 * @see javax.mail.Session#getDefaultInstance(java.util.Properties, javax.mail.Authenticator)
 * @see javax.mail.Session#requestPasswordAuthentication
 * @see javax.mail.PasswordAuthentication
 */
// There are no abstract methods, but to be useful the user must subclass.
public abstract class Authenticator {

	private InetAddress requestingSite;
	private int requestingPort;
	private String requestingProtocol;
	private String requestingPrompt;
	private String requestingUserName;

	private void reset() {
		requestingSite = null;
		requestingPort = -1;
		requestingProtocol = null;
		requestingPrompt = null;
		requestingUserName = null;
	}

	/**
	 * Ask the authenticator for a password.<p>
	 * 
	 * @param addr The InetAddress of the site requesting authorization,
	 *             or null if not known.
	 * @param port the port for the requested connection
	 * @param protocol The protocol that's requesting the connection
	 *          (@see java.net.Authenticator.getProtocol())
	 * @param prompt A prompt string for the user
	 * @return The username/password, or null if one can't be gotten.
	 */
	final PasswordAuthentication requestPasswordAuthentication(
		final InetAddress addr,
		final int port,
		final String protocol,
		final String prompt,
		final String defaultUserName) {

		reset();
		requestingSite = addr;
		requestingPort = port;
		requestingProtocol = protocol;
		requestingPrompt = prompt;
		requestingUserName = defaultUserName;
		return getPasswordAuthentication();
	}

	/**
	 * @return F؂vĂTCg InetAddressB
	 * InetAddress gpłȂꍇ null
	 */
	protected final InetAddress getRequestingSite() {
		return requestingSite;
	}

	/**
	 * @return vꂽڑɎg|[gԍ
	 */
	protected final int getRequestingPort() {
		return requestingPort;
	}

	/**
	 * ڑvĂvgR^܂B
	 * ̏ꍇ URLName ɊÂ܂B
	 * 
	 * @return vgR
	 * @see javax.mail.URLName#getProtocol
	 */
	protected final String getRequestingProtocol() {
		return requestingProtocol;
	}

	/**
	 * @return v҂w肵vvg
	 */
	protected final String getRequestingPrompt() {
		return requestingPrompt;
	}

	/**
	 * @return v҂w肵ftHg̃[U
	 */
	protected final String getDefaultUserName() {
		return requestingUserName;
	}

	/**
	 * pX[hF؂KvȏꍇɌĂяo܂B
	 * TuNXł́AftHg̎I[o[ChKv܂B
	 * ftHg̎ł null Ԃ܂B<p>
	 * 
	 * ̃\bh_CAOgpă[Uɂ͂߂ꍇA
	 * 񂪓͂܂Ń_CAOubNKv܂B
	 * ̃\bh̓_CAO̕\Pɖ߂邱Ƃ͂ł܂B
	 * 
	 * @return [UW PasswordAuthenticationBȂꍇɂ null
	 */
	protected PasswordAuthentication getPasswordAuthentication() {
		return null;
	}

}
