/*
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.util.Vector;

import javax.mail.event.MailEvent;

/**
 * Package private class used by Store & Folder to dispatch events.
 * This class implements an event queue, and a dispatcher thread that
 * dequeues and dispatches events from the queue.
 * 
 * Pieces stolen from sun.misc.Queue.
 */
final class EventQueue implements Runnable {

	final class QueueElement {

		QueueElement next = null;
		QueueElement prev = null;
		MailEvent event = null;
		Vector vector = null;

		/**
		 * RXgN^łB
		 */
		QueueElement(final MailEvent event, final Vector vector) {
			this.event = event;
		    this.vector = vector;
		}

	}

	private QueueElement head = null;
	private QueueElement tail = null;
	private Thread qThread;

	/**
	 * ftHgRXgN^łB
	 */
	public EventQueue() {
		qThread = new Thread(this, "JavaMail-EventQueue");
		qThread.setDaemon(true);  // not a user thread
		qThread.start();
	}

	/**
	 * Enqueue an event.
	 */
	public synchronized void enqueue(final MailEvent event, final Vector vector) {
		QueueElement newElt = new QueueElement(event, vector);

		if (head == null) {
			head = newElt;
			tail = newElt;
		} else {
			newElt.next = head;
			head.prev = newElt;
			head = newElt;
		}
		notify();
	}

	/**
	 * Dequeue the oldest object on the queue.
	 * Used only by the run() method.
	 * 
	 * @return the oldest object on the queue.
	 * @throws InterruptedException if another thread has interrupted this thread.
	 */
	private synchronized QueueElement dequeue() throws InterruptedException {
		while (tail == null)
			wait();
		QueueElement elt = tail;
		tail = elt.prev;
		if (tail == null)
			head = null;
		else
			tail.next = null;
		elt.prev = elt.next = null;
		return elt;
	}

	/**
	 * Pull events off the queue and dispatch them.
	 */
	public void run() {
		QueueElement qe;

		try {
		    while ((qe = dequeue()) != null) {
				MailEvent e = qe.event;
				Vector v = qe.vector;

				for (int i = 0; i < v.size(); i++)
					e.dispatch(v.elementAt(i));

				qe = null;
				e = null;
				v = null;
		    }
		} catch (InterruptedException e) {
		    // just die
		}
	}

	/**
	 * Stop the dispatcher so we can be destroyed.
	 */
	void stop() {
		if (qThread != null) {
			qThread.interrupt();	// kill our thread
			qThread = null;
		}
	}

}
