/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.util.Vector;

/**
 * NCAg FetchProfile gpāA͈͂̃bZ[W
 * ւăT[o肵 Message ̈ꗗ\܂B<p>
 * 
 * Folder 擾郁bZ[ẂAʏۂ̃bZ[W
 * ̋̎QƂƂĊJnyʃIuWFNgłB
 *  Message IuWFNǵAK؂ȃQb^[\bh
 *  Message ŌĂяo "If}h" œ͂܂B
 * T[ox[X̃bZ[WANZXvgR (IMAP Ȃ) ̒ɂ́A
 * ͈͂̃bZ[WɊւ郁bZ[ẄꊇtFb`P̗vŉ\ɂ镨܂B
 * ͈͂ Messages ɂăbZ[Wgp (: wb_Xg
 * gbvx̃wb_\) NCAǵA
 * T[oɂ񋟂œKgpƂ悢ł傤B
 * <code>FetchProfile</code> ɂANCAg̗͂vT[oɎł܂B<p>
 * 
 * obNGh̃T[rXɂĂ͂vt@CeՂɁA
 * IɎ擾łȂꍇׁAŕK FetchProfile T|[gKv͂܂B<p>
 * 
 * FetchProfile gpTvR[hȉɎ܂B<p>
 * <blockquote>
 * <pre>
 * 
 *  Message[] msgs = folder.getMessages();
 * 
 *  FetchProfile fp = new FetchProfile();
 *  fp.add(FetchProfile.Item.ENVELOPE);
 *  fp.add("X-mailer");
 *  folder.fetch(msgs, fp);
 * 
 * </pre></blockquote><p>
 * 
 * @see javax.mail.Folder#fetch
 */
public final class FetchProfile {

	private Vector specials; // specials
	private Vector headers; // vector of header names

	/**
	 * ̓NX FetchProfile ŗv\ȑSڂ̊NXłB
	 * ݂Œ`Ă鍀ڂ <code>ENVELOPE</code>A<code>CONTENT_INFO</code>A
	 * y <code>FLAGS</code> łB
	 * <code>UIDFolder</code> C^tF[X <code>UID</code> ڂ`܂B<p>
	 * 
	 * ̃NX͕ی삳ꂽRXgN^݂̂ׁA
	 * VKڂ̌^͂̃NX܂̓TuNX̂ǂ炩ɐ܂B
	 * ɂA鍀ڂ̌^̗񋓂͌ʓIɎ܂B
	 * 
	 * @see UIDFolder
	 */
	public static class Item {

		/**
		 *  Envelope ڂłB<p>
		 * 
		 * Envelope  Message ̈ʑ̏WłB
		 * ́AFromAToACcABccAReplyToASubjectA
		 * y Date ̊e܂܂Ȃ΂܂B
		 * Xɑ̍ڂ܂߂邱Ƃł܂B<p>
		 * 
		 * IMAP4 vgR̎ (RFC 2060) ̏ꍇA
		 * Envelope  ENVELOPE f[^ڂ܂܂Ȃ΂܂B
		 * Xɑ̍ڂ܂߂邱Ƃł܂B
		 */
		public static final Item ENVELOPE = new Item("ENVELOPE");

		/**
		 * ̍ڂ̓bZ[WeɊւ̎擾Ɏgp܂B<p>
		 * 
		 * ̓bZ[WeLqS܂݂܂B
		 * ́AContentTypeAContentDispositionAContentDescriptionASizeA
		 * y LineCount ̊e܂܂Ȃ΂܂B
		 * ̑̍ڂ܂߂邱Ƃł܂B
		 */
		public static final Item CONTENT_INFO = new Item("CONTENT_INFO");

		/**
		 *  Flags ڂłB
		 */
		public static final Item FLAGS = new Item("FLAGS");

		private String name;
	
		/**
		 * ڂ\z܂B̖O̓fobÖׂɎgp܂B
		 */
		protected Item(final String name) {
			this.name = name;
		}

	}

	/**
	 *  FetchProfile 쐬܂B
	 */
	public FetchProfile() { 
		specials = null;
		headers = null;
	}

	/**
	 * 肳鑮 1 ƂĎw肳ꂽʂȍڂǉ܂B
	 * 
	 * @param item oʂȍ
	 * @see FetchProfile.Item#ENVELOPE
	 * @see FetchProfile.Item#CONTENT_INFO
	 * @see FetchProfile.Item#FLAGS
	 */
	public void add(final Item item) { 
		if (specials == null)
			specials = new Vector();
		specials.addElement(item);
	}

	/**
	 * w肳ꂽwb_tB[hA肳鑮̃Xgɒǉ܂B
	 * 
	 * @param headerName 肳wb_
	 */
	public void add(final String headerName) { 
		if (headers == null)
			headers = new Vector();
		headers.addElement(headerName);
	}

	/**
	 * tFb`vt@Cw肳ꂽʂȍڂ܂ޏꍇ true Ԃ܂B
	 */
	public boolean contains(final Item item) { 
		return specials != null && specials.contains(item);
	}

	/**
	 * tFb`vt@Cw肳ꂽwb_܂ޏꍇ true Ԃ܂B
	 */
	public boolean contains(final String headerName) { 
		return headers != null && headers.contains(headerName);
	}

	/**
	 * ̃vt@Cɐݒ肳ꂽڂ擾܂B
	 * 
	 * @return ̃vt@Cɐݒ肳ꂽ
	 */
	public Item[] getItems() { 
		if (specials == null)
			return new Item[0];

		Item[] s = new Item[specials.size()];
		specials.copyInto(s);
		return s;
	}

	/**
	 * ̃vt@Cɐݒ肳ꂽwb_tB[h̖O擾܂B
	 * 
	 * @return ̃vt@Cɐݒ肳ꂽwb_
	 */
	public String[] getHeaderNames() { 
		if (headers == null)
			return new String[0];

		String[] s = new String[headers.size()];
		headers.copyInto(s);
		return s;
	}

}
