/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * Flags NX Message ̃tȎg\܂B
 * Flags ͎O`ꂽVXetOƃ[U`tO\܂B<p>
 * 
 * VXetO <code>Flags.Flag</code> NXɂ\܂B
 * [U`tO String Ƃĕ\܂B
 * [UtO͑啶Əʂ܂B<p>
 * 
 * A̕WVXetO͎O`Ă܂B
 * wǂ̃tH_͂̃tOT|[g邱ƂɂȂĂ܂B
 * ꕔ͔̎Cӂ̃[U`tOT|[g\łB
 * Folder  <code>getPermanentFlags</code> \bh́A
 * ̃tH_T|[gSẴtOێ Flags IuWFNgԂ܂B<p>
 * 
 * Ⴆ΁Aꒆ Flags IuWFNg̎gpƋɒ񉻉\ƂȂlɁA
 * Flags IuWFNg͒񉻉\łB<p>
 * 
 * <strong>x:</strong>
 * ̃NX̒񉻃IuWFNg͏ JavaMail API [Xƌ݊ȂȂ\܂B
 * ݂̒񉻃T|[g͒ZIɗLłB<p>
 * 
 * ȉ̃TvR[h́AbZ[Wɑ΂tO̐ݒAA
 * yю擾@Ă܂B<p>
 * <pre>
 * 
 * Message m = folder.getMessage(1);
 * m.setFlag(Flags.Flag.DELETED, true); // DELETED tOݒ肵܂
 * 
 * // DELETED tÕbZ[Wɐݒ肳Ă邩؂܂
 * if (m.isSet(Flags.Flag.DELETED))
 *	System.out.println("DELETED message");
 * 
 * // ̃bZ[W̑SẴVXetO𒲂ׂ܂
 * Flags flags = m.getFlags();
 * Flags.Flag[] sf = flags.getSystemFlags();
 * for (int i = 0; i < sf.length; i++) {
 *	if (sf[i] == Flags.Flag.DELETED)
 *            System.out.println("DELETED message");
 *	else if (sf[i] == Flags.Flag.SEEN)
 *            System.out.println("SEEN message");
 *      ......
 *      ......
 * }
 * </pre>
 * <p>
 * 
 * @see Folder#getPermanentFlags
 */
public class Flags implements Cloneable, Serializable {

	private static final long serialVersionUID = 6243590407214169028L;

	private int system_flags = 0;
	private Hashtable user_flags = null;

	private final static int ANSWERED_BIT	= 0x01;
	private final static int DELETED_BIT 	= 0x02;
	private final static int DRAFT_BIT 		= 0x04;
	private final static int FLAGGED_BIT 	= 0x08;
	private final static int RECENT_BIT		= 0x10;
	private final static int SEEN_BIT		= 0x20;
	private final static int USER_BIT		= 0x80000000;

	/**
	 * ̓NX͌ʂ̃VXetO\܂B
	 * A̕WVXetOIuWFNg͂ŎOɒ`܂B
	 */
	public static final class Flag {

		/**
		 * ̃bZ[W͉񓚍ς݂łB̃tO̓NCAgɂݒ肳A
		 * ̃bZ[Wɑ΂ĉ񓚍ς݂ł鎖܂B
		 */
		public static final Flag ANSWERED = new Flag(ANSWERED_BIT);

		/**
		 * ̃bZ[Wɂ͍폜}[NtĂ܂B
		 * NCAg͂̃tOݒ肵āAbZ[Wɍ폜}[Nt܂B
		 * tH_̖ɂÃtH_ō폜}[NtĂSẴbZ[W폜܂B
		 */
		public static final Flag DELETED = new Flag(DELETED_BIT);

		/**
		 * ̃bZ[W̓htgłB̃tO̓NCAgɂݒ肳A
		 * bZ[WhtgbZ[Wł鎖܂B
		 */
		public static final Flag DRAFT = new Flag(DRAFT_BIT);

		/**
		 * ̃bZ[WɃtOĂ܂B
		 * ̃tÖӖ͒`Ă܂BNCAg͂̃tOύX܂B
		 */
		public static final Flag FLAGGED = new Flag(FLAGGED_BIT);

		/**
		 * ̃bZ[W͍ŋ߂̕łBtH_͂̃tOݒ肵A
		 * ̃bZ[W̃tH_ɐVKłA܂A
		 * ̃tH_ŌɊJꂽɓ܂B<p>
		 * 
		 * NCAg͂̃tOύXł܂B
		 */
		public static final Flag RECENT = new Flag(RECENT_BIT);

		/**
		 * ̃bZ[W͊ǂłB
		 * ̃tÓA Message ̓e炩̌`ŃNCAgɖ߂ہAɂÖقɐݒ肳܂B
		 * Message  <code>getInputStream</code> y <code>getContent</code> \bhɂ肱̃tOݒ肳܂B<p>
		 * 
		 * NCAg͂̃tOύXł܂B
		 */
		public static final Flag SEEN = new Flag(SEEN_BIT);

		/**
		 * ̃tH_[U`tOT|[g鎖ȃtOłB<p>
		 * 
		 * ͂̃tOݒ肵܂BNCAg͂̃tOύXł܂񂪁A
		 * <code>folder.getPermanentFlags().contains(Flags.Flag.USER)</code> gpāA
		 * tH_[U`tOT|[g邩ǂ𔻒ł܂B
		 */
		public static final Flag USER = new Flag(USER_BIT);

		// flags are stored as bits for efficiency
		private int bit;

		/**
		 * RXgN^łB
		 */
		private Flag(final int bit) {
		    this.bit = bit;
		}

	}

	/**
	 *  Flags IuWFNg\z܂B
	 */
	public Flags() {}

	/**
	 * w肳ꂽtOŏꂽ Flags IuWFNg\z܂B
	 * 
	 * @param flags ̂߂̃tO
	 */
	public Flags(final Flags flags) {
		this.system_flags = flags.system_flags;
		if (flags.user_flags != null)
			this.user_flags = (Hashtable) flags.user_flags.clone();
	}

	/**
	 * w肳ꂽVXetOŏꂽ Flags IuWFNg\z܂B
	 * 
	 * @param flag ̂߂̃tO
	 */
	public Flags(final Flag flag) {
		this.system_flags |= flag.bit;
	}

	/**
	 * w肳ꂽ[UtOŏꂽ Flags IuWFNg\z܂B
	 * 
	 * @param flag ̂߂̃tO
	 */
	public Flags(final String flag) {
		user_flags = new Hashtable(1);
		user_flags.put(flag.toLowerCase(), flag);
	}

	/**
	 * w肳ꂽVXetO Flags IuWFNgɒǉ܂B
	 * 
	 * @param flag ǉtO
	 */
	public final void add(final Flag flag) {
		system_flags |= flag.bit;
	}

	/**
	 * w肳ꂽ[UtO Flags IuWFNgɒǉ܂B
	 * 
	 * @param flag ǉtO
	 */
	public final void add(final String flag) {
		if (user_flags == null)
			user_flags = new Hashtable(1);
		user_flags.put(flag.toLowerCase(), flag);
	}

	/**
	 * w肳ꂽ Flags IuWFNg̑SẴtO Flags IuWFNgɒǉ܂B
	 * 
	 * @param f Flags IuWFNg
	 */
	public final void add(final Flags f) {
		system_flags |= f.system_flags; // VXetOǉ܂

		if (f.user_flags != null) { // [U`tOǉ܂
			if (user_flags == null)
				user_flags = new Hashtable(1);

			Enumeration e = f.user_flags.keys();

			while (e.hasMoreElements()) {
				String s = (String) e.nextElement();
				user_flags.put(s, f.user_flags.get(s));
			}
		}
	}

	/**
	 * w肳ꂽVXetO Flags IuWFNg폜܂B
	 * 
	 * @param flag 폜tO
	 */
	public final void remove(final Flag flag) {
		system_flags &= ~flag.bit;
	}

	/**
	 * w肳ꂽ[UtO Flags IuWFNg폜܂B
	 * 
	 * @param flag 폜tO
	 */
	public final void remove(final String flag) {
		if (user_flags != null)
			user_flags.remove(flag.toLowerCase());
	}

	/**
	 * w肳ꂽ Flags IuWFNg̑SẴtO Flags IuWFNg폜܂B
	 * 
	 * @param f 폜tO
	 */
	public final void remove(final Flags f) {
		system_flags &= ~f.system_flags; // VXetO폜܂

		if (f.user_flags != null) {
			if (user_flags == null)
				return;

			Enumeration e = f.user_flags.keys();
			while (e.hasMoreElements())
				user_flags.remove(e.nextElement());
		}
	}

	/**
	 * w肳ꂽVXetO Flags IuWFNgɑ݂邩ǂ𒲂ׂ܂B
	 * 
	 * @return w肳ꂽtO݂ꍇ trueAłȂꍇ false
	 */
	public final boolean contains(final Flag flag) {
		return (system_flags & flag.bit) != 0;
	}

	/**
	 * w肳ꂽ[UtO Flags IuWFNgɑ݂邩ǂ𒲂ׂ܂B
	 * 
	 * @return w肳ꂽtO݂ꍇ trueAłȂꍇ false
	 */
	public final boolean contains(final String flag) {
		if (user_flags == null)
			return false;
		return user_flags.containsKey(flag.toLowerCase());
	}

	/**
	 * w肳ꂽ Flags IuWFNg̑SẴtO Flags IuWFNgɑ݂邩ǂ𒲂ׂ܂B
	 * 
	 * @return w肳ꂽ Flags IuWFNg̑SẴtO݂ꍇ trueAłȂꍇ false 
	 */
	public final boolean contains(final Flags f) {
		// VXetO`FbN܂
		if ((f.system_flags & system_flags) != f.system_flags)
			return false;

		// [UtO`FbN܂
		if (f.user_flags != null) {
			if (user_flags == null)
				return false;
			Enumeration e = f.user_flags.keys();

			while (e.hasMoreElements()) {
				if (!user_flags.containsKey(e.nextElement()))
					return false;
			}
		}

		// If we've made it till here, return true
		return true;
	}

	/**
	 * 2  Flags IuWFNgǂ𒲂ׂ܂B
	 * 
	 * @return ꍇ true
	 */
	public final boolean equals(final Object obj) {
		if (!(obj instanceof Flags))
			return false;

		Flags f = (Flags) obj;

		// VXetO`FbN܂
		if (f.system_flags != this.system_flags)
			return false;

		// [UtO`FbN܂
		if (f.user_flags == null && this.user_flags == null)
			return true;
		if (f.user_flags != null && this.user_flags != null && f.user_flags.size() == this.user_flags.size()) {
			Enumeration e = f.user_flags.keys();

			while (e.hasMoreElements()) {
				if (!this.user_flags.containsKey(e.nextElement()))
					return false;
		    }
		    return true;
		}

		return false;
	}

	/**
	 *  Flags IuWFNg̃nbVR[hvZ܂B
	 * 
	 * @return nbVR[h
	 */
	public final int hashCode() {
		int hash = system_flags;
		if (user_flags != null) {
			Enumeration e = user_flags.keys();
			while (e.hasMoreElements())
				hash += ((String)e.nextElement()).hashCode();
		}
		return hash;
	}

	/**
	 *  Flags IuWFNg̑SẴVXetOԂ܂B
	 * tOSݒ肳ĂȂꍇ́ATCY 0 ̔zԂ܂B
	 * 
	 * @return VXetO\ Flags.Flag IuWFNg̔z
	 */
	public final Flag[] getSystemFlags() {
		Vector v = new Vector();
		if ((system_flags & ANSWERED_BIT) != 0)
			v.addElement(Flag.ANSWERED);
		if ((system_flags & DELETED_BIT) != 0)
			v.addElement(Flag.DELETED);
		if ((system_flags & DRAFT_BIT) != 0)
			v.addElement(Flag.DRAFT);
		if ((system_flags & FLAGGED_BIT) != 0)
			v.addElement(Flag.FLAGGED);
		if ((system_flags & RECENT_BIT) != 0)
			v.addElement(Flag.RECENT);
		if ((system_flags & SEEN_BIT) != 0)
			v.addElement(Flag.SEEN);
		if ((system_flags & USER_BIT) != 0)
			v.addElement(Flag.USER);

		Flag[] f = new Flag[v.size()];
		v.copyInto(f);
		return f;
	}

	/**
	 *  Flags IuWFNg̑SẴ[UtOԂ܂B
	 * tOSݒ肳ĂȂꍇ́ATCY 0 ̔zԂ܂B
	 * 
	 * @return String ̔zBe String  1 ̃tO\܂B
	 */
	public final String[] getUserFlags() {
		Vector v = new Vector();
		if (user_flags != null) {
			Enumeration e = user_flags.elements();
			while (e.hasMoreElements())
				v.addElement(e.nextElement());
		}

		String[] f = new String[v.size()];
		v.copyInto(f);
		return f;
	}

	/**
	 * Flags IuWFNg̕Ԃ܂B
	 */
	public final Object clone() {
		return new Flags(this);
	}

}
