/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.util.Vector;

import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.MailEvent;
import javax.mail.event.MessageChangedEvent;
import javax.mail.event.MessageChangedListener;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.search.SearchTerm;

/**
 * Folder ́A[bZ[W̃tH_\ۃNXłB
 * TuNX̓vgRʂ Folder ܂B<p>
 * 
 * Folder  MessageA Folder ̗͂܂ގłׁA
 * Store ̃ftHgtH_[gƂc[̊Kw񋟂܂ (ꕔ Folder ɂ́A
 *  Folder  Message Ƒ Folder Ȃ܂)B<p>
 * 
 * tH_̉߂͎ɂقȂ܂B
 * tH_̊S̊eKwx́AꂼKw؂蕶ŕ܂B<p>
 * 
 * 啶ƏʂȂStH_ (܂A
 * Store ̃ftHgtH_ɑ΂銮S) <strong>INBOX</strong> ́A
 * "̃T[ỗ[Üׂ̎tH_" Ӗׂɗ\񂳂Ă܂B
 * SĂ Store  INBOX tH_񋟂킯ł͂ȂA
 * SẴ[U INBOX tH_킯ł܂B
 * ̋@\񋟂 Store ɂ̃tH_݂ꍇɁA
 * w߂ <strong>INBOX</strong> ƂO\񂳂Ă܂B<p>
 * 
 * Store 擾 Folder IuWFNǵAobNGhXgAɎ݂Kv͂܂B
 * <code>exists()</code> \bh̓tH_݂邩ǂ܂B
 * <code>create()</code> \bh Folder 쐬܂B<p>
 * 
 * Folder ͍ŏԂɂ܂Bꕔ̃\bh́ȀԂ̎ɗLłB
 * \bh̐ɂ͂̎LqĂ܂B
 * Folder ͂ 'open' \bhĂяoɂJ܂B
 * ̏Ԃł́A<code>open()</code>A<code>delete()</code>A
 * y <code>renameTo()</code> SĂ Folder \bhLłB<p>
 * 
 * Folder 擾@́AStore  Folder  <code>getFolder()</code> \bhĂяoA
 * Folder  <code>list()</code>  <code>listSubscribed()</code> \bhĂяo܂B
 * ̃\bhɂԂ Folder IuWFNǵAStore ɂLbV܂B
 * ׁ̈A<code>getFolder(folder_name)</code> 𓯂 folder_name ŕĂяoƁA
 * قȂ Folder IuWFNgԂ܂B
 * <code>list()</code> y <code>listSubscribed()</code> ɂĂlłB<p>
 * 
 * Folder  Message IuWFNǵAFolder ɂLbV܂B
 * ׁ̈AbZ[Wԍ <code>getMessage(msgno)</code> 𕡐ĂяoƁA
 *  Message IuWFNgԂ܂B͂ Folder ŏs܂ŕς܂B<p>
 * 
 * Message ̃bZ[Wԍ́A܂ Folder \bhɂƁA
 * ZbVŕύXɂȂꍇ܂B
 * bZ[Wւ̎QƂƂăbZ[WԍgpNCAg͂̓_ɒӂȂ΂Ȃ炸A
 * 󋵂ɑΏ鏀KvɂȂ܂ (炭̃bZ[WԍQƂAēxǂݍގɂ)B
 * GANCAg̓bZ[WԍłȂA
 * Message IuWFNggpăbZ[WQƂقK؂łB
 *  Message IuWFNg͈ˑRƂďKv܂A
 * ̃tH_̑ Message IuWFNg͏ɂe󂯂܂B
 */
public abstract class Folder {

	/**
	 * eXgAłB
	 */
	protected Store store;

	/**
	 * ̃tH_̃I[v[hłBI[v[h́A
	 * <code>Folder.READ_ONLY</code>  <code>Folder.READ_WRITE</code> ŁA
	 * sȏꍇ -1 łB
	 * 
	 * @since JavaMail 1.1
	 */
	protected int mode = -1;

	/**
	 * Store IuWFNggpRXgN^łB
	 * 
	 * @param store ̃tH_ێ Store
	 */
	protected Folder(final Store store) {
		this.store = store;
	}

	/**
	 *  Folder ̖OԂ܂B<p>
	 * 
	 * ̃\bh͕ Folder ŌĂяoƂł܂B
	 * 
	 * @return Folder ̖O
	 */
	public abstract String getName();

	/**
	 *  Folder ̊SȖOԂ܂B
	 * tH_ Store ̃[gKw̉ɂꍇA
	 * Ԃ閼O̓[gւ̑ΖɂȂ܂B
	 * łȂꍇ́AKw؂蕶Ŏn܂ΖԂ܂B<p>
	 * 
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * 
	 * @return Folder ̊SȖO
	 */
	public abstract String getFullName();

	/**
	 * ̃tH_\ URLName Ԃ܂B
	 * Ԃ URLName ́AXgAɃANZXׂɎgppX[h܂<em>܂</em>B
	 * 
	 * @return ̃tH_\ URLName
	 * @since JavaMail 1.1
	 * @see URLName
	 */
	public final URLName getURLName() throws MessagingException {
		URLName storeURL = getStore().getURLName();
		String fullname = getFullName();
		StringBuffer encodedName = new StringBuffer();
// Sugisawa changed. 2004/12/28
//		char separator = getSeparator();
		getSeparator();

		if (fullname != null) {
/*
		    // We need to encode each of the folder's names.
		    StringTokenizer tok = new StringTokenizer(
			fullname, new Character(separator).toString(), true);

			while (tok.hasMoreTokens()) {
				String s = tok.nextToken();
				if (s.charAt(0) == separator)
					encodedName.append(separator);
				else
					// XXX - should encode, but since there's no decoder...
					//encodedName.append(java.net.URLEncoder.encode(s));
					encodedName.append(s);
			}
*/
			// append the whole thing, until we can encode
			encodedName.append(fullname);
		}

		/*
		 * Sure would be convenient if URLName had a constructor that took a base URLName.
		 */
		return new URLName(storeURL.getProtocol(), storeURL.getHost(),
			storeURL.getPort(), encodedName.toString(),
			storeURL.getUsername(),
			null /* pX[hȂ */);
	}

	/**
	 *  Folder IuWFNgL Store Ԃ܂B
	 * ̃\bh͕ Folder ŌĂяoƂł܂B
	 * 
	 * @return Store
	 */
	public final Store getStore() {
		return store;
	}

	/**
	 * ̃tH_̐etH_Ԃ܂B
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * ̃tH_tH_Kw̍ŏʂɂꍇÃ\bh null Ԃ܂B<p>
	 * 
	 * Folder IuWFNg̓LbVȂ̂ŁÃ\bhĂяoƁA
	 * VK̈قȂ Folder IuWFNgԂ܂B
	 * 
	 * @return etH_
	 */
	public abstract Folder getParent() throws MessagingException;

	/**
	 * ̃tH_I Store ɑ݂邩ǂ܂B
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * 
	 * @return tH_݂ꍇ trueAłȂꍇ false
	 * @throws MessagingException ʂɃT[oւ̐ڑꂽꍇ 
	 * @see #create
	 */
	public abstract boolean exists() throws MessagingException;

	/**
	 * w肳ꂽp^[Ɉv邱 Folder ̖OԂɑ Folder ̈ꗗԂ܂B
	 * p^[́AKw؂蕶ȊO̔Cӂ̕Ɉv郏ChJ[h <code>"%"</code>A
	 * yёSĂ̕Ɉv <code>"*"</code> ܂ގł܂B<p>
	 * 
	 * tH_Kw̗ȉɎ܂B<pre>
	 *    Personal/
	 *       Finance/
	 *          Stocks
	 *          Bonus
	 *          StockOptions
	 *       Jokes
	 * </pre>
	 * "Personal"  <code>list("*")</code> ͊KwŜԂ܂B<br>
	 * "Personal"  <code>list("%")</code>  "Finance"  "Jokes" Ԃ܂B<br>
	 * "Personal"  <code>list("Jokes")</code>  "Jokes" Ԃ܂B<br>
	 * "Finance"  <code>list("Stock*")</code>  "Stocks"  "StockOptions" Ԃ܂B<p>
	 * 
	 * Folder IuWFNg Store ɂLbVȂ̂ŁA
	 * p^[ł̃\bh𕡐ĂяoƁA
	 * ̈قȂ Folder IuWFNgԂ܂B<p>
	 * 
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * 
	 * @param pattern vp^[
	 * @return v Folder IuWFNg̔zBv Folder ݂Ȃꍇ́A̔zԂ܂B
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws MessagingException
	 * @see #listSubscribed
	 */
	public abstract Folder[] list(String pattern) throws MessagingException;

	/**
	 * w肳ꂽp^[Ɉv邱 Folder ̖OԂ
	 * TuXNCuꂽ Folder ̈ꗗԂ܂B
	 * tH_TuXNvVT|[gȂꍇA
	 * ̃\bh <code>list</code> ĂяǒʂԂKv܂B
	 * (Œ񋟂ftHg̎͂s)
	 * p^[ <code>list</code> Ɋւ郏ChJ[h܂ގł܂B<p>
	 * 
	 * Note that, at a given level of the folder hierarchy, a particular
	 * folder may not be subscribed, but folders underneath that folder
	 * in the folder hierarchy may be subscribed.  In order to allow
	 * walking the folder hierarchy, such unsubscribed folders may be
	 * returned, indicating that a folder lower in the hierarchy is
	 * subscribed.  The <code>isSubscribed</code> method on a folder will
	 * tell whether any particular folder is actually subscribed. <p>
	 * 
	 * Folder IuWFNg Store ɂLbVȂ̂ŁA
	 * p^[ł̃\bh𕡐ĂяoƁA
	 * ̈قȂ Folder IuWFNgԂ܂B<p>
	 * 
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * 
	 * @param pattern vp^[
	 * @return vTuXNCuꂽ Folder IuWFNg̔zB
	 * vTuXNCuꂽtH_݂Ȃꍇ́A̔zԂ܂B
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ
	 * @throws MessagingException
	 * @see #list
	 */
	public Folder[] listSubscribed(final String pattern) throws MessagingException {
		return list(pattern);
	}

	/**
	 *  Folder ̉ɂtH_̈ꗗԂȈՃ\bhB
	 * ̃\bh́Avp^[ <code>"%"</code> gpāA
	 * <code>list(String pattern)</code> \bhĂяołB
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * 
	 * @return  Folder ̉ɂ Folder IuWFNg̔zB
	 * TutH_݂Ȃꍇ́A̔zԂ܂B
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ
	 * @throws MessagingException
	 * @see #list
	 */
	public final Folder[] list() throws MessagingException {
		return list("%");
	}

	/**
	 *  Folder ̉ɂTuXNCuꂽtH_̈ꗗԂȈՃ\bhB
	 * ̃\bh́Avp^[ <code>"%"</code> gpāA
	 * <code>listSubscribed(String pattern)</code> \bhĂяołB
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * 
	 * @return  Folder ̉ɂTuXNCuꂽ Folder IuWFNg̔zB
	 * TuXNCuꂽTutH_݂Ȃꍇ́A̔zԂ܂B 
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ
	 * @throws MessagingException
	 * @see #listSubscribed
	 */
	public final Folder[] listSubscribed() throws MessagingException {
		return listSubscribed("%");
	}

	/**
	 *  Folder ̃pX̃TutH_番؂蕶Ԃ܂B
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * 
	 * @return Kw؂蕶
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 */
	public abstract char getSeparator() throws MessagingException;

	/**
	 * ̃tH_̓bZ[W܂ގł܂B
	 */
	public static final int HOLDS_MESSAGES = 0x01;

	/**
	 * ̃tH_͑̃tH_܂ގł܂B
	 */
	public static final int HOLDS_FOLDERS  = 0x02;

	/**
	 *  Folder ̌^A܂ÃtH_bZ[WTutH_A
	 * ̗͂ێ\ǂԂ܂B
	 * ԂĺAK؂ȃrbgݒ肳ꂽrbgtB[hłB
	 * ̃\bh͕tH_ŌĂяoł܂B
	 * 
	 * @return K؂ȃrbgݒ肳ꂽ
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @see #HOLDS_FOLDERS 
	 * @see #HOLDS_MESSAGES
	 */
	public abstract int getType() throws MessagingException; 

	/**
	 * ̃tH_ Store ɍ쐬܂B
	 * ̃tH_쐬ƁApXɊ܂܂鑶݂ȂSẴtH_쐬܂B<p>
	 * 
	 * 쐬ƁA Folder Ƃ Store ɓo^Ă
	 * Cӂ FolderListener  CREATED FolderEvent zM܂B
	 * 
	 * @param type ̃tH_̌^ 
	 * @return 쐬ꍇ trueAłȂꍇ false
	 * @throws MessagingException  
	 * @see #HOLDS_FOLDERS
	 * @see #HOLDS_MESSAGES
	 * @see javax.mail.event.FolderEvent
	 */
	public abstract boolean create(int type) throws MessagingException;

	/**
	 *  Folder TuXNCuꍇ true Ԃ܂B<p>
	 * 
	 * ̃\bh͕ Folder ŌĂяoł܂B<p>
	 * 
	 * Œ񋟂ftHg̎ true ԂłB
	 * 
	 * @return  Folder TuXNCuꍇ true
	 */
	public boolean isSubscribed() {
		return true;
	}

	/**
	 *  Folder TuXNCu̓TuXNCu܂B
	 * SĂ Store TuXNvVT|[g킯ł͂܂B<p>
	 * 
	 * ̃\bh͕ Folder ŌĂяoł܂B<p>
	 * 
	 * Œ񋟂 MethodNotSupportedException X[邾łB
	 * 
	 * @param subscribe	true to subscribe, false to unsubscribe
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ
	 * @throws MethodNotSupportedException ̃XgATuXNvVT|[gȂꍇ
	 * @throws MessagingException
	 */
	public void setSubscribed(final boolean subscribe) throws MessagingException {
		throw new MethodNotSupportedException();
	}

	/**
	 * ̕\ŌɃZbgĂA Folder ɐVKbZ[W݂ꍇ true Ԃ܂B
	 * ̕\ݒ܂̓Zbg邩́AFolder ̎ɂقȂ܂ (IMAP ̏ꍇ́AT[oɈˑ܂)B
	 * ̃\bhgpāAFolder J "VK[`FbN" yʂȑł܂B
	 * (Ⴆ΁A[{bNXyуtOĎĐVK[`FbNXbh)
	 * ̃\bh́AFolder ̔Cӂ̃bZ[W <code>RECENT</code> tO
	 * ݒ肳Ă邩ǂKv܂B<p>
	 * 
	 * ͐VK[̃CN^`FbNł͂܂B
	 * ܂Ã\bhŌɌĂяoꂽȍ~ɁA
	 * VKbZ[Wǂ𔻒肷ׂɎgp鎖͂ł܂B
	 * CN^`FbNɂ́AFolder JKv܂B<p>
	 * 
	 * ̃\bh́AMessage ܂ގł Folder ŌĂяoł܂B
	 * 
	 * @return Store VK Message ܂ޏꍇ true
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ
	 * @throws MessagingException
	 */
	public abstract boolean hasNewMessages() throws MessagingException;

	/**
	 * w肳ꂽOɑΉ Folder IuWFNgԂ܂B
	 * ̃tH_́AStore ɕIɑ݂Kv͂܂B
	 * Folder  <code>exists()</code> \bh́A
	 * tH_ Store Ɏ݂邩ǂ܂B<p>
	 * 
	 * ꕔ Store ŁAOKw؂蕶Ŏn܂ꍇA΃pXɂ鎖ł܂B
	 * ȊȌꍇAO͂ Folder ւ̑ΖƉ߂܂B<p>
	 * 
	 * Folder IuWFNg Store ɂLbVȂ̂ŁA
	 * Oł̃\bh𕡐ĂяoƁA
	 * ̈قȂ Folder IuWFNgԂ܂B<p>
	 * 
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * 
	 * @param name Folder ̖O
	 * @return Folder IuWFNg
	 * @throws MessagingException
	 */
	public abstract Folder getFolder(String name) throws MessagingException;

	/**
	 *  Folder 폜܂B
	 * ̃\bh͕ Folder ł̂ݐ܂B<p>
	 * 
	 * <code>recurse</code> tÓA폜TutH_ɉe邩ǂ𐧌䂵܂B
	 * true ̏ꍇASẴTutH_폜ꂽÃtH_g폜܂B
	 * false ̏ꍇA̓tH_̌^ɂقȂ܂B
	 * ȉɏڂqׂ܂B<p>
	 * 
	 * <ul>
	 * <li>
	 * tH_bZ[W܂ގłꍇ (type == HOLDS_MESSAGES)
	 * <br>
	 * tH_̑SẴbZ[W͍폜܂BɁAtH_g폜܂B
	 * Store Ƃ̃tH_ɂK؂ FolderEvent ܂B<p>
	 * 
	 * <li>
	 * tH_TutH_܂ގłꍇ (type == HOLDS_FOLDERS)
	 * <br>
	 * ̃tH_ (TutH_S܂܂Ȃ) ̏ꍇ͍폜܂B
	 * Store Ƃ̃tH_ɂK؂ FolderEvent ܂B<br>
	 * ̃tH_Cӂ̃TutH_܂ޏꍇ́A폜sAfalse Ԃ܂B<p>
	 * 
	 * <li>
	 * tH_TutH_ƃbZ[W܂ގłꍇ: <br>
	 * tH_ (bZ[W̓TutH_Ȃ) ̏ꍇ͍폜܂B
	 * tH_ɃTutH_ȂAbZ[W܂ޏꍇ́A
	 * SẴbZ[W폜܂B̌AtH_g폜܂B
	 * ̏ꍇAStore Ƃ̃tH_ɂK؂ FolderEvent ܂B<p>
	 * 
	 * tH_TutH_܂ޏꍇAɂ͈ȉ 3 ̑I܂: <p>
	 * 
	 *  <ol>
	 *   <li> ̃tH_bZ[W܂ނǂɂ炸A삪s܂B
	 * ꕔ̎͂̒PȕI܂Bdelete() \bh false Ԃ܂B
	 * 
	 *   <li> tH_̑SẴbZ[W͍폜܂BTutH_͍폜܂B
	 * tH_g͍폜ȂAǂ̂悤ȉe󂯂܂B
	 * delete() \bh true Ԃ܂B̃tH_ exists() \bh́A
	 * ̃tH_܂݂邱Ƃ true Ԃ܂B<br>
	 * Store Ƃ̃tH_ɂK؂ FolderEvent ܂B
	 * 
	 *   <li> tH_̑SẴbZ[W͍폜܂BTutH_͍폜܂B
	 * tH_g͂̌^ HOLDS_FOLDERS | HOLDS_MESSAGES  HOLDS_FOLDERS ɕύX܂B
	 * ׁ̈AVKbZ[W͂̃tH_ɒǉł܂񂪁AVKTutH_ɍ쐬邱Ƃ͉\łB
	 * delete() \bh͐ true Ԃ܂B
	 * ̃tH_ exists() \bh́ÃtH_܂݂邱Ƃ true Ԃ܂B<br>
	 * Store Ƃ̃tH_ɂK؂ FolderEvent ܂B
	 * </ol>
	 * </ul>
	 * 
	 * @return Folder ɍ폜ꂽꍇ true
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws IllegalStateException ̃tH_ԂɂȂꍇ 
	 * @throws MessagingException
	 * @see javax.mail.event.FolderEvent
	 */
	public abstract boolean delete(boolean recurse) throws MessagingException;

	/**
	 *  Folder ̖OύX܂B
	 * ̃\bh͕ Folder ł̂ݐ܂B<p>
	 * 
	 * O̕ύXƁÃtH_Ƃ̃tH_܂ Store ɓo^
	 * Ă FolderListener  RENAMED FolderEvent zM܂B
	 * 
	 * @param f  Folder ̐VO\tH_
	 * @return Folder ̖OɕύXꂽꍇ true
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws IllegalStateException ̃tH_ԂɂȂꍇ 
	 * @throws MessagingException
	 * @see javax.mail.event.FolderEvent
	 */
	public abstract boolean renameTo(Folder f) throws MessagingException;

	/**
	 * Folder ͓ǂݎpłB
	 * ̃tH_̏ԂƓeύX鎖͂ł܂B
	 */
	public static final int READ_ONLY 	= 1;

	/**
	 * ̃tH_̏ԂƓe͕ύX鎖ł܂B
	 */
	public static final int READ_WRITE 	= 2;

	/**
	 *  Folder J܂B̃\bh́A
	 * Message ܂ގ\łĂ Folder ł̂ݗLłB<p>
	 * 
	 * ̃tH_ɊJƁA Folder ɓo^Ă
	 * SĂ ConnectionListener  OPENED ConnectionEvent zM܂B<p>
	 * 
	 *  Store ̓tH_ւ̐ڑ𕡐Jꍇ̌ʂ́AɂقȂ܂B
	 * ꕔ͕̎̓ǂݎ܂A͂ 1 l܂B
	 * ʂ͕̎̓ǂݎƏ܂B
	 * 
	 * @param mode Folder READ_ONLY ܂ READ_WRITE J
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws IllegalStateException ̃tH_ԂɂȂꍇ 
	 * @throws MessagingException
	 * @see #READ_ONLY
	 * @see #READ_WRITE
	 * @see #getType()
	 * @see javax.mail.event.ConnectionEvent
	 */
	public abstract void open(int mode) throws MessagingException;

	/**
	 *  Folder ܂B̃\bh͊J Folder ł̂ݗLłB<p>
	 * 
	 *  Folder ɓo^ĂSĂ ConnectionListener  CLOSED ConnectionEvent zM܂B
	 * MessagingException ̃X[ɂÃ\bhُIꍇłtH_͕܂B
	 * 
	 * @param expunge ̃tO true ̏ꍇASĂ̍폜bZ[W܂B
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws MessagingException
	 * @see javax.mail.event.ConnectionEvent
	 */
	public abstract void close(boolean expunge) throws MessagingException;

	/**
	 *  Folder  'open' Ԃɂ邩ǂ܂B
	 * 
	 * @return  Folder  'open' Ԃɂꍇ true
	 */
	public abstract boolean isOpen();

	/**
	 * ̃tH_̃I[v[hԂ܂B
	 * <code>Folder.READ_ONLY</code>A<code>Folder.READ_WRITE</code>A
	 * ̓I[v[hsȏꍇ -1 Ԃ܂ (ʏA
	 * Â <code>Folder</code> voC_̐V\bhgpłlɍXVĂȂ̗Rɂ)B
	 * 
	 * @return ̃tH_̃I[v[h
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @since JavaMail 1.1
	 */
	public final int getMode() {
		if (!isOpen())
			throw new IllegalStateException("Folder not open");
		return mode;
	}

	/**
	 *  Folder T|[gitO擾܂B
	 * T|[gSẴtO܂ Flags IuWFNgԂ܂B<p>
	 * 
	 * tO <code>Flags.USER</code> ́A
	 *  Folder Cӂ̃[U`tOT|[g鎖܂B<p>
	 * 
	 * tH_̃T|[gitÓAtH_J܂Ŏgpł܂B
	 * 
	 * @return itOA܂͕s̏ꍇ null
	 */
	public abstract Flags getPermanentFlags();

	/**
	 *  Folder ̃bZ[W̐擾܂B<p>
	 * 
	 * ̃\bh͕tH_ŌĂяoł܂B
	 * AAꕔ̃tH_ł́AbZ[W̎擾́A
	 * ۂ̃tH_̃I[v܂ޕׂ̑傫ɂȂꍇ܂B
	 * ꍇAvoC_͕Ԃł̂̋@\T|[gȂlɑIł܂B
	 * ̏ꍇÃ\bh -1 ԂKv܂B<p>
	 * 
	 * tH_ł̃\bhĂяoNCAǵA
	 * ꂪׂ̑傫ɂȂ\鎖ɒӂKv܂B
	 * ̏ꍇANCAg͖߂l -1 ɑ΂鏈Kv܂B
	 * 
	 * @return bZ[W̐B̃\bhtH_ŌĂяoꂽꍇA
	 * ꕔ̎ł -1 Ԃ邱Ƃ܂B
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws MessagingException
	 */
	public abstract int getMessageCount() throws MessagingException;

	/**
	 *  Folder ̐VKbZ[W̐擾܂B<p>
	 * 
	 * ̃\bh͕tH_ŌĂяoł܂B
	 * AAꕔ̃tH_ɂāAVKbZ[W̎擾́A
	 * ۂ̃tH_̃I[v܂ޕׂ̑傫ɂȂꍇ܂B
	 * ꍇAvoC_͕Ԃł̂̋@\T|[gȂlɑIł܂B
	 * ̏ꍇÃ\bh -1 ԂKv܂B<p>
	 * 
	 * tH_ł̃\bhĂяoNCAǵA
	 * ꂪׂ̑傫ɂȂ\鎖ɒӂKv܂B
	 * ̏ꍇANCAg͖߂l -1 ɑ΂鏈Kv܂B<p>
	 * 
	 * ̃tH_ĂꍇA̎ -1 Ԃ܂BłȂꍇA
	 * ̎ <code>getMessage(int)</code> gpătH_̊e Message 擾A
	 * <code>RECENT</code> tOݒ肳Ă邩ǂ`FbN܂B
	 * ̃tOݒ肳Ă郁bZ[W̐Ԃ܂B
	 * 
	 * @return VKbZ[W̐B̃\bhtH_ŌĂяoꂽꍇA
	 * ꕔ̎ł -1 Ԃ鎖܂B
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws MessagingException
	 */
	public synchronized int getNewMessageCount() throws MessagingException {
		if (!isOpen())
			return -1;

		int newmsgs = 0;
		int total = getMessageCount();
		for (int i = 1; i <= total; i++) {
			try {
				if (getMessage(i).isSet(Flags.Flag.RECENT))
					newmsgs++;
			} catch (MessageRemovedException me) {
				// ̏ꍇ͍폜ꂽbZ[WȂ̂Ŗ܂B
				continue;
			}
		}
		return newmsgs;
	}

	/**
	 *  Folder ̖ǃbZ[W̐擾܂B<p>
	 * 
	 * ̃\bh͕tH_ŌĂяoł܂B
	 * AAꕔ̃tH_ɂāAǃbZ[W̎擾́A
	 * ۂ̃tH_̃I[v܂ޕׂ̑傫ɂȂꍇ܂B
	 * ꍇAvoC_͕Ԃł̂̋@\T|[gȂlɑIł܂B
	 * ̏ꍇÃ\bh -1 ԂKv܂B<p>
	 * 
	 * tH_ł̃\bhĂяoNCAǵA
	 * ꂪׂ̑傫ɂȂ\鎖ɒӂKv܂B
	 * ̏ꍇANCAg͖߂l -1 ɑ΂鏈Kv܂B<p>
	 * 
	 * ̃tH_ĂꍇA̎ -1 Ԃ܂B
	 * łȂꍇA̎ <code>getMessage(int)</code> gpătH_̊e Message 擾A
	 * <code>SEEN</code> tOݒ肳Ă邩ǂ`FbN܂B
	 * ̃tOݒ肳ĂȂbZ[W̐Ԃ܂B
	 * 
	 * @return ǃbZ[W̐B̃\bhtH_ŌĂяoꂽꍇA
	 * ꕔ̎ł -1 Ԃ鎖܂B
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws MessagingException
	 */
	public synchronized int getUnreadMessageCount() throws MessagingException {
		if (!isOpen())
			return -1;

		int unread = 0;
		int total = getMessageCount();
		for (int i = 1; i <= total; i++) {
			try {
				if (!getMessage(i).isSet(Flags.Flag.SEEN))
					unread++;
			} catch (MessageRemovedException me) {
				// ̏ꍇ͍폜ꂽbZ[WȂ̂Ŗ܂B
				continue;
			}
		}
		return unread;
	}

	/**
	 *  Folder ̍폜ς݃bZ[W̐擾܂B<p>
	 * 
	 * ̃\bh͕tH_ŌĂяoł܂B
	 * AAꕔ̃tH_ɂāA폜ς݃bZ[W̎擾́A
	 * ۂ̃tH_̃I[v܂ޕׂ̑傫ɂȂꍇ܂B
	 * ꍇAvoC_͕Ԃł̂̋@\T|[gȂlɑIł܂B
	 * ̏ꍇÃ\bh -1 ԂKv܂B<p>
	 * 
	 * tH_ł̃\bhĂяoNCAǵA
	 * ꂪׂ̑傫ɂȂ\鎖ɒӂKv܂B
	 * ̏ꍇANCAg͖߂l -1 ɑ΂鏈Kv܂B<p>
	 * 
	 * ̃tH_ĂꍇA̎ -1 Ԃ܂B
	 * łȂꍇA̎ <code>getMessage(int)</code> gpătH_̊e Message 擾A
	 * <code>DELETED</code> tOݒ肳Ă邩ǂ`FbN܂B
	 * 
	 * @return 폜ς݃bZ[W̐B̃\bhtH_ŌĂяoꂽꍇA
	 * ꕔ̎ł -1 Ԃ鎖܂B
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws MessagingException
	 * @since JavaMail 1.3
	 */
	public synchronized int getDeletedMessageCount() throws MessagingException {
		if (!isOpen())
			return -1;
	
		int deleted = 0;
		int total = getMessageCount();
		for (int i = 1; i <= total; i++) {
			try {
				if (getMessage(i).isSet(Flags.Flag.DELETED))
					deleted++;
			} catch (MessageRemovedException me) {
				// ̏ꍇ͍폜ꂽbZ[WȂ̂Ŗ܂B
				continue;
			}
		}
		return deleted;
	}

	/**
	 * w肳ꂽbZ[WԍɑΉ Message IuWFNg擾܂B
	 * Message IuWFNg̃bZ[Wԍ́A Message  Folder ̑ΈʒułB
	 * bZ[Wɂ 1 tH_̃bZ[W̐̔ԍ蓖Ă܂B
	 *  Message ̃bZ[Wԍ́AFolder ̑̃bZ[W폜A
	 * Folder ꂽꍇAZbVɕύXɂȂ鎖܂B<p>
	 * 
	 * Message IuWFNǵAIf}hŖۂ̃bZ[Wւ̌yʂȎQƂłB
	 * ]āAFolder ͌yʂ Message IuWFNg񋟂Kv܂B<p>
	 * 
	 * Folder IuWFNgƈقȂAbZ[WԍgpČJԂ getMessage ĂяoꍇA
	 * ̃tH_ŏꂽbZ[WȂA Message IuWFNgԂ܂B<p>
	 * 
	 * tH_ƁAZbVɃbZ[WԍύXɂȂ鎖ׁA
	 * NCAg̓bZ[Wւ̎QƂƂăbZ[Wԍgpׂł͂܂B
	 *  Message IuWFNggpĉB
	 * 
	 * @param msgnum bZ[Wԍ
	 * @return Message IuWFNg
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws IndexOutOfBoundsException bZ[Wԍ͈͊Ȍꍇ
	 * @throws MessagingException
	 * @see #getMessageCount
	 * @see #fetch
	 */
	public abstract Message getMessage(int msgnum) throws MessagingException;

	/**
	 * bZ[Wԍ start  end ͈̔
	 *  (start  end ܂) ɂ Message IuWFNg擾܂B
	 * bZ[Wԍ 0 ł͂ȂA1 n܂܂B<p>
	 * 
	 * Message IuWFNǵAIf}hŖۂ̃bZ[Wւ̌yʂȎQƂłB
	 * ]āAFolder ͌yʂ Message IuWFNg񋟂Kv܂B<p>
	 * 
	 * ̎ getMessage(index) gpāAKv Message IuWFNg擾܂B
	 * Ԃz <code>(end - start + 1)</code> Message IuWFNg܂݂܂B
	 * 
	 * @param start ŏ̃bZ[W̔ԍ
	 * @param end Ō̃bZ[W̔ԍ
	 * @return Message IuWFNg
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws IndexOutOfBoundsException start  end ̃bZ[Wԍ͈͊Ȍꍇ
	 * @throws MessagingException
	 * @see #fetch
	 */ 
	public synchronized Message[] getMessages(final int start, final int end) throws MessagingException {
		Message[] msgs = new Message[end - start +1];
		for (int i = start; i <= end; i++)
			msgs[i - start] = getMessage(i);
		return msgs;
	}

	/**
	 * zŎw肳ꂽbZ[Wԍ Message IuWFNg擾܂B<p>
	 * 
	 * Message IuWFNǵAIf}hŖۂ̃bZ[Wւ̌yʂȎQƂłB
	 * ]āAFolder ͌yʂ Message IuWFNg񋟂Kv܂B<p>
	 * 
	 * ̎ getMessage(index) gpāAKv Message IuWFNg擾܂B
	 * Ԃz <code>msgnums.length</code> Message IuWFNg܂݂܂B
	 * 
	 * @param msgnums bZ[Wԍ̔z
	 * @return Message IuWFNg̔z 
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws IndexOutOfBoundsException w肳ꂽz񒆂̂ꂩ̃bZ[Wԍ͈͊Ȍꍇ
	 * @throws MessagingException
	 * @see #fetch
	 */ 
	public synchronized Message[] getMessages(final int[] msgnums) throws MessagingException {
		int len = msgnums.length;
		Message[] msgs = new Message[len];
		for (int i = 0; i < len; i++)
			msgs[i] = getMessage(msgnums[i]);

		return msgs;
	}

	/**
	 *  Folder SĂ Message IuWFNg擾܂B
	 * tH_̏ꍇ́A̔zԂ܂B
	 * 
	 * NCAg̓tH_̃bZ[Wւ̎QƂƂāA
	 * (V[PXԍł͂Ȃ) Message IuWFNggpł܂B
	 * ̃\bh Message IuWFNgNCAg֋܂B
	 * Folder ̓If}hŖyʂ Message IuWFNg񋟂Kv܂B<p>
	 * 
	 * ̎ <code>getMessageCount()</code> ĂяoČ݂̃bZ[WJEg擾A
	 * <code>getMessage()</code> gp Message IuWFNg 1 烁bZ[W܂Ŏ擾܂B
	 * 
	 * @return Message IuWFNg̔zBtH_̏ꍇ͋̔z
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws MessagingException
	 * @see #fetch
	 */ 
	public synchronized Message[] getMessages() throws MessagingException {
		if (!isOpen())	// otherwise getMessageCount might return -1
			throw new IllegalStateException("Folder not open");
		int total = getMessageCount();
		Message[] msgs = new Message[total];
		for (int i = 1; i <= total; i++)
			msgs[i-1] = getMessage(i);

		return msgs;
	}

	/**
	 * w肳ꂽ Messages ̃tH_ɒǉ܂B
	 * ̃\bh͕ Folder ŌĂяoł܂B
	 * bZ[WtH_ɓہAK؂ MessageCountEvent 
	 * ̃tH_ɓo^ĂSĂ MessageCountListener ɔzM܂B<p>
	 * 
	 * w肳ꂽbZ[Wz񒆂 Message ꂽ Message ƔĂA
	 * Folder ͂̑𒆎~Ă͂܂B
	 * 
	 * @param msgs ǉ Message ̔z
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws MessagingException ǉsꍇ
	 */
	public abstract void appendMessages(Message[] msgs) throws MessagingException;

	/**
	 * w肳ꂽ Message  FetchProfile Ɏw肳ꂽڂǂ݂܂B<p>
	 * 
	 * NCAg͂̃\bhgpāAw肳ꂽ
	 * ڑŜw肳ꂽbZ[W͈͂ŕKvɂȂ鎖܂B
	 * ́Aw肳ꂽbZ[W͈͂̂̍ڂIȕ@Ŏ擾Kv܂B
	 * ̃\bh́AYڂǂ݂Ɋւqgɉ߂܂B<p>
	 * 
	 * ƂāAwb_r[EBhEɁAtH_̑SẴbZ[Wɑ΂ SubjectA
	 * FromA X-mailer wb_͂NCAg܂B<p>
	 * <blockquote><pre>
	 * 
	 *  Message[] msgs = folder.getMessages();
	 *  
	 *  FetchProfile fp = new FetchProfile();
	 *  fp.add(FetchProfile.Item.ENVELOPE);
	 *  fp.add("X-mailer");
	 *  folder.fetch(msgs, fp);
	 *  
	 *  for (int i = 0; i < folder.getMessageCount(); i++) {
	 *      display(msg[i].getFrom());
	 *      display(msg[i].getSubject());
	 *      display(msg[i].getHeader("X-mailer"));
	 *  }
	 * 
	 * </pre></blockquote><p>
	 * 
	 * Œ񋟂́APɖ߂邾łB
	 * ̃\bhɎvoC_́Ã\bhI[o[ChKv܂B
	 * 
	 * @param msgs ̃bZ[W̃tFb`
	 * @param fp FetchProfile
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws MessagingException.
	 */
	public void fetch(final Message[] msgs, final FetchProfile fp) throws MessagingException {
		return;
	}

	/**
	 * z񒆂Ɏw肳ꂽbZ[WɎw肳ꂽtOݒ肵܂B
	 * ɂA Message ܂łtH_ɓo^Ă
	 * SĂ MessageChangedListener ɓK؂ MessageChangedEvent zM鎖ɂȂ܂B<p>
	 * 
	 * w肳ꂽ Message IuWFNǵÃtH_<strong>ĂKv܂</strong>B
	 * Folder ɂẮAbZ[W̃O[vɑ΂ Flags ̐ݒ葀œKĂꍇ̂ŁA
	 * NCAg͊e Message ɂ <code>Message.setFlags</code> Ăяôł͂ȂA
	 * ̃\bhgpƂ悢ł傤B<p>
	 * 
	 * ̎́APɊe Message IuWFNg <code>setFlags()</code> ĂяołB
	 * ̑œKł悤ȓ Folder ł́AœKׂłB
	 * Az񒆂 Message ꂽ Message łƔꍇA͑𒆎~Ă͂܂B
	 * 
	 * @param msgs bZ[WIuWFNg̔z
	 * @param flag ݒ肳tO܂ Flags IuWFNg
	 * @param value tOɂ̃u[lݒ肷
	 * @throws IllegalStateException ̃tH_JĂȂꍇA READ_ONLY ŊJĂꍇ
	 * @throws MessagingException
	 * @see Message#setFlags
	 * @see javax.mail.event.MessageChangedEvent
	 */
	public synchronized void setFlags(
		final Message[] msgs,
		final Flags flag,
		final boolean value)
		throws  MessagingException {

		for (int i = 0; i < msgs.length; i++) {
			try {
				msgs[i].setFlags(flag, value);
			} catch (MessageRemovedException me) {
				// ̏ꍇ͍폜ꂽbZ[WȂ̂ŃXLbv܂B
			}
		}
	}

	/**
	 * w肳ꂽtOAstart  end ܂ (start  end ̗܂) ̔ԍ̃bZ[Wɐݒ肵܂B
	 * bZ[Wԍ 0 ł͂Ȃ 1 n܂܂BɂA
	 *  Message ܂łtH_ɓo^Ă
	 * SĂ MessageChangedListener ɓK؂ MessageChangedEvent zM鎖ɂȂ܂B<p>
	 * 
	 * Folder ɂẮAbZ[W̃O[vɂ Flags ̐ݒ葀œKĂꍇ̂ŁA
	 * NCAg͊e Message ɑ΂ <code>Message.setFlags</code> 
	 * Ăяõ\bhgpƂ悢ł傤B<p>
	 * 
	 * ftHg̎ <code>getMessage(int)</code> gp
	 * e <code>Message</code> IuWFNg擾A
	 * ̃IuWFNg <code>setFlags</code> ĂяoătOݒ肵܂B
	 * ̑œKłlȓ Folder ł́AœKׂłB
	 * AbZ[WԍꂽbZ[WQƂꍇłA
	 * ͑𒆎~Ă͂܂B
	 * 
	 * @param start ŏ̃bZ[W̔ԍ
	 * @param end Ō̃bZ[W̔ԍ
	 * @param flag ݒ肳tO܂ Flags IuWFNg
	 * @param value tOɂ̃u[lݒ肷
	 * @throws IllegalStateException ̃tH_JĂȂꍇA READ_ONLY ŊJĂꍇ
	 * @throws IndexOutOfBoundsException start  end ̃bZ[Wԍ͈͊Ȍꍇ
	 * @throws MessagingException
	 * @see Message#setFlags
	 * @see javax.mail.event.MessageChangedEvent
	 */
	public synchronized void setFlags(
		final int start,
		final int end,
		final Flags flag,
		final boolean value)
		throws MessagingException {

		for (int i = start; i <= end; i++) {
			try {
				Message msg = getMessage(i);
				msg.setFlags(flag, value);
			} catch (MessageRemovedException me) {
				// ̏ꍇ͍폜ꂽbZ[WȂ̂ŃXLbv܂B
			}
		}
	}

	/**
	 * bZ[Wԍz񒆂ɑ݂郁bZ[WɎw肳ꂽtOݒ肵܂B
	 * ɂA Message ܂łtH_ɓo^Ă
	 * SĂ MessageChangedListener ɓK؂ MessageChangedEvent zM鎖ɂȂ܂B<p>
	 * 
	 * Folder ɂẮAbZ[W̃O[vɂ Flags ̐ݒ葀
	 * œKĂꍇ̂ŁANCAg͊e Message 
	 * ΂ <code>Message.setFlags</code> Ăяõ\bhgpƂ悢ł傤B<p>
	 * 
	 * ftHg̎ <code>getMessage(int)</code> gp
	 * e <code>Message</code> IuWFNg擾A
	 * ̃IuWFNg <code>setFlags</code> ĂяoătOݒ肵܂B
	 * ̑œKłlȓ Folder ł́AœKׂłB
	 * AbZ[WԍꂽbZ[WQƂꍇłA
	 * ͑𒆎~Ă͂܂B
	 * 
	 * @param msgnums bZ[Wԍ̔z
	 * @param flag ݒ肳tO܂ Flags IuWFNg
	 * @param value tOɂ̃u[lݒ肷
	 * @throws IllegalStateException ̃tH_JĂȂꍇA READ_ONLY ŊJĂꍇ
	 * @throws IndexOutOfBoundsException w肳ꂽz񒆂̉ꂩ̃bZ[Wԍ͈͊Ȍꍇ
	 * @throws MessagingException
	 * @see Message#setFlags
	 * @see javax.mail.event.MessageChangedEvent
	 */
	public synchronized void setFlags(
		final int[] msgnums,
		final Flags flag,
		final boolean value)
		throws MessagingException {

		for (int i = 0; i < msgnums.length; i++) {
			try {
				Message msg = getMessage(msgnums[i]);
				msg.setFlags(flag, value);
			} catch (MessageRemovedException me) {
				// This message is expunged, skip 
			}
		}
	}

	/**
	 *  Folder w肳ꂽ Message ʂ Folder ɃRs[܂B
	 * ̑͂ Message Rs[ Folder ɒǉ܂B
	 * Rs[ Folder JĂKv͂܂BbZ[WtH_ɓƁA
	 * Rs[tH_ɓo^ĂSĂ MessageCountListener ɓK؂ MessageCountEvent zM܂B<p>
	 * 
	 * w肳ꂽ Message IuWFNǵÃtH_<strong>ĂKv܂</strong>B
	 * Folder ɂẮAT[oRs[sɂÃ\bhœKł܂B<p>
	 * 
	 * ̎͒PɃRs[tH_ <code>appendMessages()</code> ĂяoA
	 * w肳ꂽ Message ǉ܂BRs[tH_ Store ̃tH_ Store ƓꍇA
	 * T[oRs[T|[głlȓ Folder ł́A̗lȍœKsׂłB
	 * Az񒆂 Message ꂽ Message ƔꍇłA͑𒆎~Ă͂܂B
	 * 
	 * @param msgs bZ[WIuWFNg̔z
	 * @param folder bZ[W̃Rs[tH_
	 * @throws FolderNotFoundException Rs[tH_݂Ȃꍇ
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws MessagingException
	 * @see #appendMessages
	 */
	public void copyMessages(final Message[] msgs, final Folder folder) throws MessagingException {
		if (!folder.exists())
			throw new FolderNotFoundException(folder.getFullName() + " does not exist", folder);
		folder.appendMessages(msgs);
	}

	/**
	 * DELETED ̃}[NtĂ (iIȍ폜) bZ[WłB
	 * ꂽbZ[WIuWFNg܂ޔzԂ܂B
	 * ̊ebZ[WIuWFNg <code>getMessageNumber</code> \bh́A
	 * Message ̌ (܂AO) ̃V[PXԍԂ܂B
	 * tH_ɓo^ĂSĂ MessageCountListener ɁA
	 * ꂽbZ[W܂ MessageCountEvent zM܂B<p>
	 * 
	 * bZ[W̏ɂAbZ[Wȍ~ Message IuWFNg̔ԍēx蓖Ă܂B
	 * bZ[Wւ̎QƂƂăbZ[WԍgpNCAg͂̓_ɒӂȂ΂Ȃ炸A
	 * 󋵂ɑΏ鏀KvɂȂ܂ (̃bZ[WԍLbVAēxǍ)B
	 * GANCAg̓bZ[WԍłȂ Message IuWFNggpăbZ[WQƂK؂łB
	 *  Message IuWFNg͈ˑRƂďKv܂A
	 * tH_̑ Message IuWFNg͏ɂe󂯂܂B<p>
	 * 
	 * bZ[W폜ꂽAΉ Message IuWFNg
	 * ł <code>isExpunged</code> y <code>getMessageNumber</code> \bĥ݂ˑRLłB
	 * ̑̃\bh <code>MessageRemovedException</code> X[ꍇ܂B
	 * 
	 * @return ꂽ Message IuWFNg̔z
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws MessagingException
	 * @see Message#isExpunged
	 * @see javax.mail.event.MessageCountEvent
	 */
	public abstract Message[] expunge() throws MessagingException;

	/**
	 * w肳ꂽɈv郁bZ[WɂĂ Folder ܂B
	 * v郁bZ[W܂ޔzԂ܂B
	 * v̂Ȃꍇ́A̔zԂ܂B<p>
	 * 
	 * ̎ <code>search(term, getMessages())</code> ĂяoA
	 * ̃tH_̑SẴbZ[WɂČKp܂B
	 * T[ǒ\ȃvoC_́Ã\bh
	 * I[o[ChĂIȎ񋟂Ƃ悢ł傤B
	 * 
	 * @param term 
	 * @return v郁bZ[W̔z 
	 * @throws javax.mail.search.SearchException GĎłȂꍇ 
	 * @throws FolderNotFoundException ̃tH_݂Ȃꍇ 
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws MessagingException
	 * @see javax.mail.search.SearchTerm
	 */
	public Message[] search(final SearchTerm term) throws MessagingException {
		return search(term, getMessages());
	}

	/**
	 * w肳ꂽɈv郁bZ[WɂāA
	 * w肳ꂽbZ[Wz܂B
	 * v郁bZ[W܂ޔzԂ܂B
	 * v̂Ȃꍇ́A̔zԂ܂B<p>
	 * 
	 * w肳ꂽ Message IuWFNǵÃtH_<strong>ĂKv܂</strong>B<p>
	 * 
	 * ͎̎w肳ꂽbZ[W̔z̗vfꂼɑ΂A
	 * w肳ꂽ <code>match()</code> \bhĂяoɂA
	 * ebZ[WɌKp܂BvɐbZ[WԂ܂B
	 * T[ǒ\ȃvoC_́Ã\bhI[o[ChA
	 * IȎ񋟂Ƃ悢ł傤B
	 * G邩AT[oŎsłȂ[U`܂ޏꍇA
	 * voC_ SearchException X[邩A
	 *  <code>super.search()</code> Ăяoł̎ĂяoāA
	 * (œKĂȂ) NCAgł̌ɔC鎖\łB
	 * 
	 * @param term 
	 * @param msgs 郁bZ[W
	 * @return v郁bZ[W̔z 
	 * @throws javax.mail.search.SearchException GĎłȂꍇ 
	 * @throws IllegalStateException ̃tH_JĂȂꍇ
	 * @throws MessagingException
	 * @see javax.mail.search.SearchTerm
	 */
	public Message[] search(final SearchTerm term, final Message[] msgs) throws MessagingException {
		Vector matchedMsgs = new Vector();

		// bZ[WʂĎs܂
		for (int i = 0; i < msgs.length; i++) {
			try {
				if (msgs[i].match(term))				// vꍇ
					matchedMsgs.addElement(msgs[i]);	// ǉ܂
			} catch(MessageRemovedException mrex) {}
		}

		Message[] m = new Message[matchedMsgs.size()];
		matchedMsgs.copyInto(m);
		return m;
	}

	/*
	 * The set of listeners are stored in Vectors appropriate to their
	 * type.  We mark all listener Vectors as "volatile" because, while
	 * we initialize them inside this folder's synchronization lock,
	 * they are accessed (checked for null) in the "notify" methods,
	 * which can't be synchronized due to lock ordering constraints.
	 * Since the listener fields (the handles on the Vector objects)
	 * are only ever set, and are never cleared, we believe this is
	 * safe.  The code that dispatches the notifications will either
	 * see the null and assume there are no listeners or will see the
	 * Vector and will process the listeners.  There's an inherent race
	 * between adding a listener and notifying the listeners; the lack
	 * of synchronization during notification does not make the race
	 * condition significantly worse.  If one thread is setting a
	 * listener at the "same" time an event is being dispatched, the
	 * dispatch code might not see the listener right away.  The
	 * dispatch code doesn't have to worry about the Vector handle
	 * being set to null, and thus using an out-of-date set of
	 * listeners, because we never set the field to null.
	 */

	// ڑXi[̔z
	private volatile Vector connectionListeners = null;

	/**
	 *  Folder  Connection Cxg̃Xi[ǉ܂B<p>
	 * 
	 * Œ񋟂́ÃXi[ ConnectionListener Xgɒǉ܂B
	 * 
	 * @param l Connection Cxg Listener
	 * @see javax.mail.event.ConnectionEvent
	 */
	public synchronized void addConnectionListener(final ConnectionListener l) { 
		if (connectionListeners == null) 
			connectionListeners = new Vector();
		connectionListeners.addElement(l);
	}

	/**
	 * Connection CxgXi[폜܂B<p>
	 * 
	 * Œ񋟂́ÃXi[ ConnectionListener Xg폜܂B
	 * 
	 * @param l Xi[
	 * @see #addConnectionListener
	 */
	public synchronized void removeConnectionListener(final ConnectionListener l) { 
		if (connectionListeners != null) 
			connectionListeners.removeElement(l);
	}

	/**
	 * ׂĂ ConnectionListener ɒʒm܂B
	 * Folder ́Ã\bhgpĐڑCxgu[hLXgKv܂B<p>
	 * 
	 * 񋟂́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓L[CxgoA
	 * o^ꂽ ConnectionListener ɃfBXpb`܂B
	 * CxgfBXpb`͕ʌ̃XbhŋNׁAfbhbNh܂B
	 * 
	 * @param type ConnectionEvent ̌^
	 * @see javax.mail.event.ConnectionEvent
	 */
	protected void notifyConnectionListeners(final int type) {
		if (connectionListeners != null) {
			ConnectionEvent e = new ConnectionEvent(this, type);
			queueEvent(e, connectionListeners);
		}

		/* Fix for broken JDK1.1.x Garbage collector :
		 *  The 'conservative' GC in JDK1.1.x occasionally fails to
		 *  garbage-collect Threads which are in the wait state.
		 *  This would result in thread (and consequently memory) leaks.
		 * 
		 * We attempt to fix this by sending a 'terminator' event
		 * to the queue, after we've sent the CLOSED event. The
		 * terminator event causes the event-dispatching thread to
		 * self destruct.
		 */
		if (type == ConnectionEvent.CLOSED)
			terminateQueue();
	}

	// tH_Xi[̔z
	private volatile Vector folderListeners = null;

	/**
	 *  Folder  Folder Cxg̃Xi[ǉ܂B<p>
	 * 
	 * Œ񋟂́ÃXi[ FolderListener Xgɒǉ܂B
	 * 
	 * @param l Folder Cxg Listener
	 * @see javax.mail.event.FolderEvent
	 */
	public synchronized void addFolderListener(final FolderListener l) { 
		if (folderListeners == null)
			folderListeners = new Vector();
		folderListeners.addElement(l);
	}

	/**
	 * Folder CxgXi[폜܂B<p>
	 * 
	 * Œ񋟂́ÃXi[ FolderListener Xg폜܂B
	 * 
	 * @param l Xi[
	 * @see #addFolderListener
	 */
	public synchronized void removeFolderListener(final FolderListener l) {
		if (folderListeners != null)
			folderListeners.removeElement(l);
	}

	/**
	 *  Folder Ƃ̃tH_ Store ɓo^ĂSĂ FolderListener ɒʒm܂B
	 * Folder ͂̃\bhgpāAFolder Cxgu[hLXgKv܂B<p>
	 * 
	 * Œ񋟂́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓CxgL[oA
	 * ̃tH_ɓo^Ă FolderListener ɃfBXpb`܂B
	 * A͂̃tH_ Store  <code>notifyFolderListeners</code> ĂяoA
	 * XgAɓo^Ă邷ׂĂ FolderListener ɒʒm܂B
	 * 
	 * @param type FolderEvent ̌^
	 * @see #notifyFolderRenamedListeners
	 */
	protected void notifyFolderListeners(final int type) { 
		if (folderListeners != null) {
			FolderEvent e = new FolderEvent(this, this, type);
			queueEvent(e, folderListeners);
		}
		store.notifyFolderListeners(type, this);
	}

	/**
	 *  Folder Ƃ̃tH_ Store ɓo^ĂSĂ FolderListener ɁA
	 * ̃tH_̖OύXɂĒʒm܂BFolder ͂̃\bhgpāA
	 * tH_̖OύXɊւ Folder Cxgu[hLXgKv܂B<p>
	 * 
	 * Œ񋟂́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓CxgL[oA
	 * ̃tH_ɓo^Ă FolderListener ɃfBXpb`܂B
	 * A͂̃tH_ Store  <code>notifyFolderRenamedListeners</code> ĂяoA
	 * XgAɓo^ĂSĂ FolderListener ɒʒm܂B
	 * 
	 * @param folder VO\tH_
	 * @since JavaMail 1.1
	 * @see #notifyFolderListeners
	 */
	protected void notifyFolderRenamedListeners(final Folder folder) {
		if (folderListeners != null) {
			FolderEvent e = new FolderEvent(this, this, folder, FolderEvent.RENAMED);
			queueEvent(e, folderListeners);
		}
		store.notifyFolderRenamedListeners(this, folder);
	}

	// MessageCount Xi[̔z
	private volatile Vector messageCountListeners = null;

	/**
	 *  Folder  MessageCount Cxg̃Xi[ǉ܂B<p>
	 * 
	 * Œ񋟂́ÃXi[ MessageCountListener Xgɒǉ܂B
	 * 
	 * @param l MessageCount Cxg Listener
	 * @see javax.mail.event.MessageCountEvent
	 */
	public synchronized void addMessageCountListener(final MessageCountListener l) { 
		if (messageCountListeners == null)
			messageCountListeners = new Vector();
		messageCountListeners.addElement(l);
	}

	/**
	 * MessageCount Xi[폜܂B<p>
	 * 
	 * Œ񋟂́ÃXi[ MessageCountListener Xg폜܂B
	 * 
	 * @param l Xi[
	 * @see #addMessageCountListener
	 */
	public synchronized void removeMessageCountListener(final MessageCountListener l) { 
		if (messageCountListeners != null) 
			messageCountListeners.removeElement(l); 
	}

	/**
	 * SĂ MessageCountListener ɁÃtH_ւ̃bZ[Wǉʒm܂B
	 * Folder ͂̃\bhgpAVKbZ[W̓
	 *  MessageCount Cxgu[hLXgKv܂B<p>
	 * 
	 * 񋟂́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓L[CxgoA
	 * o^ꂽ MessageCountListener ɃfBXpb`܂B
	 * CxgfBXpb`͕ʌ̃XbhŋNׁAfbhbNh܂B
	 */
	protected void notifyMessageAddedListeners(final Message[] msgs) { 
		if (messageCountListeners == null)
			return;

		MessageCountEvent e = new MessageCountEvent(this, MessageCountEvent.ADDED, false, msgs);
		queueEvent(e, messageCountListeners); 
	}

	/**
	 * SĂ MessageCountListener ɁÃtH_̃bZ[W폜ʒm܂B
	 * Folder ͂̃\bhgpAbZ[W̍폜
	 *  MessageCount Cxgu[hLXgKv܂B<p>
	 * 
	 * 񋟂́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓L[CxgoA
	 * o^ꂽ MessageCountListener ɃfBXpb`܂B
	 * CxgfBXpb`͕ʌ̃XbhŋNׁAfbhbNh܂B
	 */
	protected void notifyMessageRemovedListeners(final boolean removed, final Message[] msgs) { 
		if (messageCountListeners == null)
			return;
		MessageCountEvent e = new MessageCountEvent(this, MessageCountEvent.REMOVED, removed, msgs);
		queueEvent(e, messageCountListeners); 
	}

	// MessageChanged Xi[̔z
	private volatile Vector messageChangedListeners = null;

	/**
	 *  Folder  MessageChanged Cxg̃Xi[ǉ܂B<p>
	 * 
	 * Œ񋟂́ÃXi[ MessageChangedListener Xgɒǉ܂B
	 * 
	 * @param l MessageChanged Cxg Listener
	 * @see javax.mail.event.MessageChangedEvent
	 */
	public synchronized void addMessageChangedListener(final MessageChangedListener l) { 
		if (messageChangedListeners == null)
			messageChangedListeners = new Vector();
		messageChangedListeners.addElement(l);
	}

	/**
	 * MessageChanged Xi[폜܂B<p>
	 * 
	 * Œ񋟂́ÃXi[ MessageChangedListener Xg폜܂B
	 * 
	 * @param l Xi[
	 * @see #addMessageChangedListener
	 */
	public synchronized void removeMessageChangedListener(final MessageChangedListener l) { 
		if (messageChangedListeners != null) 
			messageChangedListeners.removeElement(l);
	}

	/**
	 * SĂ MessageChangedListener ɒʒm܂B
	 * Folder ͂̃\bhgpāAMessageChanged Cxgu[hLXgKv܂B<p>
	 * 
	 * 񋟂́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓L[CxgoA
	 * o^ꂽ MessageChangedListener ɃfBXpb`܂B
	 * CxgfBXpb`͕ʌ̃XbhŋNׁAfbhbNh܂B
	 */
	protected void notifyMessageChangedListeners(final int type, final Message msg) {
		if (messageChangedListeners == null)
			return;
		MessageChangedEvent e = new MessageChangedEvent(this, type, msg);
		queueEvent(e, messageChangedListeners);
	}

	/*
	 * The queue of events to be delivered.
	 */
	private EventQueue q;

	/*
	 * A lock for creating the EventQueue object.  Only one thread should
	 * create an EventQueue for this folder.  We can't synchronize on the
	 * folder's lock because that would violate the locking hierarchy in
	 * some cases.  For details, see the IMAP provider.
	 */
	private Object qLock = new Object();

	/*
	 * Add the event and vector of listeners to the queue to be delivered.
	 */
	private void queueEvent(final MailEvent event, final Vector vector) {
		// synchronize creation of the event queue
		synchronized (qLock) {
			if (q == null)
				q = new EventQueue();
		}

		/*
		 * Copy the vector in order to freeze the state of the set
		 * of EventListeners the event should be delivered to prior
		 * to delivery.  This ensures that any changes made to the
		 * Vector from a target listener's method during the delivery
		 * of this event will not take effect until after the event is
		 * delivered.
		 */
		Vector v = (Vector) vector.clone();
		q.enqueue(event, v);
	}

	static class TerminatorEvent extends MailEvent {

		private static final long serialVersionUID = 3765761925441296565L;

		TerminatorEvent() {
			super(new Object());
		}

		public void dispatch(final Object obj) {
			Thread.currentThread().interrupt();
		}

	}

	// Dispatch the terminator
	private void terminateQueue() {
		synchronized (qLock) {
			if (q != null) {
				Vector dummyListeners = new Vector();
				dummyListeners.setSize(1); // need atleast one listener
				q.enqueue(new TerminatorEvent(), dummyListeners);
				q = null;
			}
		}
	}

	protected void finalize() throws Throwable {
		super.finalize();
		terminateQueue();
	}

	/**
	 * ftHg toString() I[o[Ch܂B
	 * Folder.getFullName()  String ԂA
	 * ꂪ null ̏ꍇ̓ftHg toString() gp܂B
	 */
	public final String toString() {
		String s = getFullName();
		if (s != null)
			return s;
		return super.toString();
	}

}
