/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Date;

import javax.mail.search.SearchTerm;

/**
 * ̃NX͓dq[bZ[Wf܂B
 * ͒ۃNXłBTuNX͎ۂ̎񋟂܂B<p>
 * 
 * Message  Part C^tF[X܂B
 * Message ͈Ȃ "e" ܂݂܂B
 * tH_ Message ́AtH_̏Ԃ\ÃtO܂ł܂B<p>
 * 
 * Message  <code>Part</code> C^tF[Xɒ`鑮ɉAVK̑`܂B
 * ̑̓bZ[W̃^f[^A܂AbZ[W̃AhbVOyѐIw肵܂B<p>
 * 
 * Message IuWFNǵAFolder A
 * ͓K؂ȃTuNX̐VK Message IuWFNg\z鎖ɂ擾܂B
 * Mς݂ Message ́Aʏ "INBOX" ƂtH_o܂B<p>
 * 
 * tH_擾 Message IuWFNǵAۂ̃bZ[Wւ̌yʂȎQƂɉ߂܂B
 * Message ́AeڂbZ[Wv鎞(If}h)͂܂B
 * ꕔ̃tH_́Ã[Uw荀ڂ͍ς݂ Message IuWFNgԂł܂B
 * 
 * bZ[W𑗐Mɂ́AMessage ̓K؂ȃTuNX (MimeMessage ) CX^XA
 * Ɠe͂A<code>Transport.send</code> \bhgpăbZ[WM܂B<p>
 * 
 * @see javax.mail.Part
 */
public abstract class Message implements Part {

	/**
	 * tH_̂̃bZ[W̔ԍłB
	 * bZ[WtH_oȂꍇ 0 ɂȂ܂B
	 */
	protected int msgnum = 0;

	/**
	 * ̃bZ[Wꂽꍇ true ɂȂ܂B
	 */
	protected boolean expunged = false;

	/**
	 * ̃bZ[WtH_擾ꍇ́AbZ[W̊܂܂tH_łB
	 */
	protected Folder folder = null;

	/**
	 *  Message  Session IuWFNgłB
	 */
	protected Session session = null;

	/**
	 * Ȃ̃RXgN^łB
	 */
	protected Message() {}

	/**
	 * Folder yуbZ[Wԍ󂯎RXgN^łB
	 * Folder ɂgp܂B
	 * 
	 * @param folder  Message ܂ރtH_
	 * @param msgnum ̃tH_̂̃bZ[W̃V[PXԍ
	 */
	protected Message(final Folder folder, final int msgnum) {
		this.folder = folder;
		this.msgnum = msgnum;
		session = folder.store.session;
	}

	/**
	 * Session 󂯎RXgN^łB
	 * NCAg쐬 Message IuWFNgɂgp܂B
	 * 
	 * @param session Session IuWFNg
	 */
	protected Message(final Session session) {
		this.session = session;
	}

	/**
	 * "From" Ԃ܂B
	 * "From" ́ÃbZ[W𑗐Ml ID ܂݂܂B<p>
	 * 
	 * ꕔ̎ɂāA̓bZ[WۂɑMGeBeBƈقȂ鎖܂B<p>
	 * 
	 * ̑̃bZ[Wɑ݂ȂꍇÃ\bh <code>null</code> Ԃ܂B
	 * ݂̑͑邪AhX͊܂܂ȂꍇA̔zԂ܂B
	 * 
	 * @return Address IuWFNg̔z
	 * @throws MessagingException
	 */
	public abstract Address[] getFrom() throws MessagingException;

	/**
	 *  Message  "From" ݒ肵܂B
	 * ̑̒l̓vpeB "mail.user" 擾܂B
	 * ̃vpeB݂ȂꍇAVXevpeB "user.name" gp܂B
	 * 
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 */
	public abstract void setFrom() throws MessagingException;

	/**
	 *  Message  "From" ݒ肵܂B
	 * 
	 * @param address M
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 */
	public abstract void setFrom(Address address) throws MessagingException;

	/**
	 * ̃AhX "From" ɒǉ܂B
	 * 
	 * @param addresses M
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 * @throws MessagingException
	 */
	public abstract void addFrom(Address[] addresses) throws MessagingException;

	/**
	 * ̓NX́AMessage NXɂ苖M҂̌^`܂B
	 * ݒ`Ă^ TOACCAy BCC łB
	 * 
	 * ̃NX protected RXgN^݂̂ׁA
	 * VK Recipient ̌^NX̓TuNXɐ܂B
	 * ͋ Recipient ̌^̗񋓂ʓIɎ܂B
	 * 
	 * ȉ̃TvR[h́ÃNXgpăbZ[W "TO" M҂擾@܂B
	 * 
	 * <blockquote><pre>
	 * 
	 * Message msg = folder.getMessages(1);
	 * Address[] a = m.getRecipients(Message.RecipientType.TO);
	 * 
	 * </pre></blockquote><p>
	 * 
	 * @see javax.mail.Message#getRecipients
	 * @see javax.mail.Message#setRecipients
	 * @see javax.mail.Message#addRecipients
	 */
	public static class RecipientType implements Serializable {

		private static final long serialVersionUID = 1L;

		/**
		 * "To" (v) M҂łB
		 */
		public static final RecipientType TO = new RecipientType("To");

		/**
		 * "Cc" (ʂ) M҂łB
		 */
		public static final RecipientType CC = new RecipientType("Cc");

		/**
		 * "Bcc" (uChRs[) M҂łB
		 */
		public static final RecipientType BCC = new RecipientType("Bcc");

		/**
		 * M҂̌^łBʏAΉC^[lbgWwb_̖OɂȂ܂B
		 * 
		 * @serial
		 */
		protected String type;

		/**
		 * TuNXɂgpRXgN^łB
		 */
		protected RecipientType(final String type) {
			this.type = type;
		}

		/**
		 * RecipientType ̒񉻂ہÃNXŒ`
		 * m static final CX^XB 1 Ԃۏ؂Kv܂B
		 * TuNX́ÃX[p[\bhĂяoOɁA
		 * m̃CX^X`FbNƎ <code>readResolve</code> \bhȂ΂Ȃ܂B
		 */
		protected Object readResolve() throws ObjectStreamException {
			if (type.equals("To"))
				return TO;
			else if (type.equals("Cc"))
				return CC;
			else if (type.equals("Bcc"))
				return BCC;
			else
				throw new InvalidObjectException("Attempt to resolve unknown RecipientType: " + type);
		}

		public String toString() {
		    return type;
		}

	}

	/**
	 * w肳ꂽ^̑SĂ̎M҃AhX擾܂B<p>
	 * 
	 * w肳ꂽ^̃wb_̃bZ[Wɑ݂ȂꍇA
	 * ̃\bh <code>null</code> Ԃ܂B
	 * wb_݂͑邪AhX܂܂Ȃꍇ́A̔zԂ܂B
	 * 
	 * @param type M҂̌^
	 * @return Address IuWFNg̔z
	 * @throws MessagingException
	 * @see Message.RecipientType#TO
	 * @see Message.RecipientType#CC
	 * @see Message.RecipientType#BCC
	 */
	public abstract Address[] getRecipients(RecipientType type) throws MessagingException;

	/**
	 * bZ[W̑SĂ̎M҃AhX擾܂B
	 * ftHg̎́A<code>getRecipients</code> \bhgpāA
	 * TOACCAy BCC ̊eM҂𒊏o܂B<p>
	 * 
	 * M҃wb_̃bZ[Wɑ݂ȂꍇÃ\bh <code>null</code> Ԃ܂B
	 * M҃wb_݂͑邪AhX܂܂Ȃꍇ́A̔zԂ܂B
	 * 
	 * @return Address IuWFNg̔z
	 * @throws MessagingException
	 * @see Message.RecipientType#TO
	 * @see Message.RecipientType#CC
	 * @see Message.RecipientType#BCC
	 * @see #getRecipients
	 */
	public Address[] getAllRecipients() throws MessagingException {
		Address[] to = getRecipients(RecipientType.TO);
		Address[] cc = getRecipients(RecipientType.CC);
		Address[] bcc = getRecipients(RecipientType.BCC);

		if (cc == null && bcc == null)
			return to;		// ̏ꍇ

		int numRecip = (to != null ? to.length : 0) + (cc != null ? cc.length : 0) + (bcc != null ? bcc.length : 0);
		Address[] addresses = new Address[numRecip];
		int pos = 0;
		if (to != null) {
			System.arraycopy(to, 0, addresses, pos, to.length);
			pos += to.length;
		}
		if (cc != null) {
			System.arraycopy(cc, 0, addresses, pos, cc.length);
			pos += cc.length;
		}
		if (bcc != null) {
			System.arraycopy(bcc, 0, addresses, pos, bcc.length);
			pos += bcc.length;
		}
		return addresses;
	}

	/**
	 * M҃AhXݒ肵܂B
	 * w肳ꂽ^̑SẴAhX́AAhXp[^ɂu܂B
	 * 
	 * @param type M҂̌^
	 * @param addresses AhX
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 */
	public abstract void setRecipients(RecipientType type, Address[] addresses) throws MessagingException;

	/**
	 * M҃AhXݒ肵܂B
	 * w肳ꂽ^̑SẴAhX́AAhXp[^ɂu܂B<p>
	 * 
	 * ftHg̎ <code>setRecipients</code> \bhgp܂B
	 * 
	 * @param type M҂̌^
	 * @param address AhX
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 */
	public final void setRecipient(RecipientType type, Address address) throws MessagingException {
		Address[] a = new Address[1];
		a[0] = address;
		setRecipients(type, a);
	}

	/**
	 * ̎M҃AhXAw肳ꂽ^̊̃AhXɒǉ܂B
	 * 
	 * @param type M҂̌^
	 * @param addresses AhX
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 */
	public abstract void addRecipients(RecipientType type, Address[] addresses) throws MessagingException;

	/**
	 * ̎M҃AhXAw肳ꂽ^̊̃AhXɒǉ܂B<p>
	 * 
	 * ftHg̎ <code>addRecipients</code> \bhgp܂B
	 * 
	 * @param type M҂̌^
	 * @param address AhX
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 */
	public final void addRecipient(final RecipientType type, final Address address) throws MessagingException {
		Address[] a = new Address[1];
		a[0] = address;
		addRecipients(type, a);
	}

	/**
	 * ԐM̑M̃AhX擾܂Bʏ킱̓bZ[W̑MłA
	 * ꕔ̃bZ[W͈قȂAhXɕԐMꍇ܂B<p>
	 * 
	 * ftHg̎͒P <code>getFrom</code> \bhĂяo܂B<p>
	 * 
	 * Ήwb_݂ȂꍇÃ\bh <code>null</code> Ԃ܂B
	 * wb_݂͑邪AhX܂܂Ȃꍇ́A̔zԂ܂B
	 * 
	 * @return ԐM̑M̃AhX
	 * @throws MessagingException
	 * @see #getFrom
	 */
	public Address[] getReplyTo() throws MessagingException {
		return getFrom();
	}

	/**
	 * ԐM̑M̃AhXݒ肵܂ (ʏAAhX 1 w肵܂)B
	 * SẴbZ[W^ŁAbZ[W̑M҈ȊO̎w肪\ł킯ł͂܂B<p>
	 * 
	 * Œ񋟂ftHg̎́AMethodNotSupportedException X[邾łB
	 * 
	 * @param addresses ԐM̑M̃AhX
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 * @throws MethodNotSupportedException ̑̐ݒT|[gȂꍇ 
	 */
	public void setReplyTo(final Address[] addresses) throws MessagingException {
		throw new MethodNotSupportedException("setReplyTo not supported");
	}

	/**
	 * ̃bZ[W̌擾܂B
	 * 
	 * @return 
	 * @throws MessagingException
	 */
	public abstract String getSubject() throws MessagingException;

	/**
	 * ̃bZ[W̌ݒ肵܂B
	 * 
	 * @param subject 
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 */
	public abstract void setSubject(String subject) throws MessagingException;

	/**
	 * ̃bZ[WMꂽt擾܂B
	 * 
	 * @return ̃bZ[WMꂽt
	 * @throws MessagingException
	 */
	public abstract Date getSentDate() throws MessagingException;

	/**
	 * ̃bZ[W̑Mtݒ肵܂B
	 * 
	 * @param date ̃bZ[W̑Mt
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 */
	public abstract void setSentDate(Date date) throws MessagingException;

	/**
	 * ̃bZ[WMꂽt擾܂B
	 * 
	 * @return ̃bZ[WMꂽt
	 * @throws MessagingException
	 */
	public abstract Date getReceivedDate() throws MessagingException;

	/**
	 * ̃bZ[W̃tO܂ <code>Flags</code> IuWFNgԂ܂B<p>
	 * 
	 * Ԃꂽ Flags IuWFNg̃tOύXĂAbZ[Wɂ͔f܂B
	 * bZ[W̃tOύXׂɂ́A<code>setFlags()</code> gĉB<p>
	 * 
	 * @return ̃bZ[W̃tO܂ Flags IuWFNg
	 * @throws MessagingException
	 * @see javax.mail.Flags
	 * @see #setFlags
	 */
	public abstract Flags getFlags() throws MessagingException;

	/**
	 * <code>flag</code> Ɏw肳ꂽtÕbZ[Wɐݒ肳Ă邩ǂ`FbN܂B<p>
	 * 
	 * ftHg̎ <code>getFlags</code> gp܂B
	 * 
	 * @param flag tO
	 * @return ̃bZ[W̎w肳ꂽtO̒l
	 * @throws MessagingException
	 * @see javax.mail.Flags.Flag
	 * @see javax.mail.Flags.Flag#ANSWERED
	 * @see javax.mail.Flags.Flag#DELETED
	 * @see javax.mail.Flags.Flag#DRAFT
	 * @see javax.mail.Flags.Flag#FLAGGED
	 * @see javax.mail.Flags.Flag#RECENT
	 * @see javax.mail.Flags.Flag#SEEN
	 */
	public boolean isSet(final Flags.Flag flag) throws MessagingException {
		return getFlags().contains(flag);
	}

	/**
	 * ̃bZ[W̎w肳ꂽtOAw肳ꂽlɐݒ肵܂B
	 * w肳ꂽ <code>Flags</code> IuWFNgɎw肳ĂȂA
	 * ̃bZ[ŴׂẴtO͉e󂯂܂B<p>
	 * 
	 * ɂA Message ܂ރtH_ɓo^Ă
	 * SĂ MessageChangedListener  <code>MessageChangedEvent</code> zM܂B
	 * 
	 * @param flag ݒ肳tO܂ Flags IuWFNg
	 * @param set ݒ肳l
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 * @see javax.mail.event.MessageChangedEvent
	 */
	public abstract void setFlags(Flags flag, boolean set) throws MessagingException;

	/**
	 * ̃bZ[W̎w肳ꂽtOAw肳ꂽlɐݒ肵܂B
	 * 
	 * ɂA Message ܂ރtH_ɓo^Ă
	 * SĂ MessageChangedListener  <code>MessageChangedEvent</code> zM鎖ɂȂ܂B<p>
	 * 
	 * ftHg̎ <code>setFlags</code> \bhgp܂B
	 * 
	 * @param flag ݒ肳tO܂ Flags IuWFNg
	 * @param set ݒ肳l
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 * @see javax.mail.event.MessageChangedEvent
	 */
	public final void setFlag(final Flags.Flag flag, final boolean set) throws MessagingException {
		Flags f = new Flags(flag);
		setFlags(f, set);
	}

	/**
	 *  Message  Message ԍ擾܂B
	 * Message IuWFNg̃bZ[Wԍ́AFolder ̂ Message ̑ΈʒułB
	 *  Message ̃bZ[Wԍ́AFolder ̑̃bZ[W폜yяꂽꍇA
	 * ZbVɕύX\܂B<p>
	 * 
	 * LȃbZ[Wԍ 1 n܂܂B
	 * ǂ̃tH_ɂȂbZ[W (VK̍쐬͔hꂽbZ[W) ̃bZ[Wԍ 0 łB
	 * 
	 * @return bZ[Wԍ
	 */
	public final int getMessageNumber() {
		return msgnum;
	}

	/**
	 *  Message  Message ԍݒ肵܂B
	 * ̃\bh͎NXɂĂ̂݌Ăяo܂B
	 */
	protected void setMessageNumber(final int msgnum) {
		this.msgnum = msgnum;
	}

	/**
	 * ̃bZ[W擾ꂽtH_擾܂B
	 * ꂪVKbZ[W̓lXgꂽbZ[W̏ꍇA
	 * ̃\bh null Ԃ܂B
	 * 
	 * @return ̃bZ[W܂łtH_
	 */
	public final Folder getFolder() {
		return folder;
	}

	/**
	 * ̃bZ[WĂ邩ǂ`FbN܂B
	 * ꂽ Message IuWFNgł́A
	 * <code>getMessageNumber()</code> SẴ\bhłB<p>
	 * 
	 *  Folder ł̖I <code>expunge()</code> vɂ郁bZ[ẂA
	 *  Folder 폜܂B
	 * ʂ̃\[XOIɏ郁bZ[Wɂ "ς" ̃}[NtA
	 * isExpunged() \bhɑ΂ true Ԃ܂B
	 * AAFolder ŖI <code>expunge()</code> s܂ Folder 폜܂B<p>
	 * 
	 * ̏ڍׂɂĂ <code>expunge()</code> ̐QƂĉB
	 * 
	 * @see Folder#expunge
	 */
	public boolean isExpunged() {
		return expunged;
	}

	/**
	 *  Message ̏ς݃tOݒ肵܂B
	 * ̃\bh͎NXɂĂ̂ݎgp܂B
	 * 
	 * @param expunged ς݃tO
	 */
	protected void setExpunged(final boolean expunged) {
		this.expunged = expunged;
	}

	/**
	 * ̃bZ[W̕ԐMɓKV Message 擾܂B
	 * V Message ̑ƃwb_͓K؂ɐݒ肳܂B
	 * ̐VbZ[WIuWFNg͋A "e" <strong>܂</strong>B
	 * ́ANCAgK؂ɓ͂Kv܂B<p>
	 * 
	 * <code>replyToAll</code>  true ̏ꍇA
	 * V Message ͂̃bZ[W̑SĂ̎M҂ɑ܂B
	 * ȊȌꍇAԐM͂̃bZ[W̑M҂
	 * ܂ (<code>getReplyTo</code> \bh̒lgp)B<p>
	 * 
	 * "Subject" tB[hɂ́Ǎ̑O "Re:" t
	 * ͂܂ (ɐ擪 "Re:" łȂꍇ)B<p>
	 * 
	 * ԐMbZ[W͂̃bZ[WƓZbVgp܂B
	 * 
	 * @param replyToAll ԐM͂̃bZ[W̑SĂ̎M҂ɑMꍇ true
	 * @return ԐM Message
	 * @throws MessagingException
	 */
	public abstract Message reply(boolean replyToAll) throws MessagingException;

	/**
	 * bZ[WtH_Ɋ܂܂ꍇÃtH_ۂɁA
	 * ̃bZ[Wɑ΂SĂ̕ύXbZ[WXgAɕۑ܂B
	 * ꕔ̎ł͕ύX𒼂ɕۑꍇ܂B
	 * ύXꂽbZ[WeɖȂlɑSẴwb_tB[hXV܂B
	 * bZ[W̃wb_͓e̔Cӂ̕ύXꂽꍇ́A
	 * saveChanges ĂяoāA̕ύXۑKv܂B
	 * saveChanges ĂяoȂƁAbZ[WXgAyуtH_ɂāA
	 * ύXۑꂽ肳Ȃ肵܂B<p>
	 * 
	 * READ_ONLY ŊJĂtH_擾ꂽbZ[WύXĂ͂܂B
	 * AbZ[W saveChanges ĂяoĂ͂܂B
	 * 
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ 
	 * @throws IllegalStateException ̃bZ[W READ_ONLY tH_擾ꂽꍇ
	 */
	public abstract void saveChanges() throws MessagingException;

	/**
	 * w肳ꂽ Search ̃bZ[WɓKp܂B
	 * 
	 * @param term Search 
	 * @return Message ̌Ɉvꍇ trueAłȂꍇ false
	 * @throws MessagingException
	 * @see javax.mail.search.SearchTerm
	 */
	public final boolean match(final SearchTerm term) throws MessagingException {
		return term.match(this);
	}

}
