/*
 * Copyright 1998-2001 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

/**
 * 1  Message ̓e܂܂ReLXgłB
 * <code>MessageContext</code> IuWFNǵA<code>MessageAware</code> C^tF[X
 *  <code>getMessageContext</code> \bhɂԂ܂B
 * ʂɁA<code>MessageAware</code>  <code>DataSources</code> ɂA
 * <code>DataContentHandler</code> ́Af[^RecIuWFNg
 * 삵ĂReLXgɊւnƂłlɂȂ܂B
 * 
 * @see javax.mail.MessageAware
 * @see javax.activation.DataSource
 * @see javax.activation.DataContentHandler
 * @since JavaMail 1.1
 */
public final class MessageContext {

	private Part part;

	/**
	 * w肳ꂽ Part ̃ReLXgLq MessageContext IuWFNg쐬܂B
	 */
	public MessageContext(final Part part) {
		this.part = part;
	}

	/**
	 * e܂ Part Ԃ܂B
	 * 
	 * @return ܂ PartBs̏ꍇ null
	 */
	public Part getPart() {
		return part;
	}

	/**
	 * e܂ Message Ԃ܂B܂ Multipart IuWFNgʂāA
	 * Message IuWFNgɎ܂Őẽ`F[H܂B null ɂȂ܂B
	 * 
	 * @return ܂ MessageBs̏ꍇ null
	 */
	public Message getMessage() {
//		try {
			return getMessage(part);
//		} catch (MessagingException ex) {
//			return null;
//		}
	}

	/**
	 * Return the Message containing an arbitrary Part.
	 * Follows the parent chain up through containing Multipart
	 * objects until it comes to a Message object, or null.
	 * 
	 * @return the containing Message, or null if none
	 * @see javax.mail.BodyPart#getParent
	 * @see javax.mail.Multipart#getParent
	 */
	private static Message getMessage(Part p) /* throws MessagingException */ {
		while (p != null) {
			if (p instanceof Message)
				return (Message) p;
			BodyPart bp = (BodyPart) p;
			Multipart mp = bp.getParent();
			if (mp == null)	// MimeBodyPart might not be in a MimeMultipart
				return null;
			p = mp.getParent();
		}
		return null;
	}

	/**
	 * 삵Ă Session Ԃ܂B
	 * 
	 * @return SessionBs̏ꍇ null
	 */
	public Session getSession() {
		Message msg = getMessage();
		return msg != null ? msg.session : null;
	}

}
