/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

/**
 * Messaging NXɂX[SĂ̗O̊NXłB
 */
public class MessagingException extends Exception {

	private static final long serialVersionUID = -7569192289819959253L;

	/**
	 * `F[ꂽ̗OłB
	 *
	 * @serial
	 */
	private Exception next;

	/**
	 * ڍ׃bZ[Ww肵Ȃ MessagingException \z܂B
	 */
	public MessagingException() {
		initCause(null);
	}

	/**
	 * w肳ꂽڍ׃bZ[Wgp MessagingException \z܂B
	 * 
	 * @param s ڍ׃bZ[W
	 */
	public MessagingException(final String s) {
		super(s);
		initCause(null);
	}

	/**
	 * w肳ꂽ Exception Əڍ׃bZ[Wgp MessagingException \z܂B
	 * w肳ꂽO̗͂OɃ`F[܂B
	 * 
	 * @param s ڍ׃bZ[W
	 * @param e ߍ܂ꂽO
	 * @see #getNextException
	 * @see #setNextException
	 */
	public MessagingException(final String s, final Exception e) {
		super(s);
		next = e;
		initCause(null);
	}

	/**
	 * ̗OɃ`F[ꂽ̗O擾܂B
	 * ̗O MessagingException ̏ꍇA
	 * XɎ̃`F[Ăꍇ܂B
	 * 
	 * @return ̗OB݂Ȃꍇ null
	 */
	public synchronized Exception getNextException() {
		return next;
	}

	/**
	 * Overrides the getCause method of Throwable to return the next exception in the chain of nested exceptions.
	 */
	public synchronized Throwable getCause() {
		return next;
	}

	/**
	 * `F[̏I[ɗOǉ܂B
	 * I[ MessagingException <strong>Ȃ</strong>ꍇA
	 * ̗OIɒǉł܂B
	 *
	 * @param ex O`F[̐VI[
	 * @return ̗Oǉꂽꍇ <code>true</code>AłȂꍇ <code>false</code>
	 */
	public synchronized boolean setNextException(final Exception ex) {
		Exception theEnd = this;
		while (theEnd instanceof MessagingException &&
			((MessagingException)theEnd).next != null) {
			theEnd = ((MessagingException)theEnd).next;
		}
		// If the end is a MessagingException, we can add this 
		// exception to the chain.
		if (theEnd instanceof MessagingException) {
			((MessagingException)theEnd).next = ex;
			return true;
		}
		return false;
	}

	/**
	 * Override toString method to provide information on nested exceptions.
	 */
	public synchronized String toString() {
		String s = super.toString();
		Exception n = next;
		if (n == null)
			return s;
		StringBuffer sb = new StringBuffer(s == null ? "" : s);
		while (n != null) {
			sb.append(";\n  nested exception is:\n\t");
			sb.append(n.toString());
			if (n instanceof MessagingException) {
				MessagingException mex = (MessagingException) n;
				n = mex.next;
			} else {
				n = null;
			}
		}

        return sb.toString();
	}

}
