/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

/**
 * Multipart ͕̖{ێReiłB
 * Multipart ̓Tup[goAݒ肷郁\bh񋟂܂B<p>
 * 
 * Multipart ́Awǂ Multipart DataContentHandlers ɂԂ
 * RecIuWFNg̊NXƂĂ@\܂B
 * Ⴆ΁A\[X "multipart/signed" f[^\[Xł DataHandler  getContent() ĂяoƁA
 * Multipart ̓K؂ȃTuNXԂ܂B<p>
 * 
 * ꕔ̃bZ[WOVXéAMultipart ̈قȂTu^Cv񋟂܂B
 * Ⴆ΁AMIME  "alternative"A"mixed"A"related"A"parallel"A
 * "signed" ܂ވÃTu^Cvw肵܂B<p>
 * 
 * Multipart ͒ۃNXłBTuNX͌̎񋟂܂B
 */
public abstract class Multipart {

	/**
	 * BodyPart IuWFNg Vector łB
	 */
	protected Vector parts = new Vector(); // Holds BodyParts

	/**
	 * ̃tB[h́A multipart IuWFNg̃Rec^Cvw肵܂B
	 * ftHg "multipart/mixed" łB
	 */
	protected String contentType = "multipart/mixed" ; // Content-Type

	/**
	 * m̏ꍇA <code>Multipart</code> ܂ <code>Part</code> łB
	 * 
	 * @since JavaMail 1.1
	 */
	protected Part parent;

	/**
	 * ftHg̃RXgN^łB Multipart IuWFNg쐬܂B
	 */
	protected Multipart() {}

	/**
	 * w肳ꂽ MultipartDataSource 炱 Multipart IuWFNgݒ肵܂B<p>
	 * 
	 * ̃\bh́AMultipartDataSource  BodyPart IuWFNg Multipart ɒǉ܂B
	 *  Multipart ̃Rec^Cv́AMultipartDataSource ̃Rec^Cvɐݒ肳܂B<p>
	 * 
	 * ʂɂ̃\bh́Aʂ̖{ɎO͍ς݂
	 * }`p[gf[^\[X (IMAP f[^\[X) 邪A
	 * ̃}`p[gTu^Cv\K؂ Multipart TuNX
	 * 쐬KvꍇɎgp܂B
	 * 
	 * @param mp Multipart f[^\[X
	 */
	protected final void setMultipartDataSource(final MultipartDataSource mp) throws MessagingException {
		contentType = mp.getContentType();

		int count = mp.getCount();
		for (int i = 0; i < count; i++)
			addBodyPart(mp.getBodyPart(i));
	}

	/**
	 *  Multipart ̃Rec^CvԂ܂B<p>
	 * 
	 * ̎ <code>contentType</code> tB[h̒lԂłB
	 * 
	 * @return Rec^Cv
	 * @see #contentType
	 */
	public final String getContentType() {
		return contentType;
	}

	/**
	 * ͂܂ꂽ BodyPart IuWFNg̐Ԃ܂B<p>
	 *
	 * @return p[g̐
	 * @see #parts
	 */
	public int getCount() throws MessagingException {
		if (parts == null)
			return 0;

		return parts.size();
	}

	/**
	 * w肳ꂽ Part 擾܂BPart ɂ 0 n܂ԍt܂B
	 * 
	 * @param index v Part ̃CfbNX
	 * @return Part
	 * @throws IndexOutOfBoundsException w肵CfbNX͈͊Oɂꍇ
	 * @throws MessagingException
	 */
	public BodyPart getBodyPart(final int index) throws MessagingException {
		if (parts == null)
			throw new IndexOutOfBoundsException("No such BodyPart");

		return (BodyPart) parts.elementAt(index);
	}

	/**
	 * }`p[gbZ[WAw肳ꂽ Part 폜܂B
	 * 폜ꂽ Part ȍ~̑SĂ Part  1 Oɂ炵܂B
	 * 
	 * @param part 폜 Part
	 * @return Part 폜ꂽꍇ trueAłȂꍇ false
	 * @throws MessagingException  Part ݂Ȃꍇ
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ
	 */
	public final boolean removeBodyPart(final BodyPart part) throws MessagingException {
		if (parts == null)
			throw new MessagingException("No such body part");

		boolean ret = parts.removeElement(part);
		part.setParent(null);
		return ret;
	}

	/**
	 * w肳ꂽꏊ (0 Jn)  Part 폜܂B
	 * 폜ꂽ Part ȍ~̑SĂ Part  1 Oɂ炵܂B
	 * 
	 * @param index 폜 Part ̃CfbNX
	 * @throws MessagingException
	 * @throws IndexOutOfBoundsException w肵CfbNX͈͊Oɂꍇ
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ
	 */
	public final void removeBodyPart(final int index) throws MessagingException {
		if (parts == null)
			throw new IndexOutOfBoundsException("No such BodyPart");

		BodyPart part = (BodyPart) parts.elementAt(index);
		parts.removeElementAt(index);
		part.setParent(null);
	}

	/**
	 * }`p[g Part ǉ܂B
	 * BodyPart ͊ Part ̈ꗗɒǉ܂B
	 * 
	 * @param part ǉ Part
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ
	 */
	public synchronized void addBodyPart(final BodyPart part) throws MessagingException {
		if (parts == null)
			parts = new Vector();

		parts.addElement(part);
		part.setParent(this);
	}

	/**
	 * <code>index</code> ̈ʒu BodyPart ǉ܂B
	 * <code>index</code> ꗗ̍ŌłȂꍇA㑱 Part  1 ɂ炳܂B
	 * <code>index</code> ݂ Part ̐傫ꍇABodyPart ͏Iɒǉ܂B
	 * 
	 * @param part } BodyPart
	 * @param index Part }ꏊ
	 * @throws MessagingException
	 * @throws IllegalWriteException l̕ύXT|[gȂꍇ
	 */
	public synchronized void addBodyPart(final BodyPart part, final int index) throws MessagingException {
		if (parts == null)
			parts = new Vector();

		parts.insertElementAt(part, index);
		part.setParent(this);
	}

	/**
	 * w肳ꂽ OutputStream ɓK؂ɃGR[hꂽoCgXg[o͂܂B
	 * TuNX́AgpK؂ȃGR[fBOASY肵܂B
	 * ̃oCgXg[͈ʂɑMׂ̈Ɏgp܂B
	 * 
	 * @throws IOException IO ֘A̗Oꍇ
	 * @throws MessagingException
	 */
	public abstract void writeTo(OutputStream os) throws IOException, MessagingException;

	/**
	 *  <code>Multipart</code> IuWFNg܂ <code>Part</code> Ԃ܂B
	 * sȏꍇ <code>null</code> Ԃ܂B
	 * 
	 * @since JavaMail 1.1
	 */
	public final Part getParent() {
		return parent;
	}

	/**
	 * w肳ꂽ <code>Part</code> A <code>Multipart</code> ̐eƂĐݒ肵܂B
	 * ʏA<code>Message</code>  <code>BodyPart</code>  <code>setContent(Multipart)</code> \bhɂĂяo܂B
	 * <code>Multipart</code> ܂ <code>Part</code> 폜ĂꍇA
	 * <code>parent</code>  <code>null</code> ɂȂ邱Ƃ܂B
	 * 
	 * @since JavaMail 1.1
	 */
	public final void setParent(final Part parent) {
		this.parent = parent;
	}

}
