/*
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

import javax.activation.DataHandler;

/**
 * <code>Part</code> C^tF[X́AMessage y BodyPart ̋ʊ{C^tF[XłB<p>
 * 
 * Part ͈Ȃ "Rec" ō\܂B<p>
 * 
 * <strong> : </strong> <p>
 * 
 * JavaMail API ́A̖wǂ̃[VXeɋʂƍlA̕WI Part `܂B
 * ̑́AŗL̐ݒ胁\bhyю擾\bhĂ܂B
 * [VXe͑ Part T|[g鎖\ŁA
 *  String ł閼Oyђl̑΂ŕ\܂B<p>
 * 
 * <strong> Rec: </strong> <p>
 * 
 * "Rec"  <strong>data type</strong> ́A<code>getContentType()</code> \bhɂԂ܂B
 * MIME ^tVXegpāAf[^^̖Oݒ肵܂B<p>
 * 
 * Part  "Rec" ͈ȉ̗lɗlXȌ`Ŏgp\łB
 * <ul>
 * <li> DataHandler Ƃ - <code>getDataHandler()</code> \bhgpB
 * Part  "content"  <code>javax.activation.DataHandler</code> IuWFNgoRłgp\łB
 * DataHandler IuWFNgɂANCAg̓RecŎgp\ȑA
 * K؂ȃR|[lgCX^XĂ̑sł܂B
 * 
 * <li> ̓Xg[Ƃ - <code>getInputStream()</code> \bhgpB
 * ̃Xg[ԂOɁASẴ[ŗL̃GR[fBOfR[h܂B
 * 
 * <li> Java IuWFNgƂ - <code>getContent()</code> \bhgpB
 * ̃\bh "Rec"  Java IuWFNgƂĕԂ܂B
 * ԂIuWFNg͂RecgɂقȂ܂B
 * ɁA"}`p[g" Part ̃Rec͏ Multipart ͂̃TuNXłB
 * ܂A"}`p[g" ^ Part  <code>getContent()</code> 
 *  Multipart (̓TuNX) IuWFNgԂ܂B
 * </ul>
 * 
 * Part ́AoCgXg[`ɓK[S`ŏo͂ <code>writeTo()</code> \bh񋟂܂B
 * ̃oCgXg[͈ʂ Part Ƃ̃Rec̃oCgXg[̏WłB<p>
 * 
 * Message y BodyPart  Part C^tF[X܂B
 * MIME pł́APart  Entity f܂ (RFC 2045ASection 2.4)B
 */
public interface Part {

	/**
	 *  Part ̃RecTCYoCgPʂŕԂ܂B
	 * TCYs̏ꍇ -1 Ԃ܂B<p>
	 * 
	 * ̃TCY̓RecTCY̐mȑlłȂꍇA
	 * Rec̔Cӂ̓]GR[fBOꍇȂꍇ܂B
	 * ̃TCÝA[Uɑ΂Ă Part ̃TCYɊւTvm点ׂɁA
	 * [UC^tF[Xŕ\̂ɓKĂ܂B
	 * 
	 * @return Rec̃TCY (oCg)
	 * @throws MessagingException
	 */
	public int getSize() throws MessagingException;

	/**
	 *  Part ̃RecɊ܂܂sԂ܂B
	 * s̏ꍇ -1 Ԃ܂B<p>
	 * 
	 * ̐̓Rec̐mȑlłȂꍇA
	 * Rec̓]GR[fBOꍇȂꍇ܂B
	 * 
	 * @return Rec̍s
	 * @throws MessagingException
	 */
	public int getLineCount() throws MessagingException;

	/**
	 *  Part ̃Rec Content-Type Ԃ܂B
	 * Content-Type s̏ꍇ null Ԃ܂B<p>
	 * 
	 * MIME ^tVXegpāAContent-type ̖Oݒ肵܂B
	 * 
	 * @return  Part  ContentType
	 * @throws MessagingException
	 * @see javax.activation.DataHandler
	 */
	public String getContentType() throws MessagingException;

	/**
	 * w肳ꂽ MIME ^Cv Part ǂ𔻒肵܂B
	 * ̃\bh́A<strong><code>primaryType</code>  <code>subType</code> ݂̂r܂</strong>B
	 * Rec`̃p[^͖܂B<p>
	 * 
	 * Ⴆ΁ARec` <strong>"text/plain"</strong>  <strong>"text/plain; charset=Shift_JIS"</strong> rƁA
	 * ̃\bh <code>true</code> Ԃ܂B<p>
	 * 
	 * <code>mimeType</code>  <code>subType</code> ꕶ '*' ̏ꍇA
	 * rɃTu^Cv͖܂B
	 */
	public boolean isMimeType(String mimeType) throws MessagingException;

	/**
	 *  Part ͓YtƂĕ\Ȃ΂Ȃ܂B
	 * 
	 * @see #getDisposition
	 * @see #setDisposition
	 */
	public static final String ATTACHMENT = "attachment";

	/**
	 *  Part ̓CCŕ\Ȃ΂Ȃ܂B
	 * 
	 * @see #getDisposition
	 * @see #setDisposition
	 */
	public static final String INLINE = "inline";

	/**
	 *  Part ̏uԂ܂Bu͂ Part [U
	 * ǂ̗lɒ񎦂邩܂ (RFC 2183 Q)B
	 * ߂l͑啶Əʂ܂Bȉɗ܂B<p>
	 * <blockquote><pre>
	 * String disp = part.getDisposition();
	 * if (disp == null || disp.equalsIgnoreCase(Part.ATTACHMENT))
	 *	// treat as attachment if not first part
	 * </pre></blockquote>
	 * 
	 * @return  Part ̏uA͕s̏ꍇ null
	 * @throws MessagingException
	 * @see #ATTACHMENT
	 * @see #INLINE
	 * @see #getFileName
	 */
	public String getDisposition() throws MessagingException;

	/**
	 *  Part ̏uݒ肵܂B
	 * 
	 * @param disposition  Part ̏u
	 * @throws MessagingException
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 * @see #ATTACHMENT
	 * @see #INLINE
	 * @see #setFileName
	 */
	public void setDisposition(String disposition) throws MessagingException;

	/**
	 *  Part ̐ String Ԃ܂B
	 * ͈ʂɐIȏ Part Ɋ֘At܂B
	 * gp\ȕȂꍇ null Ԃ܂B
	 * 
	 * @return  Part ̐
	 * @throws MessagingException
	 */
	public String getDescription() throws MessagingException;

	/**
	 *  Part ̐ String ݒ肵܂B
	 * ͈ʂɐIȏ Part Ɋ֘At܂B
	 * 
	 * @param description  Part ̐
	 * @throws MessagingException
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void setDescription(String description) throws MessagingException;

	/**
	 * \ȏꍇA Part Ɋ֘Atꂽt@C擾܂B
	 *  Part t@Cǂݍ܂ꂽ "Yt" \ꍇɖ𗧂܂B
	 * ̃t@C͒ʏAfBNg܂܂ȂPȖOłB
	 * 
	 * @return  Part Ɋ֘Att@C
	 */
	public String getFileName() throws MessagingException;

	/**
	 * \ȏꍇA Part Ɋ֘Atꂽt@Cݒ肵܂B
	 *  Part t@Cǂݍ܂ꂽ "Yt" \ꍇɖ𗧂܂B
	 * ̃t@C͒ʏAfBNg܂܂ȂPȖOłB
	 * 
	 * @param filename  Part Ɋ֘Att@C
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void setFileName(String filename) throws MessagingException;

	/**
	 *  Part  "content" ̓̓Xg[Ԃ܂B
	 * ̓Xg[񋟂OɁASẴ[ŗL̓]GR[fBO̓fR[h܂B<p>
	 * 
	 * ͈ʂ DataHandler  <code>getInputStream()</code> \bhĂяo̊ȈՃ\bhłB
	 * 
	 * @return InputStream
	 * @throws IOException ͒ʏ DataHandler ɂX[܂B
	 * ڍׂɂĂ javax.activation.DataHandler ̐QƂĉB 
	 * @throws MessagingException
	 * @see #getDataHandler
	 * @see javax.activation.DataHandler#getInputStream
	 */
	public InputStream getInputStream() throws IOException, MessagingException;

	/**
	 *  Part Ɋ܂܂Rec DataHandler Ԃ܂B
	 * DataHandler ɂANCAg̓Rec̎擾Ƒ삪ł܂B
	 * 
	 * @return Rec DataHandler
	 * @throws MessagingException
	 */
	public DataHandler getDataHandler() throws MessagingException;

	/**
	 * Rec java IuWFNgƂĕԂ܂B
	 * ԂIuWFNg̃^Cv͂Reĉ̂Ɉˑ܂B
	 * Ⴆ΁A"text/plain" Recɑ΂ĕԂIuWFNg͕ String IuWFNgłB
	 * "multipart" Recɑ΂ĕԂIuWFNg͏ Multipart ̃TuNXłB
	 * DataHandler VXeɕsȃRec`̏ꍇA
	 * ̓Xg[RecƂĕԂ܂B<p>
	 * 
	 *  DataHandler  getContent() \bhĂяo̊ȈՃ\bhłB
	 * 
	 * @return IuWFNg
	 * @throws MessagingException
	 * @throws IOException ͒ʏ DataHandler ɂX[܂B
	 * ڍׂɂĂ javax.activation.DataHandler ̐QƂĉB 
	 * @see javax.activation.DataHandler#getContent
	 */
	public Object getContent() throws IOException, MessagingException;

	/**
	 * ̃\bh͂ Part ̓eݒ肷ׂ̎dg݂񋟂܂B
	 * DataHandler ͎ۂ̃Recbv܂B
	 * 
	 * @param dh Rec DataHandler
	 * @throws MessagingException
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void setDataHandler(DataHandler dh) throws MessagingException;

	/**
	 *  Part ̃Recݒ肷ׂ̊ȈՃ\bhłB
	 *  Part ͓I DataHandler ̃Recbv܂B<p>
	 * 
	 * ꂪ@\ׂɁAw肳ꂽ^Cv DataContentHandler NX́A
	 * JavaMail ɑ΂Ďgp\łȂ΂Ȃ܂B
	 * ܂A<code>setContent(foobar, "application/x-foobar")</code> sׂɂ́A
	 * "application/x-foobar"  DataContentHandler CXg[ĂKv܂B
	 * ڍׂɂĂ Java Activation Framework QƂĉB
	 * 
	 * @param obj Java IuWFNg
	 * @param type ̃IuWFNg MIME ^Cv
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void setContent(Object obj, String type) throws MessagingException;

	/**
	 * MIME ^Cv "text/plain" gpāA
	 * w肳ꂽ String  Part ̃RecƂĐݒ肷ȈՃ\bhłB
	 * 
	 * @param text Message ̃RecłeLXg
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void setText(String text) throws MessagingException;

	/**
	 * ̃\bh́Aw肳ꂽ Multipart IuWFNg̃bZ[W̃RecƂĐݒ肵܂B
	 * 
	 * @param mp Message ̃Recɂ multipart IuWFNg
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void setContent(Multipart mp) throws MessagingException;

	/**
	 *  Part ̃oCgXg[o͂܂B
	 * ̃oCgXg[͈ʂ Part  'Rec' 
	 * K؂ɃGR[hꂽoCgXg[̏WłB<p>
	 * 
	 * Part C^tF[XNX́A
	 * gpK؂ȃGR[fBOASY肵܂B<p>
	 * 
	 * ̃oCgXg[͈ʂɑMׂ̈Ɏgp܂B
	 * 
	 * @throws IOException Xg[ւ̏ݒɃG[ꍇA
	 *  javax.activation CɂG[ꍇ 
	 * @throws MessagingException ܂f[^oɃG[ꍇ
	 * @see javax.activation.DataHandler#writeTo
	 */
	public void writeTo(OutputStream os) throws IOException, MessagingException;

	/**
	 * ̃wb_̑SẴwb_擾܂B
	 * ̃wb_Ŏgp\ȃwb_Ȃꍇ <code>null</code> Ԃ܂B
	 * 
	 * @param header_name ̃wb_̖O
	 * @return ̖OׂẴwb_ɑ΂ltB[h 
	 * @throws MessagingException
	 */
	public String[] getHeader(String header_name) throws MessagingException;

	/**
	 *  header_name ̒lݒ肵܂B̑SẴwb_l̒lŒu܂B
	 * 
	 * @param header_name ̃wb_̖O
	 * @param header_value ̃wb_̒l
	 * @throws MessagingException
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void setHeader(String header_name, String header_value) throws MessagingException;

	/**
	 * ̒l header_name ̊lɒǉ܂B
	 * 
	 * @param header_name ̃wb_̖O
	 * @param header_value ̃wb_̒l
	 * @throws MessagingException
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void addHeader(String header_name, String header_value) throws MessagingException;

	/**
	 * ̖OSẴwb_폜܂B
	 * 
	 * @param header_name ̃wb_̖O
	 * @throws MessagingException
	 * @throws IllegalWriteException ̃wb_̕ύXT|[gȂꍇ
	 * @throws IllegalStateException  Part  READ_ONLY tH_擾ꂽꍇ
	 */
	public void removeHeader(String header_name) throws MessagingException;

	/**
	 *  Part ̑SẴwb_ Header IuWFNg Enumeration ƂĕԂ܂B
	 * 
	 * @return Header IuWFNg̔z
	 * @throws MessagingException
	 */
	public Enumeration getAllHeaders() throws MessagingException;

	/**
	 *  Part ̈vwb_ Header IuWFNg Enumeration ƂĕԂ܂B
	 * 
	 * @return Header IuWFNg̔z
	 * @throws MessagingException
	 */
	public Enumeration getMatchingHeaders(String[] header_names) throws MessagingException;

	/**
	 * ̃Gx[v̈vȂwb_ Header IuWFNg Enumeration ƂĕԂ܂B
	 * 
	 * @return Header IuWFNg̔z
	 * @throws MessagingException
	 */
	public Enumeration getNonMatchingHeaders(String[] header_names) throws MessagingException;

}
