/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

/**
 * Provider ̓vgRNXłB
 * l javamail.providers y javamail.default.providers \[Xt@C擾܂B
 */
public final class Provider {

	/**
	 * ̓NX Provider ^Cv`܂B
	 * ݃T|[gĂvoC_̃^Cv STORE  TRANSPORT  2 łB
	 */
	public static class Type {

		public static final Type STORE     = new Type("STORE");
		public static final Type TRANSPORT = new Type("TRANSPORT");

		private String type;

		private Type(final String type) {
			this.type = type;
		}

		public String toString() {
			return type;
		}

	}

	private Type type;
	private String protocol, className, vendor, version;

	/**
	 * Package-private constructor for the Provider class.
	 * 
	 * @param type Type.STORE  Type.TRANSPORT
	 * @param protocol valid protocol for the type
	 * @param classname class name that implements this protocol
	 * @param vendor optional string identifying the vendor (may be null)
	 * @param version optional implementation version string (may be null)
	 */
	public Provider(final Type type, final String protocol, final String classname, final String vendor, final String version) {
		this.type = type;
		this.protocol = protocol;
		this.className = classname;
		this.vendor = vendor;
		this.version = version;
	}

	/**
	 *  Provider ̃^CvԂ܂B
	 */
	public Type getType() {
		return type;
	}

	/**
	 *  Provider T|[gvgRԂ܂B
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * vgRNX̖OԂ܂B
	 */
	public String getClassName() {
		return className;
	}

	/**
	 * ̎Ɋ֘Atꂽx_[ null Ԃ܂B
	 */
	public String getVendor() {
		return vendor;
	}

	/**
	 * ̎̃o[WAo[WȂꍇ null Ԃ܂B
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * Object.toString() I[o[Ch܂B
	 */
	public String toString() {
		String s = "javax.mail.Provider[" + type + "," + protocol + "," + className;

		if (vendor != null)
			s += ',' + vendor;

		if (version != null)
			s += ',' + version;

		s += ']';
		return s;
	}

}
