/*
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

/**
 * This class represents a set of quotas for a given quota root.
 * Each quota root has a set of resources, represented by the
 * <code>Quota.Resource</code> class.  Each resource has a name
 * (for example, "STORAGE"), a current usage, and a usage limit.
 * See RFC 2087.
 * 
 * @since JavaMail 1.4
 */
public class Quota {

	/**
	 * NI[^[ǧX̃\[X\܂B
	 * 
	 * @since JavaMail 1.4
	 */
	public static class Resource {

		/**
		 * \[X̖OłB
		 */
		public String name;

		/**
		 * \[X̎gpʂłB
		 */
		public long usage;

		/**
		 * \[X̎gpʃ~bgłB
		 */
		public long limit;

		/**
		 * w肳ꂽ nameAusageAlimit  Resource IuWFNg\z܂B
		 *
		 * @param name \[X
		 * @param usage \[X̎gp
		 * @param limit \[X̎gpʃ~bg
		 */
		public Resource(final String name, final long usage, final long limit) {
			this.name = name;
			this.usage = usage;
			this.limit = limit;
		}
	}

	/**
	 * NI[^[g̖OłB
	 */
	public String quotaRoot;

	/**
	 * \[X̃Zbg͂̃NI[^[gƊ֘At܂B
	 */
	public Resource[] resources;

	/**
	 * ֘A\[XȂŎw肳ꂽNI[^[g Quota IuWFNg\z܂B
	 * 
	 * @param quotaRoot NI[^[g̖O
	 */
	public Quota(final String quotaRoot) {
		this.quotaRoot = quotaRoot;
	}

	/**
	 * ̃NI[^[g̃\[X~bgݒ肵܂B
	 * 
	 * @param name \[X̖O
	 * @param limit \[X~bg
	 */
	public void setResourceLimit(final String name, final long limit) {
		if (resources == null) {
			resources = new Resource[1];
			resources[0] = new Resource(name, 0, limit);
			return;
		}

		for (int i = 0; i < resources.length; i++)
			if(resources[i].name.equalsIgnoreCase(name)) {
				resources[i].limit = limit;
				return;
			}

		Resource[] resources = new Resource[this.resources.length + 1];
		System.arraycopy(this.resources, 0, resources, 0, this.resources.length);
		resources[resources.length - 1] = new Resource(name, 0, limit);
		this.resources = resources;
	}

}
