/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

/**
 * ̗O̓bZ[WMs\ȏꍇɃX[܂B<p>
 * 
 * ̗ÓAMłȂAhX̑ɁA
 * MꂽLȃAhXƗLMȂAhX܂݂܂B
 * 
 * @see	javax.mail.Transport#send
 * @see	javax.mail.Transport#sendMessage
 * @see	javax.mail.event.TransportEvent
 */
public class SendFailedException extends MessagingException {

	private static final long serialVersionUID = -6457531621682372913L;

	protected transient Address[] invalid;
	protected transient Address[] validSent;
	protected transient Address[] validUnsent;

	/**
	 * ڍ׃bZ[WȂ SendFailedException \z܂B
	 */
	public SendFailedException() {
		super();
	}

	/**
	 * w肳ꂽڍ׃bZ[Wgp SendFailedException \z܂B
	 * 
	 * @param s ڍ׃bZ[W
	 */
	public SendFailedException(String s) {
		super(s);
	}

	/**
	 * w肳ꂽ Exception Əڍ׃bZ[Wgp SendFailedException \z܂B
	 * w肳ꂽO̗͂OɃ`F[܂B
	 * 
	 * @param s ڍ׃bZ[W
	 * @param e ߍ܂ꂽO
	 * @see #getNextException
	 * @see #setNextException
	 */
	public SendFailedException(final String s, final Exception e) {
		super(s, e);
	}

	/**
	 * w肳ꂽƎw肳ꂽAhXIuWFNggp SendFailedException \z܂B
	 * 
	 * @param msg ڍ׃bZ[W
	 * @param ex ߍ܂ꂽO
	 * @param validSent bZ[WMꂽLȃAhX
	 * @param validUnsent bZ[WMȂLȃAhX
	 * @param invalid ȃAhX
	 * @see #getNextException
	 * @see #setNextException
	 */
	public SendFailedException(
		final String msg,
		final Exception ex,
		final Address[] validSent, 
		final Address[] validUnsent,
		final Address[] invalid) {

		super(msg, ex);
		this.validSent = validSent;
		this.validUnsent = validUnsent;
		this.invalid = invalid;
	}

	/**
	 * ̃bZ[WɑMꂽAhXԂ܂B
	 * 
	 * @return bZ[WɑMꂽAhX܂ null
	 */
	public Address[] getValidSentAddresses() {
		return validSent;
	}

	/**
	 * Lł邪AbZ[WMȂAhXԂ܂B
	 * 
	 * @return Lł邪AbZ[WɑMȂAhXA܂ null 
	 */
	public Address[] getValidUnsentAddresses() {
		return validUnsent;
	}

	/**
	 * ̃bZ[WɑMłȂAhXԂ܂B
	 * 
	 * @return bZ[WɑMȂAhX܂ null
	 */
	public Address[] getInvalidAddresses() {
		return invalid;
	}

}
