/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.MailEvent;

/**
 * XgAgX|[gƂbZ[WOT[rX
 * ʂ̋@\܂ abstract NXłB<p>
 * bZ[WOT[rX <code>Session</code> 쐬A
 * <code>URLName</code> gpĖOt܂B
 * T[rX͎gpOɐڑȂ΂Ȃ܂B
 * ڑCxgMAڑԂ𔽉f܂B
 * 
 */
public abstract class Service {

	/**
	 * ̃T[rX쐬ꂽZbVłB
	 */
	protected Session session;

	/**
	 * ̃T[rX <code>URLName</code> łB
	 */
	protected URLName url = null;

	/**
	 * ̃T[rX̃fobOtOłB
	 * ̃T[rX쐬鎞ɁAZbṼfobOtOݒ肳܂B
	 */
	protected boolean	debug = false;

	private boolean connected = false;
	private Vector connectionListeners = null;

	/**
	 * RXgN^łB
	 * 
	 * @param session ̃T[rX Session IuWFNg
	 * @param urlname ̃T[rXɎgp URLName IuWFNg
	 */
	protected Service(final Session session, final URLName urlname) {
		this.session = session;
		url = urlname;
		debug = session.getDebug();
	}

	/**
	 * p[^ 1 󂯎ȂėpIȐڑ\bhB
	 * TuNX͓K؂ȔF؃XL[}ł܂B
	 * ǉKvƂTuNXɂẮÃvpeBgp邩A
	 * ̓|bvAbvEBhEgpđΘb^Œǉ擾鎖ɂȂ܂B<p>
	 * 
	 * ڑIƁÃT[rX̑SĂ <code>ConnectionListener</code> 
	 *  "open" <code>ConnectionEvent</code> zM܂B<p>
	 * 
	 * wǂ̃NCAg͒Pɂ̃\bhĂяoAT[rXɐڑȂ΂Ȃ܂B<p>
	 * 
	 * ɐڑς݂̃T[rXɐڑƃG[ɂȂ܂B<p>
	 * 
	 * Œ񋟂́APɎ <code>connect(String, String, String)</code> 
	 * \bh null ƋɌĂяołB
	 * 
	 * @throws AuthenticationFailedException F؂̏Q̏ꍇ
	 * @throws MessagingException ̏Q̏ꍇ
	 * @throws IllegalStateException ̃T[rXłɐڑĂꍇ
	 * @see javax.mail.event.ConnectionEvent
	 */
	public void connect() throws MessagingException {
		connect(null, null, null);
	}

	/**
	 * w肳ꂽAhXɐڑ܂B
	 * ̃\bh̓[UƃpX[hvPȔF؃XL[}񋟂܂B<p>
	 * 
	 * ڑIƁÃT[rX̑SĂ <code>ConnectionListener</code> 
	 *  "open"  <code>ConnectionEvent</code> zM܂B<p>
	 * 
	 * ɐڑς݂̃T[rXɐڑƃG[ɂȂ܂B<p>
	 * 
	 * Service NXɂ́AzXgA[UAyуpX[h̃ftHgZbVA
	 * ̃T[rX <code>URLName</code>Ayђ񋟂p[^WA
	 * <code>protocolConnect</code> \bhĂяo܂B
	 * <code>protocolConnect</code> \bh <code>false</code> ԂꍇA
	 * [Uɂ͕s̓͗v\A<code>protocolConnect</code> \bhĂьĂяo܂B
	 * TuNX <code>protocolConnect</code> \bhI[o[ChȂ΂Ȃ܂B
	 * ATuNX <code>getURLName</code> \bh邩A
	 * ̃NX̎gpȂ΂Ȃ܂B<p>
	 * 
	 * ڑƁApX[hAڑ쐬Ɏgpꂽ܂
	 *  URLName Ƌ <code>setURLName</code> \bhĂяo܂B<p>
	 * 
	 * npX[h null ŁAꂪ̃T[rXɂčŏɐڑ̏ꍇA
	 * [UWꂽ[UƃpX[h́A㑼 Service IuWFNgCX^X
	 * gpĂ̓T[rXɐڑsꍇ̃ftHgƂĕۑ܂
	 *  (ڑ͒ʏAɓ Service IuWFNgCX^Xɕۑ܂)B
	 * pX[h Session \bh <code>setPasswordAuthenticaiton</code> gpĕۑ܂B
	 * npX[h null łȂꍇAAvP[VpX[h𖾎IɊǗĂƂOŁA
	 * ̃pX[h͕ۑ܂B
	 * 
	 * @param host ڑ̃zXg
	 * @param user [U
	 * @param password [ŨpX[h
	 * @throws AuthenticationFailedException F؂̏Q̏ꍇ
	 * @throws MessagingException ̏Q̏ꍇ
	 * @throws IllegalStateException ̃T[rXɐڑĂꍇ
	 * @see javax.mail.event.ConnectionEvent
	 * @see javax.mail.Session#setPasswordAuthentication
	 */
	public void connect(final String host, final String user, final String password) throws MessagingException {
		connect(host, -1, user, password);
	}

	/**
	 * Connect to the current host using the specified username and password.
	 * This method is equivalent to calling the connect(host, user, password) method with null for the host name.
	 * 
	 * @param user [U
	 * @param password [ŨpX[h
	 * @throws AuthenticationFailedException F؂̏Q̏ꍇ
	 * @throws MessagingException ̏Q̏ꍇ
	 * @throws IllegalStateException ̃T[rXɐڑĂꍇ
	 * @since JavaMail 1.4
	 * @see javax.mail.event.ConnectionEvent
	 * @see javax.mail.Session#setPasswordAuthentication
	 * @see javax.mail.Service#connect(String, String, String)
	 */
	public void connect(String user, String password) throws MessagingException {
		connect(null, user, password);
	}

	/**
	 * ̃|[gw\ł_A
	 * connect(host, user, password) ƓłB
	 * 
	 * @param host ڑ̃zXg
	 * @param port ڑ̃|[g (-1 ̓ftHg̃|[gӖ)
	 * @param user [U
	 * @param password [ŨpX[h
	 * @throws AuthenticationFailedException F؂̏Q̏ꍇ
	 * @throws MessagingException ̏Q̏ꍇ
	 * @throws IllegalStateException ̃T[rXɐڑĂꍇ
	 * @see #connect(java.lang.String, java.lang.String, java.lang.String)
	 * @see javax.mail.event.ConnectionEvent
	 */
	public void connect(String host, int port, String user, String password) throws MessagingException {
		// see if the service is already connected
		if (isConnected())
			throw new IllegalStateException("already connected");

		PasswordAuthentication pw;
		boolean connected = false;
		boolean save = false;
		String protocol = null;
		String file = null;

		// get whatever information we can from the URL
		// XXX - url should always be non-null here, Session
		//       passes it into the constructor
		if (url != null) {
			protocol = url.getProtocol();
			if (host == null)
				host = url.getHost();
			if (port == -1)
				port = url.getPort();

			if (user == null) {
				user = url.getUsername();
				if (password == null)	// get password too if we need it
					password = url.getPassword();
			} else {
				if (password == null && user.equals(url.getUsername()))
					// only get the password if it matches the username
					password = url.getPassword();
			}

			file = url.getFile();
		}

		// try to get protocol-specific default properties
		if (protocol != null) {
			if (host == null)
				host = session.getProperty("mail." + protocol + ".host");
			if (user == null)
				user = session.getProperty("mail." + protocol + ".user");
		}

		// try to get mail-wide default properties
		if (host == null)
			host = session.getProperty("mail.host");

		if (user == null)
			user = session.getProperty("mail.user");

		// try using the system username
		if (user == null) {
			try {
				user = System.getProperty("user.name");
			} catch (SecurityException sex) {
				if (debug)
					sex.printStackTrace(session.getDebugOut());
			}
		}

		// if we don't have a password, look for saved authentication info
		if (password == null && url != null) {
			// canonicalize the URLName
			setURLName(new URLName(protocol, host, port, file, user, password));
			pw = session.getPasswordAuthentication(getURLName());
			if (pw != null) {
				if (user == null) {
					user = pw.getUserName();
					password = pw.getPassword();
				} else if (user.equals(pw.getUserName())) {
					password = pw.getPassword();
				}
			} else
				save = true;
		}

		// try connecting, if the protocol needs some missing
		// information (user, password) it will not connect.
		// if it tries to connect and fails, remember why for later.
		AuthenticationFailedException authEx = null;
		try {
			connected = protocolConnect(host, port, user, password);
		} catch (AuthenticationFailedException ex) {
			authEx = ex;
		}

		// if not connected, ask the user and try again
		if (!connected) {
			InetAddress addr;
			try {
				addr = InetAddress.getByName(host);
			} catch (UnknownHostException e) {
				addr = null;
			}
			pw = session.requestPasswordAuthentication(addr, port, protocol, null, user);
			if (pw != null) {
				user = pw.getUserName();
				password = pw.getPassword();
				// have the service connect again
				connected = protocolConnect(host, port, user, password);
			}
		}

		// if we're not connected by now, we give up
		if (!connected) {
			if (authEx != null)
				throw authEx;
			throw new AuthenticationFailedException();
		}

		setURLName(new URLName(protocol, host, port, file, user, password));

		if (save)
			session.setPasswordAuthentication(getURLName(), new PasswordAuthentication(user, password));

		// set our connected state
		setConnected(true);

		// finally, deliver the connection event
		notifyConnectionListeners(ConnectionEvent.OPENED);
	}

	/**
	 * T[rX͂̃\bhI[o[ChA
	 * ۂ̃vgRŗL̐ڑsȂ΂Ȃ܂B
	 * <code>connect</code> \bh̃ftHg̎́A
	 * KvɉẴ\bhĂяo܂B<p>
	 * 
	 * F؂ׂ̈Ƀ[U܂̓pX[hKvA
	 * Ήp[^ null ̏ꍇA<code>protocolConnect</code>
	 *  \bh <code>false</code> ԂȂ΂Ȃ܂B
	 * <code>connect</code> \bh͕Kvɉă[Uɓ͂vA
	 * s܂B
	 * Aꂽ[U̓pX[ḧׂɔF؂sꍇA
	 * ̃\bh false ԂƂ܂B
	 * F؂̏QɁÃ\bh AuthenticationFailedException X[鎖܂B
	 * ̗Oɂ́AQɊւڍ׋Lq String bZ[W܂܂鎖܂B<p>
	 * 
	 * <code>protocolConnect</code> \bh͗OX[A
	 * F؂Ɋ֘AȂQ񍐂Ȃ΂Ȃ܂B
	 * ƂāAȃzXg̓|[gԍAF؏̐ڑؒfA
	 * T[o̒~܂B
	 * 
	 * @param host ڑ̃zXg
	 * @param port gp|[g (-1 ̓ftHg|[g̎gpӖ)
	 * @param user OC郆[U
	 * @param password [ŨpX[h
	 * @return ڑꍇ trueAF؂sꍇ false
	 * @throws AuthenticationFailedException F؂̏Q̏ꍇ
	 * @throws MessagingException F؈ȊȌQ̏ꍇ
	 */
	protected boolean protocolConnect(
		final String host,
		final int port,
		final String user,
		final String password)
		throws MessagingException {

		return false;
	}

	/**
	 * T[rX̐ڑԂԂ܂B<p>
	 * 
	 * ̎ private  boolean tB[hgpāAڑԂi[܂B
	 * ̃\bh͂̃tB[h̒lԂ܂B<p>
	 * 
	 * TuNX͂̃\bhI[o[ChA
	 * SẴbZ[WXgAւ̐ڑmF܂B
	 * 
	 * @return T[rXڑĂꍇ trueAڑĂȂꍇ false
	 */
	public boolean isConnected() {
		return connected;
	}

	/**
	 * ̃T[rX̐ڑԂݒ肵܂BڑԂ́A
	 * <code>connect</code> y <code>close</code> \bhŁA
	 * T[rXɂ莩Iɐݒ肳܂B
	 * T[rXIɐؒfꂽꍇATuNX͂̃\bhĂяoāA
	 * Ԃݒ肷Kv܂B<p>
	 * 
	 * ̃NXɂ́A<code>isConnected</code> \bh
	 * ɂԂ privatetB[hPɐݒ肷邾łB
	 * 
	 * @param connected T[rXڑĂꍇ trueAڑĂȂꍇ false
	 */
	protected void setConnected(final boolean connected) {
		this.connected = connected;
	}

	/**
	 * ̃T[rXAڑI܂B
	 * N[Y ConnectionEvent ͑SĂ ConnectionListener ɔzM܂B
	 * ̃T[rXɑSĂ Messaging R|[lg (FolderAMessage ) ́A
	 * ̃T[rX㖳ɂȂ܂B
	 * ̃\bh MessagingException ̃X[ɂُIꍇłA
	 * ̃T[rX͕܂B<p>
	 * 
	 * ̎ <code>setConnected(false)</code> gpāA
	 * ̃T[rX̐ڑԂ <code>false</code> ɐݒ肵܂B
	 * ̌AN[Y ConnectionEvent SĂ̓o^ς ConnectionListener ɑM܂B
	 * ŗL̏Isׂɂ̃\bhI[o[ChTuNX́A
	 * Ō̎菇ƂẴ\bhĂяoACxgʒmmɂȂ΂Ȃ܂B
	 * 炭 <code>finally</code> ߂ <code>super.close()</code> ւ̌Ăяo܂߂鎖l܂B
	 * 
	 * @throws MessagingException N[ỸG[̏ꍇ
	 * @see javax.mail.event.ConnectionEvent
	 */
	public synchronized void close() throws MessagingException {
		setConnected(false);
		notifyConnectionListeners(ConnectionEvent.CLOSED);
	}

	/**
	 * ̃T[rX\ URLName Ԃ܂B
	 * Ԃ URLName ̓pX[htB[h<em>܂݂܂</em>B<p>
	 * 
	 * TuNX́AURLName W`ɂ̂ƂĂȂꍇA
	 * ̃\bhI[o[ChȂ΂Ȃ܂B<p>
	 * 
	 * Service NXɂ́ApX[hƃt@C
	 * 菜 <code>url</code> tB[h (ʏ̓Rs[) Ԃ܂B
	 * 
	 * @return ̃T[rX\ URLName
	 * @see URLName
	 */
	public URLName getURLName() {
		if (url != null && (url.getPassword() != null || url.getFile() != null))
			return new URLName(url.getProtocol(), url.getHost(),
		    	url.getPort(), null /* no file */,
				url.getUsername(), null /* no password */);
		return url;
	}

	/**
	 * ̃T[rX\ URLName ݒ肵܂B
	 * ʏAT[rX̐ڑIA
	 * <code>url</code> tB[hXVׂɎgp܂B<p>
	 * 
	 * TuNX́AURL W`ɂ̂ƂĂȂꍇA
	 * ̃\bhI[o[ChȂ΂Ȃ܂B
	 * ɁAURL  <code>URLName</code> ɂT|[gSẲ\ȃtB[hvȂꍇA
	 * TuNX͂̃\bhI[o[ChȂ΂Ȃ܂B
	 * ̏ꍇAV <code>URLName</code> ́A
	 * 폜ꂽCӂ̕svȃtB[hgpč\zKv܂B<p>
	 * 
	 * Service NXɂ́AP <code>url</code> tB[hݒ肵܂B
	 * 
	 * @see URLName
	 */
	protected void setURLName(final URLName url) {
		this.url = url;
	}

	/**
	 * ̃T[rX Connection Cxg̃Xi[ǉ܂B<p>
	 * 
	 * Œ񋟂ftHg̎́A
	 * ̃Xi[ ConnectionListener Xgɒǉ܂B
	 * 
	 * @param l Connection Cxg Listener
	 * @see javax.mail.event.ConnectionEvent
	 */
	public synchronized void addConnectionListener(final ConnectionListener l) {
		if (connectionListeners == null)
			connectionListeners = new Vector();
		connectionListeners.addElement(l);
	}

	/**
	 * Connection Cxg̃Xi[폜܂B<p>
	 * 
	 * Œ񋟂ftHg̎́A
	 * ̃Xi[ ConnectionListener Xg폜܂B
	 * 
	 * @param l Xi[
	 * @see #addConnectionListener
	 */
	public synchronized void removeConnectionListener(final ConnectionListener l) {
		if (connectionListeners != null)
			connectionListeners.removeElement(l);
	}

	/**
	 * SĂ ConnectionListener ɒʒm܂B
	 * Service ͂̃\bhgpāA
	 * ڑCxgu[hLXgȂ΂Ȃ܂B<p>
	 * 
	 * 񋟂ftHg̎́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓L[CxgoA
	 * o^ꂽ ConnectionListener ɃfBXpb`܂B
	 * Cxg̃fBXpb`͕ʌ̃XbhŋNׁAfbhbNh܂B
	 */
	protected synchronized void notifyConnectionListeners(final int type) {
		if (connectionListeners != null) {
			ConnectionEvent e = new ConnectionEvent(this, type);
			queueEvent(e, connectionListeners);
		}

		/* Fix for broken JDK1.1.x Garbage collector :
		 *  The 'conservative' GC in JDK1.1.x occasionally fails to
		 *  garbage-collect Threads which are in the wait state.
		 *  This would result in thread (and consequently memory) leaks.
		 *
		 * We attempt to fix this by sending a 'terminator' event
		 * to the queue, after we've sent the CLOSED event. The
		 * terminator event causes the event-dispatching thread to
		 * self destruct.
		 */
		if (type == ConnectionEvent.CLOSED)
			terminateQueue();
	}

	/**
	 * ̃T[rX URLName ꍇ́A<code>getURLName.toString()</code> Ԃ܂B
	 * łȂꍇ́AftHg <code>toString</code> Ԃ܂B
	 */
	public String toString() {
		URLName url = getURLName();
		if (url != null)
			return url.toString();
		return super.toString();
	}

	/*
	 * The queue of events to be delivered.
	 */
	private EventQueue q;

	/*
	 * A lock for creating the EventQueue object.  Only one thread should
	 * create an EventQueue for this service.  We can't synchronize on the
	 * service's lock because that might violate the locking hierarchy in
	 * some cases.
	 */
	private Object qLock = new Object();

	/**
	 * Xi[ event  vector zML[ɒǉ܂B
	 */
	protected void queueEvent(final MailEvent event, final Vector vector) {
		// synchronize creation of the event queue
		synchronized (qLock) {
			if (q == null)
				q = new EventQueue();
		}

		/*
		 * Copy the vector in order to freeze the state of the set
		 * of EventListeners the event should be delivered to prior
		 * to delivery.  This ensures that any changes made to the
		 * Vector from a target listener's method during the delivery
		 * of this event will not take effect until after the event is
		 * delivered.
		 */
		Vector v = (Vector) vector.clone();
		q.enqueue(event, v);
	}

	// Dispatch the terminator
	private void terminateQueue() {
		synchronized (qLock) {
			if (q != null) {
				Vector dummyListeners = new Vector();
				dummyListeners.setSize(1); // need atleast one listener

				q.enqueue(new MailEvent(new Object()) { // The Terminator Event
					public void dispatch(Object listener) {
						// Kill the event dispatching thread.
						Thread.currentThread().interrupt();
					}
			    }, dummyListeners);
				q = null;
			}
		}
	}

	/**
	 * L[Kx[WRNg\ɂȂ悤ɁACxgfBXpb`Xbh~܂B
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		terminateQueue();
	}

}
