/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.util.Vector;

import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.StoreEvent;
import javax.mail.event.StoreListener;

/**
 * bZ[W̊i[Ǝ擾ׂ̈ɁAbZ[WXgAƂ
 * ANZXvgRf abstract NXłB
 * TuNX͎ۂ̎񋟂܂B<p>
 * 
 * <code>Store</code>  <code>Service</code> NXg܂B
 * XgA̖AXgAւ̐ڑAڑCxg̃XjÖׂ
 * ̋ʃ\bh񋟂܂B
 * 
 * @see javax.mail.Service
 * @see javax.mail.event.ConnectionEvent
 * @see javax.mail.event.StoreEvent
 */
public abstract class Store extends Service {

	/**
	 * RXgN^łB
	 * 
	 * @param session  Store  Session IuWFNg
	 * @param urlname  Store Ɏgp URLName IuWFNg
	 */
	protected Store(final Session session, final URLName urlname) {
		super(session, urlname);
	}

	/**
	 * Store ɂ胆[Uɒ񎦂ftHg̖OԂ 'root' \ Folder IuWFNgԂ܂B
	 * 
	 * @return [g Folder
	 * @throws IllegalStateException  Store ڑĂȂꍇ
	 */
	public abstract Folder getDefaultFolder() throws MessagingException;

	/**
	 * w肳ꂽOɑΉ Folder IuWFNgԂ܂B
	 * Store ɊY閼ÕtH_Iɑ݂ȂꍇłAFolder IuWFNgԂ܂B
	 * tH_IuWFNg <code>exists()</code> \bh́ÃtH_݂邩ǂ܂B<p>
	 * 
	 * Folder IuWFNg Store ɂLbVȂ̂ŁA
	 * Oł̃\bh𕡐ĂяoƁÄقȂ Folder IuWFNgԂ܂B
	 * 
	 * @param name Folder ̖OB
	 * ꕔ Store ɂāAOKw؂蕶Ŏn܂ꍇA΃pXƂȂ邱Ƃ܂B
	 * łȂꍇ́AO̖͂OԂ '[g' ւ̑ΖƉ߂܂B
	 * @return Folder IuWFNg
	 * @throws IllegalStateException  Store ڑĂȂꍇ
	 * @see Folder#exists
	 * @see Folder#create
	 */
	public abstract Folder getFolder(String name) throws MessagingException;

	/**
	 * w肳ꂽ URLName ɑΉA Folder IuWFNgԂ܂B
	 * w肳ꂽ URLName Ɏw肳ꂽXgÁA Store IuWFNgQƂKv܂B<p>
	 * 
	 * ̃\bh̎́AURLName  <code>getFile()</code> \bhgp
	 * ۂ̃tH_̖O擾A̖OgpătH_쐬鎖ł܂B
	 * 
	 * @param url tH_ URLName
	 * @return Folder IuWFNg
	 * @throws IllegalStateException  Store ڑĂȂꍇ
	 * @see URLName
	 */
	public abstract Folder getFolder(URLName url) throws MessagingException;

	/**
	 * ݂̃[U<i>lI</i>OԂ\ÃtH_Ԃ܂B
	 * lOԂ́AF؂ꂽ[ǓlIȔ͈͓ɂƌȂA̖OłB
	 * ʂɁAF؂ꂽ[UAlOԓ̃[tH_փANZXł܂B
	 * [U INBOX ݂ꍇA̓[ǓlOԓɕ\ĂKv܂B
	 * ʓIɂ́Ae Store ̊e[UɂāAlOԂ 1 ݂܂B<p>
	 * 
	 * ̎́A<code>getDefaultFolder</code> \bh̖߂l܂ޒPGgzԂ܂B
	 * TuNX͂̃\bhI[o[ChAK؂ȏԂKv܂B
	 * 
	 * @return Folder IuWFNg̔z
	 * @throws IllegalStateException  Store ڑĂȂꍇ
	 * @since JavaMail 1.2
	 */
	public Folder[] getPersonalNamespaces() throws MessagingException {
		return new Folder[] { getDefaultFolder() };
	}

	/**
	 * <code>user</code> ̖OԂ\ÃtH_Ԃ܂B
	 * Ԃ閼OԂ́Ã[ǓlOԂ\܂B
	 * ̃[U̖OԂɂ郁[tH_ɃANZXׂɂ́A
	 * ݔF؂Ă郆[ÚAIɃANZXt^Kv܂B
	 * Ⴆ΁A}l[W鏑Ƀ[tH_̃ANZX^͈̂ʓIłB<p>
	 * 
	 * ̎͋̔zԂ܂B
	 * TuNX͂̃\bhI[o[ChAK؂ȏԂKv܂B
	 * 
	 * @return Folder IuWFNg̔z
	 * @throws IllegalStateException  Store ڑĂȂꍇ
	 * @since JavaMail 1.2
	 */
	public Folder[] getUserNamespaces(final String user) throws MessagingException {
		return new Folder[0];
	}

	/**
	 * <i>L</i>OԂ\ÃtH_Ԃ܂B
	 * LOԂ́Ã[UԂŋL鎖Ӑ}A
	 * [ǓlOԓɑ݂Ȃ[tH_ō\閼OԂłB<p>
	 * 
	 * ̎͋̔zԂ܂B
	 * TuNX͂̃\bhI[o[ChAK؂ȏԂKv܂B
	 * 
	 * @return Folder IuWFNg̔z
	 * @throws IllegalStateException  Store ڑĂȂꍇ
	 * @since JavaMail 1.2
	 */
	public Folder[] getSharedNamespaces() throws MessagingException {
		return new Folder[0];
	}

	// Store Xi[ Vector 
	private volatile Vector storeListeners = null;

	/**
	 * StoreEvents ̃Xi[A Store ɒǉ܂B<p>
	 * 
	 * Œ񋟂ftHg̎́ÃXi[ StoreListener Xgɒǉ܂B
	 * 
	 * @param l Store Cxg Listener
	 * @see javax.mail.event.StoreEvent
	 */
	public synchronized void addStoreListener(final StoreListener l) {
		if (storeListeners == null)
			storeListeners = new Vector();
		storeListeners.addElement(l);
	}

	/**
	 * Store Cxg̃Xi[폜܂B<p>
	 * 
	 * Œ񋟂ftHg̎́ÃXi[ StoreListener Xg폜܂B
	 * 
	 * @param l Xi[
	 * @see #addStoreListener
	 */
	public synchronized void removeStoreListener(final StoreListener l) {
		if (storeListeners != null)
			storeListeners.removeElement(l);
	}

	/**
	 * SĂ StoreListener ɒʒm܂B
	 * Store ͂̃\bhgpāAStoreEvent u[hLXgKv܂B<p>
	 * 
	 * 񋟂ftHg̎́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓L[CxgoA
	 * o^ꂽ StoreListener ɃfBXpb`܂B
	 * Cxg̃fBXpb`͕ʌ̃XbhŋNׁAfbhbNh܂B
	 */
	protected void notifyStoreListeners(final int type, final String message) {
		if (storeListeners == null)
			return;

		StoreEvent e = new StoreEvent(this, type, message);
		queueEvent(e, storeListeners);
	}

	// tH_Xi[ Vector
	private volatile Vector folderListeners = null;

	/**
	 * Folder Cxg̃Xi[A Store 擾ꂽCӂ Folder IuWFNgɒǉ܂B
	 * FolderEvents ́Ae󂯂 Folder  FolderListener ƁA
	 * ܂ Store  FolderListener ɔzM܂B<p>
	 * 
	 * Œ񋟂ftHg̎́ÃXi[ FolderListener Xgɒǉ܂B
	 * 
	 * @param l Folder Cxg Listener
	 * @see javax.mail.event.FolderEvent
	 */
	public synchronized void addFolderListener(final FolderListener l) {
		if (folderListeners == null)
			folderListeners = new Vector();
		folderListeners.addElement(l);
	}

	/**
	 * Folder Cxg̃Xi[폜܂B<p>
	 * 
	 * Œ񋟂ftHg̎́ÃXi[ FolderListener Xg폜܂B
	 * 
	 * @param l Xi[
	 * @see #addFolderListener
	 */
	public synchronized void removeFolderListener(final FolderListener l) {
		if (folderListeners != null)
			folderListeners.removeElement(l);
	}

	/**
	 * SĂ FolderListener ɒʒm܂B
	 * Store ͂̃\bhgpāAFolder Cxgu[hLXgKv܂B<p>
	 * 
	 * 񋟂ftHg̎́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓L[CxgoA
	 * o^ꂽ FolderListener ɃfBXpb`܂B
	 * Cxg̃fBXpb`͕ʌ̃XbhŋNׁAfbhbNh܂B
	 * 
	 * @param type FolderEvent ̌^
	 * @param folder e󂯂 Folder
	 * @see #notifyFolderRenamedListeners
	 */
	protected void notifyFolderListeners(final int type, final Folder folder) {
		if (folderListeners == null) 
			return;

		FolderEvent e = new FolderEvent(this, folder, type);
		queueEvent(e, folderListeners);
	}

	/**
	 * tH_̖OύXɂāASĂ FolderListener ɒʒm܂B
	 * Store ͂̃\bhgpAtH_̖OύX
	 *  Folder Cxgu[hLXgKv܂B<p>
	 * 
	 * 񋟂ftHg̎́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓L[CxgoA
	 * o^ꂽ FolderListener ɃfBXpb`܂B
	 * Cxg̃fBXpb`͕ʌ̃XbhŋNׁAfbhbNh܂B
	 * 
	 * @param oldF OύXtH_
	 * @param newF VO\tH_
	 * @since JavaMail 1.1
	 */
	protected void notifyFolderRenamedListeners(final Folder oldF, final Folder newF) {
		if (folderListeners == null) 
			return;

		FolderEvent e = new FolderEvent(this, oldF, newF,FolderEvent.RENAMED);
		queueEvent(e, folderListeners);
	}

}
