/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

/**
 * bZ[WgX|[gf钊ۃNXłB
 * TuNX͎ۂ̎񋟂܂B<p>
 * 
 * <code>Transport</code>  <code>Service</code> NXg܂B
 * gX|[g̖AgX|[gւ̐ڑA
 * ڑCxg̃XjÖׂ̑̋ʃ\bh񋟂܂B
 * 
 * @see javax.mail.Service
 * @see javax.mail.event.ConnectionEvent
 * @see javax.mail.event.TransportEvent
 */
public abstract class Transport extends Service {

	/**
	 * RXgN^łB
	 * 
	 * @param session  Transport  Session IuWFNg
	 * @param urlname  Transport Ɏgp URLName IuWFNg
	 */
	public Transport(final Session session, final URLName urlname) {
		super(session, urlname);
	}

	/**
	 * bZ[W𑗐M܂BbZ[ẂAbZ[WɎw肳ꂽ
	 * SĂ̎MAhX (<code>Message</code> \bh <code>getAllRecipients</code> Ԃ) ɁA
	 * eAhXɓK؂ȃbZ[WgX|[ggpđM܂B
	 * <code>send</code> \bh́AbZ[W𑗐MOɁA
	 * bZ[W <code>saveChanges</code> \bhĂяo܂B<p>
	 * 
	 * bZ[W̑MATransport ɂM҃AhX̉ꂩɂĖł鎖oꂽꍇA
	 * SendFailedException X[܂B
	 * NCAg̗͂O鎖ŁAQ̏ڍ׏𓾂鎖ł܂B
	 * bZ[WLȃAhXɖMĂ邩ǂ́ATransport Ɉˑ܂B
	 * ڍׂɂĂ SendFailedException QƂĉB
	 * AMɏÍAbZ[WŏIIȎM҂ɓ͂Ӗ܂B
	 * zM̌̒iKŏQ鎖܂B
	 * Transport M҂ւ̔zMɊւ郁bZ[W󂯎ǍɔQ́A
	 * zMȂbZ[W̕ԐMAʂ̎dg݂ʂĕ񍐂Kv܂B<p>
	 * 
	 * @param msg M郁bZ[W
	 * @throws SendFailedException bZ[WM҂̈ꕔ͑SɑMłȂꍇ
	 * @throws MessagingException
	 * @see Message#saveChanges
	 * @see Message#getAllRecipients
	 * @see #send(Message, Address[])
	 * @see javax.mail.SendFailedException
	 */
	public static void send(final Message msg) throws MessagingException {
		msg.saveChanges(); // do this first
		send0(msg, msg.getAllRecipients());
	}

	/**
	 * w肳ꂽAhXɃbZ[W𑗐M܂B
	 * bZ[WgɎw肳ꂽM҂͑SĖ܂B
	 * <code>send</code> \bh́AbZ[W𑗐MOɁA
	 * bZ[W <code>saveChanges</code> \bhĂяo܂B<p>
	 * 
	 * @param msg M郁bZ[W
	 * @param addresses bZ[WM̃AhX
	 * @throws SendFailedException bZ[WM҂̈ꕔ͑SɑMłȂꍇ
	 * @throws MessagingException
	 * @see Message#saveChanges
	 * @see #send(Message)
	 * @see javax.mail.SendFailedException
	 */
	public static void send(final Message msg, final Address[] addresses) throws MessagingException {
		msg.saveChanges();
		send0(msg, addresses);
	}

	// send, but without the saveChanges
	private static void send0(final Message msg, final Address[] addresses) throws MessagingException {
		if (addresses == null || addresses.length == 0)
			throw new SendFailedException("No recipient addresses");

		/*
		 * protocols is a hashtable containing the addresses
		 * indexed by address type
		 */
		Hashtable protocols = new Hashtable();

		// Vectors of addresses
		Vector invalid = new Vector();
		Vector validSent = new Vector();
		Vector validUnsent = new Vector();

		for (int i = 0; i < addresses.length; i++) {
			// is this address type already in the hashtable?
			if (protocols.containsKey(addresses[i].getType())) {
				Vector v = (Vector) protocols.get(addresses[i].getType());
				v.addElement(addresses[i]);
			} else {
				// need to add a new protocol
				Vector w = new Vector();
				w.addElement(addresses[i]);
				protocols.put(addresses[i].getType(), w);
			}
		}

		int dsize = protocols.size();
		if (dsize == 0)
			throw new SendFailedException("No recipient addresses");

		Session s = (msg.session != null) ? msg.session :
			Session.getDefaultInstance(System.getProperties(), null);
		Transport transport;

		/*
		 * Optimize the case of a single protocol.
		 */
		if (dsize == 1) {
			transport = s.getTransport(addresses[0]);
			try {
				transport.connect();
				transport.sendMessage(msg, addresses);
			} finally {
				transport.close();
			}
			return;
		}

		/*
		 * More than one protocol.  Have to do them one at a time
		 * and collect addresses and chain exceptions.
		 */
		MessagingException chainedEx = null;
		boolean sendFailed = false;

		Enumeration e = protocols.elements();
		while (e.hasMoreElements()) {
			Vector v = (Vector) e.nextElement();
			Address[] protaddresses = new Address[v.size()];
			v.copyInto(protaddresses);

			// Get a Transport that can handle this address type.
			if ((transport = s.getTransport(protaddresses[0])) == null) {
				// Could not find an appropriate Transport ..
				// Mark these addresses invalid.
				for (int j = 0; j < protaddresses.length; j++)
					invalid.addElement(protaddresses[j]);
				continue;
			}

			try {
				transport.connect();
				transport.sendMessage(msg, protaddresses);
			} catch (SendFailedException sex) {
				sendFailed = true;
				// chain the exception we're catching to any previous ones
				if (chainedEx == null)
					chainedEx = sex;
				else
					chainedEx.setNextException(sex);

				// retrieve invalid addresses
				Address[] a = sex.getInvalidAddresses();
				if (a != null)
					for (int j = 0; j < a.length; j++) 
						invalid.addElement(a[j]);

				// retrieve validSent addresses
				a = sex.getValidSentAddresses();
				if (a != null)
					for (int k = 0; k < a.length; k++) 
						validSent.addElement(a[k]);

				// retrieve validUnsent addresses
				Address[] c = sex.getValidUnsentAddresses();
				if (c != null)
					for (int l = 0; l < c.length; l++) 
						validUnsent.addElement(c[l]);
			} catch (MessagingException mex) {
				sendFailed = true;
				// chain the exception we're catching to any previous ones
				if (chainedEx == null) 
					chainedEx = mex;
				else
					chainedEx.setNextException(mex);
			} finally {
				transport.close();
			}
		}

		// done with all protocols. throw exception if something failed
		if (sendFailed || invalid.size() != 0 || validUnsent.size() != 0) { 
			Address[] a = null, b = null, c = null;

			// copy address vectors into arrays
			if (validSent.size() > 0) {
				a = new Address[validSent.size()];
				validSent.copyInto(a);
			}
			if (validUnsent.size() > 0) {
				b = new Address[validUnsent.size()];
				validUnsent.copyInto(b);
			}
			if (invalid.size() > 0) {
				c = new Address[invalid.size()];
				invalid.copyInto(c);
			}
			throw new SendFailedException("Sending failed", chainedEx, a, b, c);
		}
	}

	/**
	 * Message w肳ꂽXg̃AhXɑM܂B
	 * zMԂK؂ TransportEvent ́A Transport ɓo^Ă
	 * SĂ TransportListener ɔzM܂B
	 * AAhX̉ꂩ̏ꍇASendFailedException X[܂B
	 * AALȃAhXɂ̓bZ[WM܂B<p>
	 * 
	 * ÓI <code>send</code> \bhƂ͈قȂA<code>sendMessage</code> \bh́A
	 * bZ[W <code>saveChanges</code> \bh<em>Ăяo܂</em>B
	 * ĂяǒĂяosKv܂B
	 * 
	 * @param msg M Message
	 * @param addresses ̃bZ[W̑MAhX̃Xg
	 * @throws SendFailedException ȃAhẌׂɑMsꍇ
	 * @throws MessagingException ڑIĂꍇA͐ڑԂɂȂꍇ 
	 * @see javax.mail.event.TransportEvent
	 */
	public abstract void sendMessage(Message msg, Address[] addresses) throws MessagingException;

	// Transport Xi[ Vector
	private Vector transportListeners = null;

	/**
	 * Transport Cxg̃Xi[ǉ܂B<p>
	 * 
	 * Œ񋟂ftHg̎́A
	 * ̃Xi[ TransportListener Xgɒǉ܂B
	 * 
	 * @param l Transport Cxg Listener
	 * @see javax.mail.event.TransportEvent
	 */
	public synchronized void addTransportListener(final TransportListener l) {
		if (transportListeners == null)
			transportListeners = new Vector();
		transportListeners.addElement(l);
	}

	/**
	 * Transport Cxg̃Xi[폜܂B<p>
	 * 
	 * Œ񋟂ftHg̎́A
	 * ̃Xi[ TransportListener Xg폜܂B
	 * 
	 * @param l Xi[
	 * @see #addTransportListener
	 */
	public synchronized void removeTransportListener(final TransportListener l) {
		if (transportListeners != null)
			transportListeners.removeElement(l);
	}

	/**
	 * SĂ TransportListener ɒʒm܂B
	 * Transport ͂̃\bhgpāATransportEvent u[hLXgKv܂B<p>
	 * 
	 * 񋟂ftHg̎́ACxgCxgL[ɓ܂B
	 * CxgfBXpb`Xbh̓L[CxgoA
	 * o^ꂽ TransportListener ɃfBXpb`܂B
	 * Cxg̃fBXpb`͕ʌ̃XbhŋN邽߁AfbhbNh܂B
	 */
	protected void notifyTransportListeners(
		final int type,
		final Address[] validSent,
		final Address[] validUnsent,
		final Address[] invalid,
		final Message msg) {

		if (transportListeners == null)
			return;

		TransportEvent e = new TransportEvent(this, type, validSent, validUnsent, invalid, msg);
		queueEvent(e, transportListeners);
	}

}
