/*
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail;

/**
 * <code>UIDFolder</code> C^tF[X́A"disconnected" [h̑T|[g Folder ܂B
 * ̂悤Ȏł́AtH_̃bZ[Wɑ΂Ĉӂ ID 񋟂܂B
 * ̃C^tF[X́Adisconnected T|[g邽߂ IMAP fx[XɂĂ܂B<p>
 * 
 * UID (ӂ ID) ͐ long lŁÃtH_̊ebZ[WɊ蓖Ă܂B
 * UID ́A[{bNXɂĕK<strong></strong>Ɋ蓖Ă܂B
 * ܂AebZ[W[{bNXɒǉ鎞ÃbZ[W傫 UID 蓖Ă܂B
 * UID ̓ZbV܂Ď܂BɂNCAǵA
 * ÕZbV̏ԂT[oƍēx鎖ł܂B<p>
 * 
 * SẴ[{bNXƊ֘At̂́AUID ̑ÓlłB
 * ÕZbV UID ̃ZbVőĎgpłȂꍇA
 * UID Ól͑ÕZbVŎgpꂽl<strong>傫Kv܂</strong>B<p>
 * 
 * ڍׂɂẮA<a href="http://www.ietf.org/rfc/rfc2060.txt">RFC 2060</a> QƂĉB
 */
public interface UIDFolder {

	/**
	 * UID otFb`vt@CڂłB
	 * ̓NX <code>FetchProfile.Item</code> NXgA
	 * UIDFolder ɌŗL̐V FetchProfile ڃ^Cvǉ܂B
	 * ݂Œ`ĂB̍ڂ <code>UID</code> ڂłB
	 * 
	 * @see FetchProfile
	 */
	public static class FetchProfileItem extends FetchProfile.Item {

		/**
		 * RXgN^łB
		 */
		protected FetchProfileItem(final String name) {
			super(name);
		}

		/**
		 * UID ́AFolder ւ̃tFb`vA<code>FetchProfile</code> 
		 * ܂߂鎖\ȃtFb`vt@CڂłB
		 * ̍ڂ́Aw肳ꂽ͈͂̃bZ[Wp UIDAǂׂ݂ł鎖܂B<p>
		 * 
		 * NCAgɂgpȉɎ܂B<p>
		 * <blockquote><pre>
		 * 
		 * 	FetchProfile fp = new FetchProfile();
		 *	fp.add(UIDFolder.FetchProfileItem.UID);
		 *	folder.fetch(msgs, fp);
		 * 
		 * </pre></blockquote><p>
		 */ 
		public static final FetchProfileItem UID = new FetchProfileItem("UID");

	}

	/**
	 * ́ÃtH_̍Ō UID ׂɁA
	 * <code>getMessages(start, end)</code>  <code>end</code> p[^ƂĎgpłȒlłB
	 * 
	 * @see #getMessagesByUID
	 */ 
	public static final long LASTUID = -1;

	/**
	 * ̃tH_Ɋ֘A UIDValidity lԂ܂B<p>
	 * 
	 * ʂɃNCAǵA̒lAÕZbVŕۑꂽ UIDValidity lƔrA
	 * LbVꂽ UID ׂėLł鎖mF܂B
	 * 
	 * @return UIDValidity
	 */
	public long getUIDValidity() throws MessagingException;

	/**
	 * w肳ꂽ UID ɑΉ Message 擾܂B
	 * Y郁bZ[W݂Ȃꍇ́A<code>null</code> Ԃ܂B
	 * 
	 * @param uid ]郁bZ[W UID
	 * @return Message IuWFNgłB
	 *  UID ɑΉ郁bZ[W擾Ȃꍇ́A<code>null</code> Ԃ܂B
	 * @throws MessagingException
	 */
	public Message getMessageByUID(long uid) throws MessagingException;

	/**
	 * ͈͂w肳ꂽ Message 擾܂B
	 * Ȓl LASTUID ́Agp\ȍŌ UID  <code>end</code> p[^ƂĎgp\łB
	 * 
	 * @param start Jn UID
	 * @param end I UID
	 * @return Message IuWFNg̔z
	 * @throws MessagingException
	 * @see #LASTUID
	 */
	public Message[] getMessagesByUID(long start, long end) throws MessagingException;

	/**
	 * UID ̔zɂw肳ꂽ Message 擾܂B
	 * ꂩ UID ȏꍇÃGgɂ <code>null</code> Ԃ܂B<p>
	 * 
	 * Ԃz̃TCÝAw肳ꂽ UID ̔z̃TCYƓɂȂ܂B
	 * A UID ׂɁA<code>null</code> Ggz񒆂ɑ݂ꍇ܂B
	 * 
	 * @param uids UID ̔z
	 * @return Message IuWFNg̔z
	 * @throws MessagingException
	 */
	public Message[] getMessagesByUID(long[] uids) throws MessagingException;

	/**
	 * w肳ꂽbZ[W UID 擾܂B
	 * bZ[W͂̃tH_<strong>ĂKv܂</strong>B
	 * łȂꍇ́Ajava.util.NoSuchElementException X[܂B
	 * 
	 * @param message ̃tH_̃bZ[W
	 * @return ̃bZ[W UID
	 * @throws NoSuchElementException w肳ꂽ Message  Folder ɂȂꍇ
	 */
	public long getUID(Message message) throws MessagingException;

}
