/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.event;

import javax.mail.Folder;

/**
 * ̃NX Folder <em></em>Cxgf܂B
 * FolderEvent ́Ae󂯂 Folder ƕ܂ Store ɓo^
 * ꂽ FolderListeners ɔzM܂B<p>
 * 
 * T[rXvoC_ɂāÃCxgNCAgɒʒm\͂͗lXłB
 * ŒłT[rXvoC_́A삪铯 Store  Folder 
 * o^ꂽXi[ɒʒmȂ΂Ȃ܂B
 * AT[rXvoC_́Az}V̑̃IuWFNg̑삩A
 * ꖔ̓zXg̑̃NCAgɂύXsꂽꍇAXi[ɒʒm\łB
 * ʒm͕K{ł͂ȂAʏ탁[vgR (IMAP ܂) ɂT|[g܂B
 */
public final class FolderEvent extends MailEvent {

	private static final long serialVersionUID = 5278131310563694307L;

	/**
	 * tH_쐬܂B
	 */
	public static final int CREATED	= 1;

	/**
	 * tH_폜܂B
	 */
	public static final int DELETED	= 2;

	/**
	 * tH_̖OύX܂B
	 */
	public static final int RENAMED	= 3;

	/**
	 * Cxǧ^łB
	 * 
	 * @serial
	 */
	protected int type;

	/**
	 * CxgtH_łB
	 */
	protected transient Folder folder;

	/**
	 * RENAMED Cxg̏ꍇAVO\tH_łB
	 * 
	 * @since JavaMail 1.1
	 */
	protected transient Folder newFolder;

	/**
	 * RXgN^łB<p>
	 * 
	 * @param source ̃Cxg̃\[X
	 * @param folder e󂯂tH_
	 * @param type Cxǧ^
	 */
	public FolderEvent(final Object source, final Folder folder, final int type) {
		this(source, folder, folder, type);
	}

	/**
	 * RXgN^łBRENAMED CxgɎgp܂B
	 * 
	 * @param source ̃Cxg̃\[X
	 * @param oldFolder OύXtH_
	 * @param newFolder VO\tH_
	 * @param type Cxǧ^
	 * @since JavaMail 1.1
	 */
	public FolderEvent(final Object source, final Folder oldFolder, final Folder newFolder, final int type) {
		super(source);
		this.folder = oldFolder;
		this.newFolder = newFolder;
		this.type = type;
	}

	/**
	 * ̃Cxǧ^Ԃ܂B
	 * 
	 * @return ^
	 */
	public int getType() {
		return type;
	}

	/**
	 * e󂯂tH_Ԃ܂B
	 * 
	 * @return e󂯂tH_
	 * @see #getNewFolder
	 */
	public Folder getFolder() {
		return folder;
	}

	/**
	 * ̃CxgtH_̖OύX (܂ACxǧ^ RENAMED ł) ꍇA
	 * ̃\bh͐VO\ Folder IuWFNgԂ܂B<p>
	 * 
	 * <code>getFolder()</code> \bh͖OύXtH_Ԃ܂B
	 * 
	 * @return VO\tH_
	 * @since JavaMail 1.1
	 * @see #getFolder
	 */
	public Folder getNewFolder() {
		return newFolder;
	}

	/**
	 * K؂ FolderListener \bhĂяo܂B
	 */
	public void dispatch(final Object listener) {
		if (type == CREATED)
			((FolderListener)listener).folderCreated(this);
		else if (type == DELETED)
			((FolderListener)listener).folderDeleted(this);
		else if (type == RENAMED)
			((FolderListener)listener).folderRenamed(this);
	}

}
