/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.event;

import javax.mail.Message;

/**
 * ̃NX Message ύXCxgf܂B
 */
public final class MessageChangedEvent extends MailEvent {

	private static final long serialVersionUID = -4974972972105535108L;

	/**
	 * bZ[W̃tOύX܂B
	 */
	public static final int FLAGS_CHANGED 	= 1;

	/**
	 * bZ[W̃Gx[v ({ł͂ȂAwb_) ύX܂B
	 */
	public static final int ENVELOPE_CHANGED 	= 2;

	/**
	 * Cxǧ^łB
	 * 
	 * @serial
	 */
	protected int type;

	/**
	 * ύXꂽbZ[WłB
	 */
	protected transient Message msg;

	/**
	 * RXgN^łB
	 * 
	 * @param source bZ[WLtH_
	 * @param type ύX̌^
	 * @param msg ύXꂽbZ[W 
	 */
	public MessageChangedEvent(final Object source, final int type, final Message msg) {
		super(source);
		this.msg = msg;
		this.type = type;
	}

	/**
	 * ̃Cxǧ^Ԃ܂B
	 * 
	 * @return ^
	 */
	public int getMessageChangeType() {
		return type;
	}

	/**
	 * ύXꂽ Message Ԃ܂B
	 * 
	 * @return bZ[W
	 */
	public Message getMessage() {
		return msg;
	}

	/**
	 * K؂ MessageChangedListener \bhĂяo܂B
	 */
	public void dispatch(final Object listener) {
		((MessageChangedListener)listener).messageChanged(this);
	}

}
