/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.event;

import javax.mail.Folder;
import javax.mail.Message;

/**
 * ̃NX̓tH_̃bZ[W̕ύXʒm܂B<p>
 * 
 * tH_^CvɂẮA̎Ԗ͓̑
 *  MessageCountEvents ̔zMłȂ鎖ɒӂĉB
 *  IMAP ́ANCAgVR}h𔭍s
 *  MessageCountEvents NCAgɒʒm邾łB
 * ڍׂɂẮA<a href="http://www.ietf.org/rfc/rfc2060.txt">RFC 2060</a> QƂĉB
 * NCAǵAKvɉ <code>getMessageCount</code> 
 *  <code>isConnected</code> \bhĂяoɂA
 * tH_ "|[O" āAʒmvł܂B
 */
public final class MessageCountEvent extends MailEvent {

	private static final long serialVersionUID = -7447022340837897369L;

	/**
	 * bZ[WtH_ɒǉ܂B
	 */
	public static final int ADDED		= 1;

	/**
	 * bZ[WtH_폜܂B
	 */
	public static final int REMOVED	= 2;

	/**
	 * Cxǧ^łB
	 * 
	 * @serial
	 */
	protected int type;

	/**
	 * true ̏ꍇÃCxg͂̃NCAgɂ薾Iɍ폜ꂽʂłA
	 * ̃tH_̃bZ[W̔ԍ͍ēx蓖ĂĂ܂B
	 * false ̏ꍇÃCxg͊O\[Xɂ폜̌ʂłB
	 * 
	 * @serial
	 */
	protected boolean removed;

	/**
	 * bZ[WłB
	 */
	protected transient Message[] msgs;

	/**
	 * RXgN^łB
	 * 
	 * @param folder ܂tH_
	 * @param type Cxǧ^
	 * @param removed true ̏ꍇÃCxg͂̃NCAgɂ薾I
	 * 폜ꂽʂłÃtH_̃bZ[W̔ԍ͍ēx蓖ĂĂ܂B
	 * false ̏ꍇÃCxg͊O\[Xɂ폜̌ʂłB
	 * @param msgs ǉ/폜ꂽbZ[W
	 */
	public MessageCountEvent(final Folder folder, final int type, final boolean removed, final Message[] msgs) {
		super(folder);
		this.type = type;
		this.removed = removed;
		this.msgs = msgs;
	}

	/**
	 * ̃Cxǧ^Ԃ܂B
	 * 
	 * @return ^
	 */
	public int getType() {
		return type;
	}

	/**
	 * ̃CxgÃNCAgɂ閾Iȍ폜̌ʂȂ̂A
	 * O\[Xɂ폜̌ʂȂ̂܂B
	 * <code>true</code> ̏ꍇÃCxg͖Iȍ폜̌ʂłA
	 * tH_ɎcĂSẴbZ[W̔ԍ͍ēx蓖ĂĂ܂B
	 * <code>false</code> ̏ꍇÃCxg͊O̍폜ɂ錋ʂłB<p>
	 * 
	 * ̃\bh́ÃCxǧ^ <code>REMOVED</code> ̏ꍇɂ̂ݗLł鎖ɒӂĉB
	 */
	public boolean isRemoved() {
		return removed;
	}

	/**
	 * ǉ͍폜ꂽbZ[W̔zԂ܂B
	 * 
	 * @return bZ[W̔z
	 */
	public Message[] getMessages() {
		return msgs;
	}

	/**
	 * K؂ MessageCountListener \bhĂяo܂B
	 */
	public void dispatch(final Object listener) {
		if (type == ADDED)
			((MessageCountListener)listener).messagesAdded(this);
		else // REMOVED
			((MessageCountListener)listener).messagesRemoved(this);
	}

}
