/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.event;

import javax.mail.Store;

/**
 * ̃NX Store ڑ̒ʒmf܂B
 * ̒ʒmɂ ALERTS  NOTICES ܂B
 * ALERTS ̓[UbZ[Wɒӂ𕥂`Ń[Uɒ񎦂Ȃ΂Ȃ܂B
 */
public final class StoreEvent extends MailEvent {

	private static final long serialVersionUID = 1938704919992515330L;

	/**
	 * ̃bZ[W ALERT ł邱Ƃ܂B
	 */
	public static final int ALERT		= 1;

	/**
	 * ̃bZ[W NOTICE ł邱Ƃ܂B
	 */
	public static final int NOTICE	= 2;

	/**
	 * Cxǧ^łB
	 * 
	 * @serial
	 */
	protected int type;

	/**
	 * [Uɒ񎦂郁bZ[WeLXgłB
	 * 
	 * @serial
	 */
	protected String message;

	/**
	 * RXgN^łB
	 * 
	 * @param store \[X Store
	 */
	public StoreEvent(final Store store, final int type, final String message) {
		super(store);
		this.type = type;
		this.message = message;
	}

	/**
	 * ̃Cxǧ^Ԃ܂B
	 * 
	 * @return ^
	 * @see #ALERT
	 * @see #NOTICE
	 */
	public int getMessageType() {
		return type;
	}

	/**
	 * Store 烁bZ[W擾܂B
	 * 
	 * @return Store ̃bZ[W
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * K؂ StoreListener \bhĂяo܂B
	 */
	public void dispatch(final Object listener) {
		((StoreListener)listener).notification(this);
	}

}
