/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.event;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Transport;

/**
 * ̃NX Transport Cxgf܂B
 * 
 * @see javax.mail.Transport
 * @see javax.mail.event.TransportListener
 */
public final class TransportEvent extends MailEvent {

	private static final long serialVersionUID = -4729852364684273073L;

	/**
	 * bZ[ẂÃCxggKڑɂSĂ̎M҂ɖȂzM܂B
	 * validSent[] ͂̈ڑɑMSẴAhX܂݂܂B
	 * validUnsent[]  invalid[]  null ɂȂ܂B
	 */
	public static final int MESSAGE_DELIVERED	  = 1;

	/**
	 * 炩̌ŃbZ[WM܂łBvalidSent[]  null ɂȂ܂B
	 * validUnsent[] ͗LAhX܂ޏꍇ܂ (AbZ[W̃AhXɑMĂȂ) B
	 * invalid[] ɂ͖ȃAhX܂܂܂B
	 */
	public static final int MESSAGE_NOT_DELIVERED = 2;

	/**
	 * bZ[W͈ꕔ̎M҂ɐɑM܂ASĂ̎M҂ł͂܂B
	 * validSent[] ̓bZ[WMꂽM҂̃AhXێ܂B
	 * validUnsent[] ̓bZ[WMȂLȃAhXێ܂B
	 * invalid[] ͖ȃAhXꍇAێ܂B
	 */
	public static final int MESSAGE_PARTIALLY_DELIVERED = 3;

	/**
	 * Cxǧ^łB
	 * 
	 * @serial
	 */
	protected int type;

	protected transient Address[] validSent;
	protected transient Address[] validUnsent;
	protected transient Address[] invalid;
	protected transient Message msg;

	/**
	 * RXgN^łB
	 * 
	 * @param transport Transport IuWFNg
	 */
	public TransportEvent(
		final Transport transport,
		final int type,
		final Address[] validSent,
		final Address[] validUnsent,
		final Address[] invalid,
		final Message msg) {

		super(transport);
		this.type = type;
		this.validSent = validSent;
		this.validUnsent = validUnsent;
		this.invalid = invalid;
		this.msg = msg;
	}

	/**
	 * ̃Cxǧ^Ԃ܂B
	 * 
	 * @return ^
	 */
	public int getType() {
		return type;
	}

	/**
	 * ̃bZ[WɑMꂽAhXԂ܂B
	 * 
	 * @return bZ[WɑMꂽAhX܂ null
	 */
	public Address[] getValidSentAddresses() {
		return validSent;
	}

	/**
	 * Lł邪AbZ[WMȂAhXԂ܂B
	 * 
	 * @return Lł邪bZ[WɑMȂAhX܂ null 
	 */
	public Address[] getValidUnsentAddresses() {
		return validUnsent;
	}

	/**
	 * ̃bZ[WɑMłȂAhXԂ܂B
	 * 
	 * @return bZ[WɑMȂAhX܂ null
	 */
	public Address[] getInvalidAddresses() {
		return invalid;
	}

	/**
	 *  Transport Event Ɋ֘Atꂽ Message IuWFNg擾܂B
	 * 
	 * @return Message IuWFNg
	 * @since JavaMail 1.2
	 */  
	public Message getMessage() {
		return msg;
	}

	/**
	 * K؂ TransportListener \bhĂяo܂B
	 */
	public void dispatch(final Object listener) {
		if (type == MESSAGE_DELIVERED)	
			((TransportListener)listener).messageDelivered(this);
		else if (type == MESSAGE_NOT_DELIVERED)
			((TransportListener)listener).messageNotDelivered(this);
		else // MESSAGE_PARTIALLY_DELIVERED
			((TransportListener)listener).messagePartiallyDelivered(this);
	}

}
