/*
 * Copyright 1996-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

/**
 * Ԉ`̃AhXoꂽɃX[OłB
 */
public final class AddressException extends ParseException {

	private static final long serialVersionUID = 9134583443539323120L;

	/**
	 * \͂镶łB
	 * 
	 * @serial
	 */
	protected String ref = null;

	/**
	 * G[񒆂̃CfbNXA͕s̏ꍇ -1 ɂȂ܂B
	 * 
	 * @serial
	 */
	protected int pos = -1;

	/**
	 * ڍ׃bZ[Ww肵Ȃ AddressException \z܂B
	 */
	public AddressException() {
		super();
	}

	/**
	 * w肳ꂽڍ׃bZ[W AddressException \z܂B
	 * 
	 * @param s ڍ׃bZ[W
	 */
	public AddressException(final String s) {
		super(s);
	}

	/**
	 * w肳ꂽڍ׃bZ[WƎQƏ AddressException \z܂B
	 * 
	 * @param s ڍ׃bZ[W
	 */
	public AddressException(final String s, final String ref) {
		super(s);
		this.ref = ref;
	}

	/**
	 * w肳ꂽڍ׃bZ[WƎQƏ AddressException \z܂B
	 * 
	 * @param s ڍ׃bZ[W
	 */
	public AddressException(final String s, final String ref, final int pos) {
		super(s);
		this.ref = ref;
		this.pos = pos;
	}

	/**
	 * G[oꂽɍ\͂Ă (֘AȂꍇ null) 擾܂B
	 */
	public String getRef() {
		return ref;
	}

	/**
	 * G[oꂽQƕ̈ʒu (֘AȂꍇ -1) 擾܂B
	 */
	public int getPos() {
		return pos;
	}

	public String toString() {
		String s = super.toString();
		if (ref == null)
		    return s;
		s += " in string ``" + ref + "''";
		if (pos < 0)
		    return s;
		return s + " at position " + pos;
	}

}
