/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

/**
 * ̃NX MIME ContentDisposition l\܂B
 *  ContentDisposition ʂ̃R|[lgɍ\͂A
 * MIME ` ContentDisposition 𐶐@񋟂܂B
 */
public final class ContentDisposition {

	private String disposition;	// disposition
	private ParameterList list;	// parameter list

	/**
	 * Ȃ̃RXgN^łB
	 */
	public ContentDisposition() {}

	/**
	 * RXgN^łB
	 * 
	 * @param disposition ݒ
	 * @param list ParameterList
	 * @since JavaMail 1.2
	 */
	public ContentDisposition(final String disposition, final ParameterList list) {
		this.disposition = disposition;
		this.list = list;
	}

	/**
	 * ContentDisposition 擾RXgN^łB
	 * String ͍\vfłݒƃp[^ɍ\͂܂B
	 * \͂Ɏs ParseException X[܂B
	 * 
	 * @param s ContentDisposition 
	 * @throws ParseException \͂Ɏsꍇ
	 * @since JavaMail 1.2
	 */
	public ContentDisposition(final String s) throws ParseException {
		HeaderTokenizer h = new HeaderTokenizer(s, HeaderTokenizer.MIME);
		// First "disposition" ..
		HeaderTokenizer.Token tk = h.next();

		if (tk.getType() != HeaderTokenizer.Token.ATOM)
			throw new ParseException();
		disposition = tk.getValue();

		// Then parameters ..
		String rem = h.getRemainder();
		if (rem != null)
			list = new ParameterList(rem);
	}

	/**
	 * ݒlԂ܂B
	 * 
	 * @return ݒ
	 * @since JavaMail 1.2
	 */
	public String getDisposition() {
		return disposition;
	}

	/**
	 * w肳ꂽp[^lԂ܂B
	 * ̃p[^̏ꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return p[^l
	 * @since JavaMail 1.2
	 */
	public String getParameter(final String name) {
		if (list == null)
			return null;
		return list.get(name);
	}

	/**
	 * gp\ȑSẴp[^ێ ParameterList IuWFNgԂ܂B
	 * gp\ȃp[^Ȃꍇ null Ԃ܂B
	 * 
	 * @return ParameterList
	 * @since JavaMail 1.2
	 */
	public ParameterList getParameterList() {
		return list;
	}

	/**
	 * vC}^Cvݒ肵܂B̃vC}^CvI[o[Ch܂B
	 * 
	 * @param disposition vC}^Cv
	 * @since JavaMail 1.2
	 */
	public void setDisposition(final String disposition) {
		this.disposition = disposition;
	}

	/**
	 * w肳ꂽp[^ݒ肵܂B
	 * ̃p[^ɑ݂ꍇA̐VlŒu܂B
	 * 
	 * @param name p[^
	 * @param value p[^l
	 * @since JavaMail 1.2
	 */
	public void setParameter(final String name, final String value) {
		if (list == null)
			list = new ParameterList();
		list.set(name, value);
	}

	/**
	 * V ParameterList ݒ肵܂B
	 * 
	 * @param list ParameterList
	 * @since JavaMail 1.2
	 */
	public void setParameterList(final ParameterList list) {
		this.list = list;
	}

	/**
	 *  ContentDisposition  RFC2045 `\擾܂B
	 * ϊɎsꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return RFC2045 `
	 * @since JavaMail 1.2
	 */
	public String toString() {
		if (disposition == null)
			return null;
		if (list == null)
			return disposition;
		StringBuffer sb = new StringBuffer(disposition);
		// append the parameter list  
		// use the length of the string buffer + the length of 
		// the header name formatted as follows "Content-Disposition: "
		sb.append(list.toString(sb.length() + 21));
		return sb.toString();
	}

}
