/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

/**
 * ̃NX MIME ContentType l\܂B
 *  ContentType ʂ̃R|[lgɍ\͂A
 * MIME ` ContentType 𐶐@񋟂܂B
 */
public final class ContentType {

	private String primaryType;	// primary type
	private String subType;		// subtype
	private ParameterList list;	// parameter list

	/**
	 * Ȃ̃RXgN^łB
	 */
	public ContentType() {}

	/**
	 * RXgN^łB
	 * 
	 * @param primaryType vC}^Cv
	 * @param subType subType
	 * @param list ParameterList
	 */
	public ContentType(
		final String primaryType,
		final String subType, 
		final ParameterList list) {

		this.primaryType = primaryType;
// Sugisawa added. 2005/03/04
if ("text".equalsIgnoreCase(primaryType) && (subType == null || subType.length() <= 0))
	this.subType = "plain";
else
		this.subType = subType;
		this.list = list;
	}

	/**
	 * Content-Type 擾RXgN^łB
	 * String ͍\vfłvC}^CvAsubTypeA
	 * yуp[^ɍ\͂܂B\͂Ɏs ParseException X[܂B
	 * 
	 * @param s Content-Type 
	 * @throws ParseException \͂Ɏsꍇ
	 */
	public ContentType(final String s) throws ParseException {
		HeaderTokenizer h = new HeaderTokenizer(s, HeaderTokenizer.MIME);
		// First "type" ..
		HeaderTokenizer.Token tk = h.next();

		if (tk.getType() != HeaderTokenizer.Token.ATOM)
			throw new ParseException();
		primaryType = tk.getValue();

		// The '/' separator ..
		tk = h.next();
// Sugisawa added. 2005/03/04
if ("text".equalsIgnoreCase(primaryType) && (char)tk.getType() != '/') {
	subType = "plain";
	return;
}
		if ((char)tk.getType() != '/')
			throw new ParseException();

		// Then "subType" ..
		tk = h.next();
		if (tk.getType() != HeaderTokenizer.Token.ATOM)
			throw new ParseException();
		subType = tk.getValue();

		// Finally parameters ..
		String rem = h.getRemainder();
		if (rem != null)
			list = new ParameterList(rem);
	}

	/**
	 * vC}^CvԂ܂B
	 * 
	 * @return vC}^Cv
	 */
	public String getPrimaryType() {
		return primaryType;
	}

	/**
	 * subType Ԃ܂B
	 * 
	 * @return subType
	 */
	public String getSubType() {
		return subType;
	}

	/**
	 * MIME ^Cvp[^ȂŕԂ܂B
	 * Ԃl͊{I primaryTypeA'/' Ay secondaryType AłB
	 * 
	 * @return ^Cv
	 */
	public String getBaseType() {
		return primaryType + '/' + subType;
	}

	/**
	 * w肳ꂽp[^lԂ܂B
	 * ̃p[^̏ꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return p[^l
	 */
	public String getParameter(final String name) {
		if (list == null)
			return null;
		return list.get(name);
	}

	/**
	 * gp\ȑSẴp[^ێ ParameterList IuWFNgԂ܂B
	 * gp\ȃp[^Ȃꍇ null Ԃ܂B
	 * 
	 * @return ParameterList
	 */
	public ParameterList getParameterList() {
		return list;
	}

	/**
	 * vC}^Cvݒ肵܂B̃vC}^CvI[o[Ch܂B
	 * 
	 * @param primaryType vC}^Cv
	 */
	public void setPrimaryType(final String primaryType) {
		this.primaryType = primaryType;
	}

	/**
	 * subType ݒ肵܂B subType I[o[Ch܂B
	 * 
	 * @param subType subType
	 */
	public void setSubType(final String subType) {
		this.subType = subType;
	}

	/**
	 * w肳ꂽp[^ݒ肵܂B
	 * ̃p[^łɑ݂ꍇA̐VlŒu܂B
	 * 
	 * @param name p[^
	 * @param value p[^l
	 */
	public void setParameter(final String name, final String value) {
		if (list == null)
			list = new ParameterList();
		list.set(name, value);
	}

	/**
	 * V ParameterList ݒ肵܂B
	 * 
	 * @param list ParameterList
	 */
	public void setParameterList(final ParameterList list) {
		this.list = list;
	}

	/**
	 *  Content-Type  RFC2045 `\擾܂B
	 * ϊɎsꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return RFC2045 `
	 */
	public String toString() {
		if (primaryType == null || subType == null) // need both
			return null;

		StringBuffer sb = new StringBuffer();
		sb.append(primaryType).append('/').append(subType);
		if (list != null)
			// append the parameter list 
			// use the length of the string buffer + the length of
			// the header name formatted as follows "Content-Type: "
			sb.append(list.toString(sb.length() + 14));

		return sb.toString();
	}

	/**
	 * w肳ꂽ ContentType IuWFNgƏƍ܂B
	 * ̃\bh́A<strong><code>primaryType</code>  <code>subType</code> ݂̂r܂</strong>B
	 * ҂̃Iyh̃p[^͖܂B<p>
	 * 
	 * Ⴆ΁Ã\bh <strong>"text/plain"</strong> 
	 *  <strong>"text/plain; charset=Shift_JIS"</strong>  ContentType r <code>true</code> Ԃ܂B
	 * 
	 * ꂩ̃Iyh <code>subType</code> ꕶ '*' ̏ꍇA
	 *  subtype ͔rɖ܂B
	 * Ⴆ΁Ã\bh <strong>"text/plain"</strong>  <strong>"text/*"</strong> 
	 *  ContentType r true Ԃ܂B
	 * 
	 * @param cType ȓΏۂ ContentType
	 */
	public boolean match(final ContentType cType) {
		// Match primaryType
		if (!primaryType.equalsIgnoreCase(cType.getPrimaryType()))
			return false;

		String sType = cType.getSubType();

		// If either one of the subTypes is wildcarded, return true
		if ((subType.charAt(0) == '*') || (sType.charAt(0) == '*'))
			return true;

		// Match subType
		return subType.equalsIgnoreCase(sType);
	}

	/**
	 * w肳ꂽRec^Əƍ܂B
	 * ̃\bh́A<strong><code>primaryType</code>  <code>subType</code> ݂̂r܂</strong>B
	 * ҂̃Iyh̃p[^͖܂B<p>
	 * 
	 * Ⴆ΁Ã\bh <strong>"text/plain"</strong> 
	 *  <strong>"text/plain; charset=Shift_JIS"</strong>  ContentType r <code>true</code> Ԃ܂B
	 * 
	 * ꂩ̃Iyh <code>subType</code> ꕶ '*' ̏ꍇA
	 *  subtype ͔rɖ܂B
	 * Ⴆ΁Ã\bh <strong>"text/plain"</strong>  <strong>"text/*"</strong> 
	 *  ContentType r true Ԃ܂B
	 */
	public boolean match(final String s) {
		try {
			return match(new ContentType(s));
		} catch (ParseException pex) {
			return false;
		}
	}

}
