/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

import javax.mail.Header;
import javax.mail.MessagingException;

import com.sun.mail.util.LineInputStream;

/**
 * InternetHeaders  RFC822 `̃wb_Ǘ郆[eBeBNXłB
 * RFC822 `̃bZ[WXg[ɂăwb_̏I󔒍s܂ōsǂݎ܂B
 * ̓Xg[͖{̍ŏɈʒut܂B
 * ǂݍ܂ꂽs̓IuWFNg̓Ɋi[A
 * String  Header IuWFNgƂĎoł܂B<p>
 * 
 * ̃NX͎ƂăT[rXvoC_łB
 * MimeMessage y MimeBody ̓wb_ێׂɂ̃NXgp܂B<p>
 * 
 * <hr> <strong>RFC822 y MIME wb_Ɋւ郁</strong><p>
 * 
 * RFC822 y MIME wb_tB[h US-ASCII ܂܂Ȃ<strong>Ȃ܂</strong>B
 * wb_ US-ASCII ȊO̕܂ޏꍇARFC 2047 ̋Kɏ]ăGR[hȂ΂Ȃ܂B
 * ̃pbP[WŒ񋟂 MimeUtility NXpāAsł܂B
 * <code>setHeader</code>A<code>addHeader</code>Ay <code>addHeaderLine</code> \bh
 * Ăяo͎w肳ꂽwb_ MIME vɏ]Ă鎖ۏ؂Ȃ΂Ȃ܂B
 * Ãwb_tB[h]ɂs̒ (SMTP ̏ꍇ 1000oCg) 𒴂
 * ꍇ͑M̑Oɐ܂肽 (bv) Kv܂B
 * Mwb_͐܂肽܂Ă\܂B
 * AvP[V̓wb_K؂ɐ܂肽݁AWJӔC܂B<p>
 * 
 * @see javax.mail.internet.MimeUtility
 */
public final class InternetHeaders {

	/*
	 * The enumeration object used to enumerate an
	 * InternetHeaders object.  Can return
	 * either a String or a Header object.
	 */
	static final class matchEnum implements Enumeration {

		private Iterator e;			// enum object of headers Vector
		// XXX - is this overkill?  should we step through in index
		// order instead?
		private String names[];		// names to match, or not
		private boolean match;		// return matching headers?
		private boolean want_line;	// return header lines?
		private InternetHeader next_header;		// the next header to be returned

		/*
		 * Constructor.  Initialize the enumeration for the entire
		 * Vector of headers, the set of headers, whether to return
		 * matching or non-matching headers, and whether to return
		 * header lines or Header objects.
		 */
		matchEnum(final List list, final String n[], final boolean m, final boolean l) {
			e = list.iterator();
			names = n;
			match = m;
			want_line = l;
			next_header = null;
		}

		/*
		 * Any more elements in this enumeration?
		 */
		public boolean hasMoreElements() {
			// if necessary, prefetch the next matching header,
			// and remember it.
			if (next_header == null)
				next_header = nextMatch();
			return (next_header != null);
		}

		/*
		 * Return the next element.
		 */
		public Object nextElement() {
			if (next_header == null)
				next_header = nextMatch();

			if (next_header == null)
				throw new NoSuchElementException("No more headers");

			InternetHeader h = next_header;
			next_header = null;
			if (want_line)
				return h.line;
			return new Header(h.getName(), h.getValue());
		}

		/*
		 * Return the next hdr object according to the match
		 * criteria, or null if none left.
		 */
		private InternetHeader nextMatch() {
			next:
			while (e.hasNext()) {
				InternetHeader h = (InternetHeader) e.next();

				// skip "place holder" headers
				if (h.line == null)
					continue;

				// if no names to match against, return appropriately
				if (names == null)
					return match ? null : h;

				// check whether this header matches any of the names
				for (int i = 0; i < names.length; i++) {
					if (names[i].equalsIgnoreCase(h.getName())) {
						if (match)
							return h;
						// found a match, but we're
						// looking for non-matches.
						// try next header.
						continue next;
					}
				}
				// found no matches.  if that's what we wanted, return it.
				if (!match)
					return h;
			}
			return null;
		}

	}

	/*
	 * A private utility class to represent an individual header.
	 * A hdr object with a null line field is used as a "place holder"
	 * for headers of that name, to preserve order of headers.
	 */
	static final class InternetHeader extends Header {

		// XXX - should name be stored in lower case?
		String line;    // the entire RFC822 header "line", or null if place holder

		/*
		 * Constructor that takes a line and splits out
		 * the header name.
		 */
		public InternetHeader(final String l) {
			super("", "");
			int i = l.indexOf(':');
			if (i < 0)
				// should never happen
				name = l.trim();
			else
				name = l.substring(0, i).trim();
			line = l;
		}

		/*
		 * Constructor that takes a header name and value.
		 */
		public InternetHeader(final String n, final String v) {
			super(n, "");
			if (v != null)
				line = n + ": " + v;
			else
				line = null;
		}

		/*
		 * Return the "value" part of the header line.
		 */
		public String getValue() {
			int i = line.indexOf(':');
			if (i < 0)
				return line;
			// skip whitespace after ':'
			int j;
			for (j = i + 1; j < line.length(); j++) {
				char c = line.charAt(j);
				if (c != ' ' && c != '\t' && c != '\r' && c != '\n')
					break;
			}
			return line.substring(j);
		}

	}

	/**
	 * The actual list of Headers, including placeholder entries.
	 * Placeholder entries are Headers with a null value and are never seen by clients of the InternetHeaders class.
	 * Placeholder entries are used to keep track of the preferred order of headers.
	 * Headers are never actually removed from the list, they're converted into placeholder entries.
	 * New headers are added after existing headers of the same name (or before in the case of Received and Return-Path headers).
	 * If no existing header or placeholder for the header is found, new headers are added after the special placeholder with the name ":".
	 * 
	 * @since JavaMail 1.4
	 */
	protected List headers = new ArrayList(40);

	/**
	 *  InternetHeaders IuWFNg쐬܂B
	 */
	public InternetHeaders() { 
		headers.add(new InternetHeader("Return-Path", null));
		headers.add(new InternetHeader("Received", null));
		headers.add(new InternetHeader("Resent-Date", null));
		headers.add(new InternetHeader("Resent-From", null));
		headers.add(new InternetHeader("Resent-Sender", null));
		headers.add(new InternetHeader("Resent-To", null));
		headers.add(new InternetHeader("Resent-Cc", null));
		headers.add(new InternetHeader("Resent-Bcc", null));
		headers.add(new InternetHeader("Resent-Message-Id", null));
		headers.add(new InternetHeader("Date", null));
		headers.add(new InternetHeader("From", null));
		headers.add(new InternetHeader("Sender", null));
		headers.add(new InternetHeader("Reply-To", null));
		headers.add(new InternetHeader("To", null));
		headers.add(new InternetHeader("Cc", null));
		headers.add(new InternetHeader("Bcc", null));
		headers.add(new InternetHeader("Message-Id", null));
		headers.add(new InternetHeader("In-Reply-To", null));
		headers.add(new InternetHeader("References", null));
		headers.add(new InternetHeader("Subject", null));
		headers.add(new InternetHeader("Comments", null));
		headers.add(new InternetHeader("Keywords", null));
		headers.add(new InternetHeader("Errors-To", null));
		headers.add(new InternetHeader("MIME-Version", null));
		headers.add(new InternetHeader("Content-Type", null));
		headers.add(new InternetHeader("Content-Transfer-Encoding", null));
		headers.add(new InternetHeader("Content-MD5", null));
		headers.add(new InternetHeader(":", null));
		headers.add(new InternetHeader("Content-Length", null));
		headers.add(new InternetHeader("Status", null));
	}

	/**
	 * w肳ꂽ RFC822 bZ[WXg[Awb_Ɩ{𕪂󔒍s܂œǂݎ\͂܂B
	 * ̓Xg[͖{̍ŏɈʒut܂Bwb_s͓Ɋi[܂B<p>
	 * 
	 * ׁ̈ABufferedInputStream ۂ̓̓Xg[̎ɃbvAp[^ƂēnĉB
	 * 
	 * @param is RFC822 ̓Xg[
	 */
	public InternetHeaders(final InputStream is) throws MessagingException {
		load(is);
	}

	/**
	 * w肳ꂽ RFC822 bZ[WXg[Awb_Ɩ{𕪂󔒍s܂œǂݎ\͂܂B
	 * wb_s InternetHeaders IuWFNg̓Ɋi[܂B
	 * wb_s̃I[_ۑ܂B<p>
	 * 
	 * wb_s͂ InternetHeaders IuWFNgɒǉׁA
	 * ̃IuWFNgɂ̃wb_͉e󂯂܂B
	 * 
	 * @param is RFC822 ̓Xg[
	 */
	public void load(final InputStream is) throws MessagingException {
		// Read header lines until a blank line. It is valid
		// to have BodyParts with no header lines.
		LineInputStream lis = new LineInputStream(is);
		String prevline = null;	// the previous header line, as a string
		// a buffer to accumulate the header in, when we know it's needed
		StringBuffer lineBuffer = new StringBuffer();

		try {
			String line;
			do {
				line = lis.readLine();
				if (line != null && (line.startsWith(" ") || line.startsWith("\t"))) {
					// wb_̑
					if (prevline != null) {
						lineBuffer.append(prevline);
						prevline = null;
					}
					lineBuffer.append("\r\n");
					lineBuffer.append(line);
				} else {
					// Vwb_
					if (prevline != null)
						addHeaderLine(prevline);
					else if (lineBuffer.length() > 0) {
						// store previous header first
						addHeaderLine(lineBuffer.toString());
						lineBuffer.setLength(0);
					}
					prevline = line;
				}
			} while(line != null && line.length() > 0);
		} catch (IOException ioex) {
			throw new MessagingException("Error in input stream", ioex);
		}
	}

	/**
	 * w肳ꂽwb_̑SĂ̒lԂ܂Bl String IuWFNgłB
	 * Returns <code>null</code> if no headers with the specified name exist.
	 * 
	 * @param name wb_
	 * @return array of header values, or null if none
	 */
	public String[] getHeader(final String name) {
		Iterator iterator = headers.iterator();
		ArrayList list = new ArrayList();	// accumulate return values

		while (iterator.hasNext()) {
			InternetHeader h = (InternetHeader) iterator.next();
			if (name.equalsIgnoreCase(h.getName()) && h.line != null)
				list.add(h.getValue());
		}

		if (list.size() == 0)
            return null;

		// convert List to an array for return
		String r[] = new String[list.size()];
		r = (String[]) list.toArray(r);
		return r;
	}

	/**
	 * ̃wb_̑SẴwb_擾A؂蕶ŋ؂ꂽwb_P String ƂĕԂ܂B
	 * ؂蕶 <code>null</code> ̏ꍇ͍ŏ̃wb_Ԃ܂B
	 * Returns <code>null</code> if no headers with the specified name exist.
	 * 
	 * @param name wb_
	 * @param delimiter ؂蕶
	 * @return ̖OSẴwb_ɑ΂ltB[h
	 */
	public String getHeader(final String name, final String delimiter) {
		String s[] = getHeader(name);

		if (s == null)
			return null;

		if ((s.length == 1) || delimiter == null)
			return s[0];

		StringBuffer r = new StringBuffer(s[0]);
		for (int i = 1; i < s.length; i++) {
			r.append(delimiter);
			r.append(s[i]);
		}
		return r.toString();
	}

	/**
	 * OɈvŏ̃wb_s̒lύX܂B
	 * ṽwb_Ȃꍇ͐Vwb_ǉ܂B
	 * ŏ̃wb_ȊȎSĂ̈vwb_폜܂B<p>
	 * 
	 * RFC822 wb_ US-ASCII ܂ގ\ł_ɒӂĉB
	 * 
	 * @param name wb_
	 * @param value wb_l
	 */
	public void setHeader(final String name, final String value) {
		boolean found = false;

		for (int i = 0; i < headers.size(); i++) {
			InternetHeader h = (InternetHeader) headers.get(i);
			if (name.equalsIgnoreCase(h.getName())) {
				if (!found) {
					int j;
					if (h.line != null && (j = h.line.indexOf(':')) >= 0)
						h.line = h.line.substring(0, j + 1) + ' ' + value;
					else
						h.line = name + ": " + value;
					found = true;
				} else {
					headers.remove(i);
					i--;    // have to look at i again
				}
			}
		}

		if (!found)
			addHeader(name, value);
	}

	/**
	 * w肳ꂽOƒlwb_wb_Xgɒǉ܂B<p>
	 * 
	 * The current implementation knows about the preferred order of most
	 * well-known headers and will insert headers in that order.  In
	 * addition, it knows that <code>Received</code> headers should be
	 * inserted in reverse order (newest before oldest), and that they
	 * should appear at the beginning of the headers, preceeded only by
	 * a possible <code>Return-Path</code> header.  <p>
	 * 
	 * RFC822 wb_ US-ASCII ܂ގ\ł_ɒӂĉB
	 * 
	 * @param name wb_
	 * @param value wb_l
	 */
	public void addHeader(final String name, final String value) {
		int pos = headers.size();
		boolean isReceived = name.equalsIgnoreCase("Received") || name.equalsIgnoreCase("Return-Path");
		if (isReceived)
			pos = 0;
		for (int i = headers.size() - 1; i >= 0; i--) {
			InternetHeader h = (InternetHeader) headers.get(i);
			if (name.equalsIgnoreCase(h.getName())) {
				if (isReceived)
					pos = i;
				else {
					headers.add(i + 1, new InternetHeader(name, value));
					return;
				}
			}
			// marker for default place to add new headers
			if (h.getName().equals(":"))
		    	pos = i;
		}
		headers.add(pos, new InternetHeader(name, value));
	}

	/**
	 * w肳ꂽOɈvSẴwb_Gg폜܂B
	 * 
	 * @param name wb_
	 */
	public void removeHeader(final String name) { 
		for (int i = 0; i < headers.size(); i++) {
			InternetHeader h = (InternetHeader) headers.get(i);
			if (name.equalsIgnoreCase(h.getName())) {
				h.line = null;
				//headers.removeElementAt(i);
				//i--;    // have to look at i again
			}
		}
	}

	/**
	 * SẴwb_ {@link javax.mail.Header} IuWFNg Enumeration ƂĕԂ܂B
	 * 
	 * @return Header IuWFNg	
	 */
	public Enumeration getAllHeaders() {
		return (new matchEnum(headers, null, false, false));
	}

	/**
	 * vSĂ {@link javax.mail.Header} IuWFNgԂ܂B
	 * 
	 * @return v Header IuWFNg	
	 */
	public Enumeration getMatchingHeaders(final String[] names) {
		return (new matchEnum(headers, names, true, false));
	}

	/**
	 * vȂSĂ {@link javax.mail.Header} IuWFNgԂ܂B
	 * 
	 * @return vȂ Header IuWFNg	
	 */
	public Enumeration getNonMatchingHeaders(final String[] names) {
		return (new matchEnum(headers, names, false, false));
	}

	/**
	 * RFC822 wb_swb_XgAɒǉ܂B
	 * s̐擪Xy[X̓^ȕꍇ (ps) ́AXg̍Ō̃wb_sɒǉ܂B
	 * Otherwise, append the new header line to the list.<p>
	 * 
	 * RFC822 wb_ US-ASCII ܂ގ\ł_ɒӂĉB
	 * 
	 * @param line  RFC822 wb_s
	 */
	public void addHeaderLine(final String line) {
		try {
			char c = line.charAt(0);
			if (c == ' ' || c == '\t') {
				InternetHeader h = (InternetHeader) headers.get(headers.size() - 1);
				h.line += "\r\n" + line;
			} else
				headers.add(new InternetHeader(line));
		} catch (StringIndexOutOfBoundsException e) {
			// s̏ꍇ͖
		} catch (NoSuchElementException e) {
			// XXX - vector is empty?
		}
	}

	/**
	 * SẴwb_s String ̗񋓌^ƂĕԂ܂B
	 */
	public Enumeration getAllHeaderLines() { 
		return (getNonMatchingHeaderLines(null));
	}

	/**
	 * vSẴwb_s String ̗񋓌^ƂĕԂ܂B
	 */
	public Enumeration getMatchingHeaderLines(final String[] names) {
		return (new matchEnum(headers, names, true, true));	
	}

	/**
	 * vȂSẴwb_s String ̗񋓌^ƂĕԂ܂B
	 */
	public Enumeration getNonMatchingHeaderLines(final String[] names) {
		return (new matchEnum(headers, names, false, true));
	}

}
