/*
 * Copyright 1993-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

/**
 * 2000 N 1  26 t draft-ietf-drums-msg-fmt-08 ɊÂA
 * tdltH[}bgyэ\͂܂B RFC822 ̑ΉdlłB<p>
 * 
 * ̃NX̓p^[gp܂B
 * ɉL̎dlɊÂttH[}bg܂B<p>
 * 
 * 3.3 tю̎dl<p>
 * 
 * tƎ̓bZ[Ŵ̃wb_tB[hɌ܂B
 * ̃ZNV͊Sȓtyюdl̍\w肵܂B
 * tƎdl̑Ŝŋ󔒕܂肽ގF߂Ă܂A
 * FWS s̏ꍇłP̃Xy[XgpA
 * tƎdl FWS IvV̏ꍇ̓Xy[XgpȂ𐄏܂B
 * ȑO̎̈ꕔł͑̋󔒐܂肽݂̏o𐳂߂łȂꍇ܂B<p>
 * 
 * date-time = [ day-of-week "," ] date FWS time [CFWS]<p>
 * 
 * day-of-week = ([FWS] day-name) / obs-day-of-week<p>
 * 
 * day-name = "Mon" / "Tue" / "Wed" / "Thu" / "Fri" / "Sat" / "Sun"<p>
 * 
 * date = day month year<p>
 * 
 * year = 4*DIGIT / obs-year<p>
 * 
 * month = (FWS month-name FWS) / obs-month<p>
 * 
 *<pre>month-name = "Jan" / "Feb" / "Mar" / "Apr" /
 *             "May" / "Jun" / "Jul" / "Aug" /
 *             "Sep" / "Oct" / "Nov" / "Dec"
 * </pre><p>
 * day = ([FWS] 1*2DIGIT) / obs-day<p>
 * 
 * time = time-of-day FWS zone<p>
 * 
 * time-of-day = hour ":" minute [ ":" second ]<p>
 * 
 * hour = 2DIGIT / obs-hour<p>
 * 
 * minute = 2DIGIT / obs-minute<p>
 * 
 * second = 2DIGIT / obs-second<p>
 * 
 * zone = (( "+" / "-" ) 4DIGIT) / obs-zone<p>
 * 
 * day ͌̉Ԗڂ̓𐔎Ŏ܂Byear ͈ʓIȗN𐔎Ŏ܂B<p>
 * 
 * time-of-day ͎w肳ꂽťߑO뎞Ƃ鎞AAyуIvVƂĕb𐔎Ŏw肵܂B<p>
 * 
 * date  time-of-day ͕K[J̎Ԃ\Ȃ΂Ȃ܂B<p>
 * 
 * zone ́Adate  time-of-day \ Coordinated Universal Time (UTCA
 * ɂ "OjbWW" ƌ܂) ̃ItZbgw肵܂B
 * "+"  "-"  time-of-day  Universal Time ił邩xĂ邩܂B
 * ŏ 2  Universal Time Ƃ̎Ԑ̍A
 * Ō 2  Universal Time Ƃ̍̕܂ (]āA+hhmm  +(hh * 60 + mm) A
 * -hhmm  -(hh * 60 + mm) ꂼӖ܂)B
 * Universal Time ̃^C][ɂ "+0000" Ƃ`gpȂ΂Ȃ܂B
 * "-0000"  Universal Time ܂A
 * Universal Time Ƃ͈قȂ郍[J^C][ɂVXeŐꂽԂׂɎgp܂B<p>
 * 
 * date-time dl͈ӖIɗLłȂ΂Ȃ܂B
 * ܂Aday-of-the week (܂܂ꍇ)  date ŎłȂ΂Ȃ܂B
 * l day-of-month  1  (w肳ꂽN) w肳ꂽŋƂ̊ԂɂȂ΂Ȃ܂B
 * time-of-day  00:00:00  23:59:60 (邤NŋbB[STD-12] Q) ̊ԂɂȂ΂Ȃ܂B
 * zone  -9959  +9959 ܂ł̊ԂɂȂ΂Ȃ܂B<p>
 * 
 * @since JavaMail 1.2
 */
public final class MailDateFormat extends SimpleDateFormat {

	private static final long serialVersionUID = -8148227605210628779L;

	public MailDateFormat() {
		super("EEE, d MMM yyyy HH:mm:ss 'XXXXX' (z)", Locale.US);
	}

	/**
	 * w肳ꂽt݂ TimeZone  draft-ietf-drums-msg-fmt-08 Ŏw肳`ɃtH[}bg܂B
	 * 
	 * @param date Date IuWFNg
	 * @param dateStrBuf tH[}bgꂽ
	 * @param fieldPosition ݂̃tB[hʒu
	 * @return StringBuffer tH[}bgꂽ String
	 * @since JavaMail 1.2
	 */
	public StringBuffer format(
		final Date date,
		final StringBuffer dateStrBuf,
		final FieldPosition fieldPosition) {

		/* How this method works: First format the date with the
		 * format specified in the constructor inserting string 'XXXXX' 
		 * where the timezone offset goes. Find where in the string the
		 * string 'XXXXX' appears and remember that in var "pos". 
		 * Calculate the offset, taking the DST into account and insert
		 * it into the stringbuffer at position pos.
		 */

		int start = dateStrBuf.length();
		super.format(date, dateStrBuf, fieldPosition);
		int pos = 0;
		// find the beginning of the 'XXXXX' string in the formatted date
		// 25 is the first position that we expect to find XXXXX at
		for (pos = start + 25; dateStrBuf.charAt(pos) != 'X'; pos++)
			;

		// set the timezone to +HHMM or -HHMM
		calendar.clear();
		calendar.setTime(date);
		int offset = calendar.get(Calendar.ZONE_OFFSET) + calendar.get(Calendar.DST_OFFSET);
		// take care of the sign
		if (offset < 0) {
			dateStrBuf.setCharAt(pos++, '-');
			offset = (-offset);
		} else
			dateStrBuf.setCharAt(pos++, '+');

		int rawOffsetInMins = offset / 60 / 1000; // offset from GMT in mins
		int offsetInHrs = rawOffsetInMins / 60;
		int offsetInMins = rawOffsetInMins % 60;

		dateStrBuf.setCharAt(pos++, Character.forDigit((offsetInHrs / 10), 10));
		dateStrBuf.setCharAt(pos++, Character.forDigit((offsetInHrs % 10), 10));
		dateStrBuf.setCharAt(pos++, Character.forDigit((offsetInMins / 10), 10));
		dateStrBuf.setCharAt(pos++, Character.forDigit((offsetInMins % 10), 10));
		// done with timezone

		return dateStrBuf;
	}

	////////////////////////////////////////////////////////////

	/**
	 * w肳ꂽt݂ TimeZone  draft-ietf-drums-msg-fmt-08 Ŏw肳`ō\͂܂B
	 * 
	 * @param text \͂`ꂽt
	 * @param pos ݂̍\͈ʒu
	 * @return Date IuWFNg̍\͂ꂽt
	 * @since JavaMail 1.2
	 */
	public Date parse(final String text, final ParsePosition pos) {
		return parseDate(text.toCharArray(), pos, isLenient());
	}

	/*
	 Valid Examples:

		Date: Sun, 21 Mar 1993 23:56:48 -0800 (PST)
		Date: 
		Date: Mon, 22 Mar 1993 09:41:09 -0800 (PST)
		Date:     26 Aug 76 14:29 EDT
	*/

	/**
	 * method of what to look for:
	 *
	 *
	 *	skip WS
	 *	skip day ","  	(this is "Mon", "Tue")
	 *	skip WS
	 *
	 *	parse number (until WS) ==> 1*2DIGIT (day of month)
	 *
	 *	skip WS
	 *
	 *	parse alpha chars (until WS) ==> find month
	 *
	 *	skip WS
	 *
	 *	parse number (until WS) ==> 2*4DIGIT (year)
	 *
	 *	skip WS
	 *
	 *	// now looking for time
	 *	parse number (until ':') ==> hours
	 *	parse number (until ':') ==> minutes
	 *	parse number (until WS) ==> seconds
	 *
	 *	// now look for Time Zone
	 *	skip WS
	 *	if ('+' or '-') then numerical time zone offset
	 *  if (alpha) then alpha time zone offset
	 */

	static boolean debug = false;

	/**
	 * create a Date by parsing the char array
	 */
	private static Date parseDate(final char[] orig, final ParsePosition pos, final boolean lenient) {
		try {
			int day = -1;
			int month = -1;
			int year = -1;
			int hours = 0;
			int minutes = 0;
			int seconds = 0;
			int offset = 0;

			MailDateParser p = new MailDateParser(orig);

			// get the day
			p.skipUntilNumber();
			day = p.parseNumber();

			if (!p.skipIfChar('-'))  // for IMAP internal Date
				p.skipWhiteSpace();

			// get the month		
			month = p.parseMonth();
			if (!p.skipIfChar('-'))  // for IMAP internal Date
				p.skipWhiteSpace();

			// get the year
			year = p.parseNumber();	// should not return a negative number
			if (year < 50)
				year += 2000;
			else if (year < 100)
				year += 1900;
			// otherwise the year is correct (and should be 4 digits)

			// get the time
			// first get hours
			p.skipWhiteSpace();
			hours = p.parseNumber();

			// get minutes
			p.skipChar(':');
			minutes = p.parseNumber();

			// get seconds  (may be no seconds)
			if (p.skipIfChar(':'))
				seconds = p.parseNumber();

			// try to get a Time Zone
			try {
				p.skipWhiteSpace();
				offset = p.parseTimeZone();
			} catch (ParseException pe) {
				if (debug)
				    System.out.println("No timezone? : '" + String.valueOf(orig) + "'");
			}

			pos.setIndex(p.getIndex());
			Date d = ourUTC(year, month, day, hours, minutes, seconds, offset, lenient);
			return d;
		} catch (Exception e) {
			// Catch *all* exceptions, including RuntimeExceptions like
			// ArrayIndexOutofBoundsException ... we need to be
			// extra tolerant of all those bogus dates that might screw
			// up our parser. Sigh.
			if (debug) {
				System.out.println("Bad date: '" + String.valueOf(orig) + "'");
				e.printStackTrace();
			}
		}
		pos.setIndex(1); // to prevent DateFormat.parse() from throwing ex
		return null;
	}

	private static TimeZone tz = TimeZone.getTimeZone("GMT");
	private static Calendar cal = new GregorianCalendar(tz);

	private static synchronized Date ourUTC(
		final int year, final int mon, final int mday,
		final int hour, final int min, final int sec,
		final int tzoffset, final boolean lenient) {

		// clear the time and then set all the values
		cal.clear();
		cal.setLenient(lenient);
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, mon);
		cal.set(Calendar.DATE, mday);
		cal.set(Calendar.HOUR_OF_DAY, hour);
		cal.set(Calendar.MINUTE, min + tzoffset);  // adjusted for the timezone
		cal.set(Calendar.SECOND, sec);

		return cal.getTime();
	}	

	////////////////////////////////////////////////////////////

	/**
	 * J_[̐ݒ͋܂B
	 */
	public void setCalendar(final Calendar newCalendar) {
		throw new RuntimeException("Method setCalendar() shouldn't be called");
	}

	/**
	 * NumberFormat ̐ݒ͋܂B
	 */
	public void setNumberFormat(final NumberFormat newNumberFormat) {
		throw new RuntimeException("Method setNumberFormat() shouldn't be called");
	}

}

/**
 * Helper class to deal with parsing the characters
 */
final class MailDateParser {

	int index = 0;
	char[] orig = null;

	public MailDateParser(final char[] orig) {
		this.orig = orig;
	}

	/**
	 * skips chars until it finds a number (0-9)
	 *
	 * if it does not find a number, it will throw
	 * an ArrayIndexOutOfBoundsException
	 */	
	public void skipUntilNumber() throws ParseException {
		try {
		    while (true) {
				switch (orig[index]) {
					case '0':
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
					case '8':
					case '9':
					    return;

					default:
					    index++;
					    break;	
				}
		    }
		} catch (ArrayIndexOutOfBoundsException e) {
		    throw new ParseException("No Number Found", index);
		}
	}

	/**
	 * skips any number of tabs, spaces, CR, and LF - folding whitespace
	 */
	public void skipWhiteSpace() {
		int len = orig.length;
		while (index < len) {
			switch (orig[index]) {
				case ' ': // space
				case '\t': // tab
				case '\r': // CR
				case '\n': // LF
					index++;
					break;

			    default:
					return;
		    }
		}
	}

	/**
	 * used to look at the next character without "parsing" that
	 * character.
	 */
	public int peekChar() throws ParseException {
		if (index < orig.length)
			return orig[index];
		throw new ParseException("No more characters", index);
	}

	/**
	 * skips the given character.  if the current char does not
	 * match a ParseException will be thrown
	 */
	public void skipChar(final char c) throws ParseException {
		if (index < orig.length) {
			if (orig[index] == c)
				index++;
			else
				throw new ParseException("Wrong char", index);
		} else
			throw new ParseException("No more characters", index);
	}

	/**
	 * will only skip the current char if it matches the given
	 * char
	 */
	public boolean skipIfChar(final char c) throws ParseException {
		if (index < orig.length) {
			if (orig[index] == c) {
				index++;
				return true;
			}
			return false;
		}
		throw new ParseException("No more characters", index);
	}

	/**
	 * current char must point to a number.  the number will be
	 * parsed and the resulting number will be returned.  if a
	 * number is not found, a ParseException will be thrown
	 */
	public int parseNumber() throws ParseException {
		int length = orig.length;
		boolean gotNum = false;
		int result = 0;

		while (index < length) {
			switch( orig[index] ) {
			case '0':
				result *= 10;
				gotNum = true;
				break;

			case '1':
				result = result * 10 + 1;
				gotNum = true;
				break;

			case '2':
				result = result * 10 + 2;
				gotNum = true;
				break;

			case '3':
				result = result * 10 + 3;
				gotNum = true;
				break;

			case '4':
				result = result * 10 + 4;
				gotNum = true;
				break;

			case '5':
				result = result * 10 + 5;
				gotNum = true;
				break;

			case '6':
				result = result * 10 + 6;
				gotNum = true;
				break;

			case '7':
				result = result * 10 + 7;
				gotNum = true;
				break;

			case '8':
				result = result * 10 + 8;
				gotNum = true;
				break;

			case '9':
				result = result * 10 + 9;
				gotNum = true;
				break;

			default:
				if (gotNum)
					return result;
				throw new ParseException("No Number found", index);
		    }

			index++;
		}

		// check the result
		if (gotNum)
			return result;

		// else, throw a parse error
		throw new ParseException("No Number found", index);
	}

	/**
	 * will look for one of "Jan/Feb/Mar/Apr/May/Jun/Jul/Aug/Sep/Oct/Nov/Dev"
	 * and return the numerical version of the month. (0-11).  a ParseException
	 * error is thrown if a month cannot be found.
	 */
	public int parseMonth() throws ParseException {
		char curr;

		try {
			switch(orig[index++]) {
				case 'B':
				case 'C':
				case 'E': 
				case 'G': 
				case 'H': 
				case 'I': 
				case 'K': 
				case 'L': 
				case 'P': 
				case 'Q': 
				case 'R': 
				case 'T': 
				case 'U': 
				case 'V': 
				case 'W': 
				case 'X': 
				case 'Y': 
				case 'Z': 
				case '[': 
				case '\\': 
				case ']': 
				case '^': 
				case '_': 
				case '`': 
				case 'b': 
				case 'c': 
				case 'e': 
				case 'g':
				case 'h':
				case 'i': 
				case 'k':
				case 'l':
				case 'p':
				case 'q':
				case 'r':
				default:
					break;

				case 'J':
				case 'j': // "Jan" (0) /  "Jun" (5) /  "Jul" (6)
					// check next char
					switch(orig[index++]) {
						case 'A':
						case 'a':
							curr = orig[index++];
							if (curr == 'N' || curr == 'n')
								return 0;
							break;

						case 'U':
						case 'u':
							curr = orig[index++];
							if (curr == 'N' || curr == 'n')
								return 5;
							else if (curr == 'L' || curr == 'l')
								return 6;
							break;
					}
					break;

				case 'F':
				case 'f': // "Feb"
					curr = orig[index++];
					if (curr == 'E' || curr == 'e') {
						curr = orig[index++];
						if (curr == 'B' || curr == 'b')
							return 1;
					}
					break;

				case 'M':
				case 'm': // "Mar" (2) /  "May" (4)
					curr = orig[index++];
					if (curr == 'A' || curr == 'a') {
						curr = orig[index++];
						if (curr == 'R' || curr == 'r')
							return 2;
						else if (curr == 'Y' || curr == 'y')
							return 4;
					}
					break;

				case 'A':
				case 'a': // "Apr" (3) /  "Aug" (7)
					curr = orig[index++];
					if (curr == 'P' || curr == 'p') {
						curr = orig[index++];
						if (curr == 'R' || curr == 'r')
							return 3;
					} else if (curr == 'U' || curr == 'u') {
						curr = orig[index++];
						if (curr == 'G' || curr == 'g')
							return 7;
					}
					break;

				case 'S':
				case 's': // "Sep" (8)
					curr = orig[index++];
					if (curr == 'E' || curr == 'e') {
						curr = orig[index++];
						if (curr == 'P' || curr == 'p')
							return 8;
					}
					break;

				case 'O':
				case 'o': // "Oct"
					curr = orig[index++];
					if (curr == 'C' || curr == 'c') {
						curr = orig[index++];
						if (curr == 'T' || curr == 't')
							return 9;
					}
					break;

				case 'N':
				case 'n': // "Nov"
					curr = orig[index++];
					if (curr == 'O' || curr == 'o') {
						curr = orig[index++];
						if (curr == 'V' || curr == 'v')
							return 10;
					}
					break;

				case 'D':
				case 'd': // "Dec"
					curr = orig[index++];
					if (curr == 'E' || curr == 'e') {
						curr = orig[index++];
						if (curr == 'C' || curr == 'c')
							return 11;
					}
					break;
		    }
		} catch (ArrayIndexOutOfBoundsException e) {}

		throw new ParseException("Bad Month", index);
	}

	/**
	 * will parse the timezone - either Numerical version (e.g. +0800, -0500)
	 * or the alpha version (e.g. PDT, PST).  the result will be returned in
	 * minutes needed to be added to the date to bring it to GMT.
	 */
	public int parseTimeZone() throws ParseException {
		if (index >= orig.length) 
			throw new ParseException("No more characters", index);

		char test = orig[index];
		if (test == '+' || test == '-')
			return parseNumericTimeZone();
		return parseAlphaTimeZone();
	}

	/**
	 * will parse the Numerical time zone version (e.g. +0800, -0500)
	 * the result will be returned in minutes needed to be added
	 * to the date to bring it to GMT.
	 */
	public int parseNumericTimeZone() throws ParseException {
		// we switch the sign if it is a '+'
		// since the time in the string we are
		// parsing is off from GMT by that amount.
		// and we want to get the time back into
		// GMT, so we substract it.
		boolean switchSign = false;
		char first = orig[index++];
		if (first == '+')
			switchSign = true;
		else if (first != '-')
			throw new ParseException("Bad Numeric TimeZone", index);	

		int tz = parseNumber();
		int offset = (tz / 100) * 60  + (tz % 100);
		if (switchSign)
			return -offset;
		return offset;
	}

	/**
	 * will parse the alpha time zone version (e.g. PDT, PST).
	 * the result will be returned in minutes needed to be added
	 * to the date to bring it to GMT.
	 */
	public int parseAlphaTimeZone() throws ParseException {
		int result = 0;
		boolean foundCommon = false;
		char curr;

		try {
			switch(orig[index++]) {
				case 'U':
				case 'u': // "UT"	/	Universal Time
					curr = orig[index++];
					if (curr == 'T' || curr == 't') {
						result = 0;
						break;
					}
					throw new ParseException("Bad Alpha TimeZone", index);

			case 'G':
			case 'g': // "GMT" ; Universal Time
				curr = orig[index++];
				if (curr == 'M' || curr == 'm') {
					curr = orig[index++];
					if (curr == 'T' || curr == 't') {
						result = 0;
						break;
					}
				}
				throw new ParseException("Bad Alpha TimeZone", index);	

			case 'E':
			case 'e': // "EST" / "EDT" ;  Eastern:  - 5/ - 4
				result = 300;
				foundCommon = true;
				break;

			case 'C':
			case 'c': // "CST" / "CDT" ;  Central:  - 6/ - 5
				result = 360;
				foundCommon = true;
				break;

			case 'M':
			case 'm': // "MST" / "MDT" ;  Mountain: - 7/ - 6
				result = 420;
				foundCommon = true;
				break;

			case 'P':
			case 'p': // "PST" / "PDT" ;  Pacific:  - 8/ - 7 
				result = 480;
				foundCommon = true;
				break;

			default:
				throw new ParseException("Bad Alpha TimeZone", index);
		    }
		} catch (ArrayIndexOutOfBoundsException e) {
		    throw new ParseException("Bad Alpha TimeZone", index);
		}

		if (foundCommon) {
			curr = orig[index++];
			if (curr == 'S' || curr == 's') {
				curr = orig[index++];
				if (curr != 'T' && curr != 't')
					throw new ParseException("Bad Alpha TimeZone", index);
			} else if (curr == 'D' || curr == 'd') {
				curr = orig[index++];
				if (curr == 'T' || curr != 't')
					// for daylight time
					result -= 60;
				else
					throw new ParseException("Bad Alpha TimeZone", index);
		    }
		}

		return result;
	}

	int getIndex() {
		return index;
	}

}
