/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package javax.mail.internet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;

/**
 * MimeMultipart NX́Amultipart f[^ɂ MIME Kgp钊 Multipart NX̎łB<p>
 * 
 * MimeMultipart ́AvC}^Cv "multipart" ł MimePart 
 *  (p[g <code>getContent()</code> \bhĂяoɂ) 擾邩A
 * V MimeMessage ̍쐬̈ꕔƂăNCAgɂ쐬ł܂B<p>
 * 
 * ftHg multipart Tu^Cv "mixed" łB
 *  multipart Tu^Cvł "alternative"  "related" ́A
 * MimeMultipart ̃TuNXƂĎA
 * ̃^Cv multipart Rec̕⑫IȃZ}eBNX郁\bhǉ鎖ɂĎł܂B
 * ̖ړÍAT[rXvoC_A[ JavaBean JҁA
 * yу[NCAg̓lȃTuNX Command Beans 쐬A
 * JavaBeans Activation Framework ɃCXg[āA
 * Cӂ JavaMail ƃNCAg̃NX𓧉ߓIɌAgpł悤ɂ鎖łB
 * ]āAMIME multipart nh͑̔Cӂ̃nhƓlɈA
 * multipart nh̒񋟏 JavaMail API 番܂B
 * ⑫I MimeMultipart TuNXȂꍇA
 * MIME multipart f[^̑SẴTu^Cv MimeMultipart IuWFNgƂČ܂B<p>
 * 
 * AvP[V́A<code>MimeMultipart(String Subtype)</code> RXgN^gp鎖ŁA
 * Cӂ̃Tu^Cv MIME multipart IuWFNg𒼐ڍ쐬ł܂B
 * Ⴆ΁A"multipart/alternative" IuWFNg쐬ɂ <code>new MimeMultipart("alternative")</code> gp܂B<p>
 * 
 * In the current implementation, the
 * <code>mail.mime.multipart.ignoremissingendboundary</code> System
 * property may be set to <code>false</code> to cause a
 * <code>MessagingException</code> to be thrown if the multipart
 * data does not end with the required end boundary line.  If this
 * property is set to <code>true</code> or not set, missing end
 * boundaries are not considered an error and the final body part
 * ends at the end of the data.
 */
public final class MimeMultipart extends Multipart {

	private static boolean ignoreMissingEndBoundary = true;
	private static boolean ignoreMissingBoundaryParameter = true;
	private static boolean bmparse = true;

	static {
		try {
			String s = System.getProperty("mail.mime.multipart.ignoremissingendboundary");
			// default to true
			ignoreMissingEndBoundary = s == null || !s.equalsIgnoreCase("false");
			s = System.getProperty("mail.mime.multipart.ignoremissingboundaryparameter");
			ignoreMissingBoundaryParameter = s == null || !s.equalsIgnoreCase("false");
			s = System.getProperty("mail.mime.multipart.bmparse");
			bmparse = s == null || !s.equalsIgnoreCase("false");
		} catch(SecurityException sex) {
			// 
		}
	}

	/**
	 * InputStream  DataSource łB
	 */
	protected DataSource ds = null;

	/**
	 * InputStream ̃f[^\͂ǂ܂BftHg true łB
	 * RXgN^ɍ\͂Kv InputStream  DataSource w肳Ăꍇ́Afalse ɐݒ肵܂B
	 */
	protected boolean parsed = true;

	private boolean complete = true;
	private String preamble = null;

	/**
	 * ftHg̃RXgN^łB MimeMultipart IuWFNg쐬܂B
	 * Rec` "multipart/mixed" ɐݒ肳܂Bӂ̋E񂪐A
	 * ̕ <code>contentType</code> tB[h "boundary" p[^ƂĐݒ肳܂B<p>
	 * 
	 * MimeBodyParts Œǉ邱Ƃł܂B
	 */
	public MimeMultipart() {
		this("mixed");
	}

	/**
	 * w肳ꂽTu^Cv MimeMultipart IuWFNg\z܂Bӂ̋E񂪐A
	 * ̕ <code>contentType</code> tB[h "boundary" p[^ƂĐݒ肳܂B<p>
	 * 
	 * MimeBodyParts Œǉ邱Ƃł܂B
	 */
	public MimeMultipart(final String subtype) {
		super();
		/*
		 * Compute a boundary string.
		 */
		String boundary = UniqueValue.getUniqueBoundaryValue();
		ContentType cType = new ContentType("multipart", subtype, null);
		cType.setParameter("boundary", boundary);
		contentType = cType.toString();
	}

	/**
	 * MimeMultipart IuWFNgƂ̖{Aw肳ꂽ DataSource \z܂B<p>
	 * 
	 * ̃RXgN^́Aw肳ꂽ DataSource 
	 *  MultipartDataSource IuWFNgł󋵂ȃP[XƂď܂B
	 * ̏ꍇÃ\bh́AMultipartDataSource IuWFNggp
	 * X[p[NX (܂AMultipart) RXgN^ĂяołB<p>
	 * 
	 * łȂꍇADataSource  MIME multipart oCgXg[񋟂镨ƌȂ܂B
	 * <code>parsed</code> tO false ɐݒ肳܂B{̃f[^KvȏꍇA
	 * p[T͂ DataSource ̃Rec` "boundary" p[^𒊏oA
	 * 'vAu' XLbvďIE܂ŃoCgǂݍ݁A
	 * Xg[̊ep[g MimeBodyParts 쐬܂B
	 * 
	 * @param ds MultipartDataSource ƂȂꍇ̂ DataSource
	 */
	public MimeMultipart(final DataSource ds) throws MessagingException {
		super();

		if (ds instanceof MessageAware) {
			MessageContext mc = ((MessageAware)ds).getMessageContext();
			setParent(mc.getPart());
		}

		if (ds instanceof MultipartDataSource) {
			// ask super to do this for us.
			setMultipartDataSource((MultipartDataSource)ds);
			return;
		}

		// 'ds' was not a MultipartDataSource, we have
		// to parse this ourself.
		parsed = false;
		this.ds = ds;
		contentType = ds.getContentType();
	}

	/**
	 * Tu^Cvݒ肵܂B
	 * ̃\bh̓NCAg쐬V MimeMultipart IuWFNgŌĂяoȂ΂Ȃ܂B
	 *  multipart IuWFNg̃ftHg̃Tu^Cv "mixed" łB<p>
	 * 
	 * @param subtype Subtype
	 */
	public synchronized void setSubType(final String subtype) throws MessagingException {
		ContentType cType = new ContentType(contentType);	
		cType.setSubType(subtype);
		contentType = cType.toString();
	}

	/**
	 * ܂܂ BodyPart IuWFNg̐Ԃ܂B
	 * 
	 * @return p[g̐
	 */
	public synchronized int getCount() throws MessagingException {
		parse();
		return super.getCount();
	}

	/**
	 * w肳ꂽ BodyPart 擾܂BBodyParts ɂ 0 n܂ԍt܂B
	 * 
	 * @param index v BodyPart ̃CfbNX
	 * @return Part
	 * @throws MessagingException vꂽ BodyPart ݂Ȃꍇ
	 */
	public synchronized BodyPart getBodyPart(final int index) throws MessagingException {
		parse();
		return super.getBodyPart(index);
	}

	/**
	 * w肳ꂽ ContentID (CID) ɂQƂ MimeBodyPart 擾܂B
	 * p[gȂꍇ null Ԃ܂B
	 * 
	 * @param CID vp[g ContentID
	 * @return Part
	 */
	public synchronized BodyPart getBodyPart(final String CID) throws MessagingException {
		parse();

		int count = getCount();
		for (int i = 0; i < count; i++) {
			MimeBodyPart part = (MimeBodyPart) getBodyPart(i);
			String s = part.getContentID();
			if (s != null && s.equals(CID))
				return part;    
		}
		return null;
	}

	/**
	 * Return true if the final boundary line for this multipart was seen.
	 * When parsing multipart content, this class will (by default) terminate parsing with no error if the end of input is reached before seeing the final multipart boundary line.
	 * In such a case, this method will return false.
	 * (If the System property "mail.mime.multipart.ignoremissingendboundary" is set to false, parsing such a message will instead throw a MessagingException.)
	 * 
	 * @return true if the final boundary line was seen
	 * @throws MessagingException
	 * @since JavaMail 1.4
	 */
	public boolean isComplete() throws MessagingException {
		parse();
		return complete;
	}

	/**
	 * Get the preamble text, if any, that appears before the first body part of this multipart.
	 * Some protocols, such as IMAP, will not allow access to the preamble text.
	 * 
	 * @return the preamble text, or null if no preamble
	 * @throws MessagingException
	 * @since JavaMail 1.4
	 */
	public String getPreamble() throws MessagingException {
		parse();
		return preamble;
	}

	/**
	 * Set the preamble text to be included before the first body part.
	 * Applications should generally not include any preamble text.
	 * In some cases it may be helpful to include preamble text with instructions for users of pre-MIME software.
	 * The preamble text should be complete lines, including newlines.
	 * 
	 * @param preamble the preamble text
	 * @throws MessagingException
	 * @since JavaMail 1.4
	 */
	public void setPreamble(final String preamble) throws MessagingException {
		this.preamble = preamble;
	}

	/**
	 * wb_XV܂Bł̃ftHg̎́A
	 * q BodyParts ̂ꂼ <code>updateHeaders</code> \bhĂяołB<p>
	 * 
	 * V MimeMultipart IuWFNg쐬ꍇA
	 * Ep[^͊ɐݒ肳Ă鎖ɒӂĉB<p>
	 * 
	 * ̃\bh́A Multipart ܂ Message IuWFNg <code>saveChanges</code> \bhĂяo鎞ɌĂяo܂B
	 * ͈ʂ Message M̈ꕔƂčs܂A
	 * NCAg牽xłĂяo\ł鎖ɒӂĉB
	 * ]āAwb_XV MimeMultipart TuNXɂƂĕׂdꍇA
	 * ԂۂɕωǂǐՂAKvȏꍇɂ̂݃wb_XVs܂B
	 */
	protected void updateHeaders() throws MessagingException {
		for (int i = 0; i < parts.size(); i++)
			((MimeBodyPart)parts.elementAt(i)).updateHeaders();
	}

	/**
	 * SẴp[gʂČJԂAEŋ؂ꂽe Mime p[go͂܂B
	 */
	public void writeTo(final OutputStream os) throws IOException, MessagingException {
		parse();

		String boundary = "--" + (new ContentType(contentType)).getParameter("boundary");
		LineOutputStream los = new LineOutputStream(os);

		if (preamble != null) {
			byte[] bytes = ASCIIUtility.getBytes(preamble);
			los.write(bytes);
			if (bytes.length > 0 && bytes[bytes.length - 1] != 13 && bytes[bytes.length - 1] != 10)
				los.writeln();
		}

		for (int i = 0; i < parts.size(); i++) {
			los.writeln(boundary); // put out boundary
			((MimeBodyPart)parts.elementAt(i)).writeTo(os);
			los.writeln(); // put out empty line
		}

		// put out last boundary
		los.writeln(boundary + "--");
	}

	/**
	 * DataSource  InputStream \͂AK؂ MimeBodyParts \z܂B
	 * <code>parsed</code> tO true ɐݒ肳܂B
	 * Ă΂ꂽ true ̏ꍇ͉s܂B
	 * ̃\bh͖{̃f[^Kvȑ̑SẴ\bhɂĂяoA
	 * f[^\͍ς݂ł鎖ۏ؂܂B
	 * 
	 * @since JavaMail 1.2
	 */
	protected synchronized void parse() throws MessagingException {
		if (parsed)
			return;

		if (bmparse) {
			parsebm();
			return;
		}

		InputStream in = null;
		SharedInputStream sin = null;
		long start = 0, end = 0;

		try {
			in = ds.getInputStream();
			if (!(in instanceof ByteArrayInputStream) && !(in instanceof BufferedInputStream) && !(in instanceof SharedInputStream))
				in = new BufferedInputStream(in);
		} catch(Exception ex) {
			throw new MessagingException("No inputstream from datasource");
		}
		if (in instanceof SharedInputStream)
			sin = (SharedInputStream) in;

		ContentType cType = new ContentType(contentType);
		String boundary = null;
		String s1 = cType.getParameter("boundary");
		if (s1 != null)
			boundary = "--" + s1;
		else if (!ignoreMissingBoundaryParameter)
			throw new MessagingException("Missing boundary parameter");

		try {
			// Skip the preamble
			LineInputStream lin = new LineInputStream(in);
			String separator = null;
			String line;
			while ((line = lin.readLine()) != null) {
				/*
				 * Strip trailing whitespace.  Can't use trim method
				 * because it's too aggressive.  Some bogus MIME
				 * messages will include control characters in the
				 * boundary string.
				 */
				int i;
				for (i = line.length() - 1; i >= 0; i--) {
					char c = line.charAt(i);
					if (c != ' ' && c != '\t')
						break;
				}
				line = line.substring(0, i + 1);
				if (boundary != null) {
					if (line.equals(boundary))
						break;
				} else if (line.startsWith("--")) {
					boundary = line;
					break;
				}
				if (line.length() > 0) {
					if (separator == null)
						try {
							separator = System.getProperty("line.separator", "\n");
						} catch (SecurityException sex) {
							separator = "\n";
						}
					if (preamble == null)
						preamble = line + separator;
					else
						preamble += line + separator;
				}
			}
			if (line == null)
				throw new MessagingException("Missing start boundary");

			byte[] bndbytes = ASCIIUtility.getBytes(boundary);
			int bl = bndbytes.length;

			/*
			 * Read and process body parts until we see the
			 * terminating boundary line (or EOF).
			 */
			for(boolean done = false; !done;) {
				InternetHeaders headers = null;
				if (sin != null) {
					start = sin.getPosition();
					// skip headers
					while ((line = lin.readLine()) != null && line.length() > 0)
						;
					if (line == null) {
						if (!ignoreMissingEndBoundary)
							throw new MessagingException("missing multipart end boundary");
						complete = false;
						break;
					}
				} else
					// collect the headers for this body part
					headers = createInternetHeaders(in);

				if (!in.markSupported())
					throw new MessagingException("Stream doesn't support mark");

				ByteArrayOutputStream buf = null;
				// if we don't have a shared input stream, we copy the data
				if (sin == null)
					buf = new ByteArrayOutputStream();
				else
					end = sin.getPosition();

				int b;
				boolean bol = true;    // beginning of line flag
				// the two possible end of line characters
				int eol1 = -1, eol2 = -1;

				/*
				 * Read and save the content bytes in buf.
				 */
				for (;;) {
					if (bol) {
						/*
						 * At the beginning of a line, check whether the
						 * next line is a boundary.
						 */
						int i;
						in.mark(bl + 4 + 1000); // bnd + "--\r\n" + lots of LWSP
						// read bytes, matching against the boundary
						for (i = 0; i < bl; i++)
							if (in.read() != (bndbytes[i] & 0xff))
								break;
						if (i == bl) {
							// matched the boundary, check for last boundary
							int b2 = in.read();
							if (b2 == '-' && in.read() == '-') {
								complete = true;
								done = true;
								break;	// ignore trailing text
							}
							// skip linear whitespace
							while (b2 == ' ' || b2 == '\t')
								b2 = in.read();
							// check for end of line
							if (b2 == '\n')
								break;	// got it!  break out of the loop
							if (b2 == '\r') {
								in.mark(1);
								if (in.read() != '\n')
									in.reset();
								break;	// got it!  break out of the loop
							}
						}
						// failed to match, reset and proceed normally
						in.reset();

						// if this is not the first line, write out the
						// end of line characters from the previous line
						if (buf != null && eol1 != -1) {
							buf.write(eol1);
							if (eol2 != -1)
								buf.write(eol2);
							eol1 = eol2 = -1;
						}
					}

					// read the next byte
					if ((b = in.read()) < 0) {
						if (!ignoreMissingEndBoundary)
							throw new MessagingException("missing multipart end boundary");
						complete = false;
						done = true;
						break;
					}

					/*
					 * If we're at the end of the line, save the eol characters
					 * to be written out before the beginning of the next line.
					 */
					if (b == '\r' || b == '\n') {
						bol = true;
						if (sin != null)
							end = sin.getPosition() - 1;
						eol1 = b;
						if (b == '\r') {
							in.mark(1);
							if ((b = in.read()) == '\n')
								eol2 = b;
							else
								in.reset();
						}
					} else {
						bol = false;
						if (buf != null)
							buf.write(b);
					}
				};

				/*
				 * Create a MimeBody element to represent this body part.
				 */
				MimeBodyPart part;
				if (sin != null)
					part = createMimeBodyPart(sin.newStream(start, end));
				else
					part = createMimeBodyPart(headers, buf.toByteArray());
				addBodyPart(part);
			}
		} catch (IOException ioex) {
			throw new MessagingException("IO Error", ioex);
		} finally {
			try {
				in.close();
			} catch (IOException cex) {
				// 
			}
		}

		parsed = true;
	}

	private synchronized void parsebm() throws MessagingException {
		if (parsed)
			return;

		InputStream in = null;
		SharedInputStream sin = null;
		long start = 0, end = 0;

		try {
			in = ds.getInputStream();
			if (!(in instanceof ByteArrayInputStream) && !(in instanceof BufferedInputStream) && !(in instanceof SharedInputStream))
				in = new BufferedInputStream(in);
		} catch (Exception ex) {
			throw new MessagingException("No inputstream from datasource");
		}
		if (in instanceof SharedInputStream)
			sin = (SharedInputStream) in;

		ContentType cType = new ContentType(contentType);
		String boundary = null;
		String s1 = cType.getParameter("boundary");
		if (s1 != null)
			boundary = "--" + s1;
		else if (!ignoreMissingBoundaryParameter)
			throw new MessagingException("Missing boundary parameter");

		try {
			// Skip the preamble
			LineInputStream lin = new LineInputStream(in);
			String separator = null;
			String line;
			while ((line = lin.readLine()) != null) {
				/*
				 * Strip trailing whitespace.  Can't use trim method
				 * because it's too aggressive.  Some bogus MIME
				 * messages will include control characters in the
				 * boundary string.
				 */
				int i;
				for (i = line.length() - 1; i >= 0; i--) {
					char c = line.charAt(i);
					if (c != ' ' && c != '\t')
						break;
				}
				line = line.substring(0, i + 1);
				if (boundary != null) {
					if (line.equals(boundary))
						break;
				} else if (line.startsWith("--")) {
					boundary = line;
					break;
				}

				if (line.length() > 0) {
					if (separator == null)
						try {
							separator = System.getProperty("line.separator", "\n");
						} catch (SecurityException securityexception) {
							separator = "\n";
						}
					if (preamble == null)
						preamble = line + separator;
					else
						preamble += line + separator;
				}
			}
			if (line == null)
				throw new MessagingException("Missing start boundary");

			byte[] bndbytes = ASCIIUtility.getBytes(boundary);
			int bl = bndbytes.length;

			int ai[] = new int[256];
			for (int i = 0; i < bl; i++)
				ai[bndbytes[i]] = i + 1;
			int ai1[] = new int[bl];

		getparts:
			for (int i = bl; i > 0; i--) {
				int j;
				for (j = bl - 1; j >= i; j--) {
					if (bndbytes[j] != bndbytes[j - i])
						continue getparts;
					ai1[j - 1] = i;
				}

				while (j > 0) 
					ai1[--j] = i;
			}

			ai1[bl - 1] = 1;
			for (boolean done = false; !done;) {
				InternetHeaders headers = null;
				if (sin != null) {
					start = sin.getPosition();
					// skip headers
					while ((line = lin.readLine()) != null && line.length() > 0)
						;
					if (line == null) {
						if (!ignoreMissingEndBoundary)
							throw new MessagingException("missing multipart end boundary");
						// assume there's just a missing end boundary
						complete = false;
						break;
					}
				} else
					// collect the headers for this body part
					headers = createInternetHeaders(in);

				if (!in.markSupported())
					throw new MessagingException("Stream doesn't support mark");

				ByteArrayOutputStream buf = null;
				// if we don't have a shared input stream, we copy the data
				if (sin == null)
					buf = new ByteArrayOutputStream();
				else
					end = sin.getPosition();

				byte[] abyte1 = new byte[bl];
				byte[] abyte2 = new byte[bl];
				int i = 0;
				int i2 = 0;
				boolean bol = true;	// beginning of line flag
				int j2;

				do {
					in.mark(bl + 4 + 1000);
					j2 = 0;
					i = in.read(abyte1, 0, bl);

					if (i < bl) {
						if (!ignoreMissingEndBoundary)
							throw new MessagingException("missing multipart end boundary");
						if (sin != null)
							end = sin.getPosition();
						complete = false;
						done = true;
						break;
					}

					int k2;
					for (k2 = bl - 1; k2 >= 0; k2--)
						if (abyte1[k2] != bndbytes[k2])
							break;

					if (k2 < 0) {
						j2 = 0;

						if (!bol) {
							byte b = abyte2[i2 - 1];
							/*
							 * If we're at the end of the line, save the eol characters
							 * to be written out before the beginning of the next line.
							 */
							if (b == '\r' || b == '\n') {
								j2 = 1;
								if (b == '\n' && i2 >= 2) {
									if (abyte2[i2 - 2] == '\r')
										j2 = 2;
								}
							}
						}

						if (bol || j2 > 0) {
							if (sin != null)
								end = sin.getPosition() - (long)bl - (long)j2;
							// matched the boundary, check for last boundary
							int b2 = in.read();
							if (b2 == '-' && in.read() == '-') {
								complete = true;
								done = true;
								break;	// ignore trailing text
							}
							// skip linear whitespace
							while (b2 == ' ' || b2 == '\t')
								b2 = in.read();
							if (b2 == '\n')
								break;	// got it!  break out of the loop
							if (b2 == '\r') {
								in.mark(1);
								if (in.read() != '\n')
									in.reset();
								break;	// got it!  break out of the loop
							}
						}

						k2 = 0;
					}

					int max = Math.max((k2 + 1) - ai[abyte1[k2] & 127], ai1[k2]);
					if (max < 2) {
						if (sin == null && i2 > 1)
							buf.write(abyte2, 0, i2 - 1);

						in.reset();
						in.skip(1);

						if (i2 >= 1) {
							abyte2[0] = abyte2[i2 - 1];
							abyte2[1] = abyte1[0];
							i2 = 2;
						} else {
							abyte2[0] = abyte1[0];
							i2 = 1;
						}
					} else {
						if (i2 > 0 && sin == null)
							buf.write(abyte2, 0, i2);
						i2 = max;
						in.reset();
						in.skip(i2);
						byte abyte3[] = abyte1;
						abyte1 = abyte2;
						abyte2 = abyte3;
					}
					bol = false;
				} while (true);

				/*
				 * Create a MimeBody element to represent this body part.
				 */
				MimeBodyPart part;
				if (sin != null) {
					part = createMimeBodyPart(sin.newStream(start, end));
				} else {
					if (i2 - j2 > 0)
						buf.write(abyte2, 0, i2 - j2);
					if (!complete && i > 0)
						buf.write(abyte1, 0, i);
					part = createMimeBodyPart(headers, buf.toByteArray());
				}
				addBodyPart(part);
			}
		} catch (IOException ioex) {
			throw new MessagingException("IO Error", ioex);
		} finally {
			try {
				in.close();
			} catch (IOException cex) {
				// 
			}
		}

		parsed = true;
	}

	/**
	 * w肳ꂽ InputStream wb_[h InternetHeaders IuWFNg쐬AԂ܂B
	 * Kvł΁ATuNX͂̃\bhI[o[ChAInternetHeaders ̃TuNXԂł܂B
	 * ̎͒P InternetHeaders IuWFNg\zAԂ܂B
	 * 
	 * @param is wb_ǂݍ݌ InputStream
	 * @throws MessagingException
	 * @since JavaMail 1.2
	 */
	protected InternetHeaders createInternetHeaders(final InputStream is) throws MessagingException {
		return new InternetHeaders(is);
	}

	/**
	 * InputStream \͂{\ MimeBodyPart IuWFNg쐬AԂ܂B
	 * Kvł΁ATuNX͂̃\bhI[o[ChAMimeBodyPart ̃TuNXԂł܂B
	 * ̎͒P MimeBodyPart IuWFNg\zAԂ܂B
	 * 
	 * @param headers {̃wb_
	 * @param content {̃Rec
	 * @throws MessagingException
	 * @since JavaMail 1.2
	 */
	protected MimeBodyPart createMimeBodyPart(final InternetHeaders headers, final byte[] content) /* throws MessagingException */ {
		return new MimeBodyPart(headers, content);
	}

	/**
	 * InputStream \͂{\ MimeBodyPart IuWFNg쐬AԂ܂B
	 * Kvł΁ATuNX͂̃\bhI[o[ChAMimeBodyPart ̃TuNXԂł܂B
	 * ̎͒P MimeBodyPart IuWFNg\zAԂ܂B
	 * 
	 * @param is {܂ InputStream
	 * @throws MessagingException
	 * @since JavaMail 1.2
	 */
	protected MimeBodyPart createMimeBodyPart(final InputStream is) throws MessagingException {
		return new MimeBodyPart(is);
	}

}
